/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.ExplorerParams;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.PayProxyFunctionConstant;
import com.xunlei.payproxy.vo.Bizorderok;
import com.xunlei.payproxy.vo.Bizorderokhis;
import com.xunlei.payproxy.vo.Copartners;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import com.xunlei.payproxy.web.model.TxtParams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.model.SelectItem;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyBizorderok")
public class BizorderokManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(BizorderokManagedBean.class);
    private static Map<String, String> paytypeMap;
    private static SelectItem[] paytypeItem;
    private static Map<String, String> remarkMap;
    private static SelectItem[] remarkItem;
    private static Object lock;
    private static Map<String, String> ordertypeMap;
    private static SelectItem[] ordertypeItem;

    public String getQueryBizorderokList() {
        long starttime = new Date().getTime();
        logger.info("start query at time : " + starttime);
        this.authenticateRun();
        Bizorderok bizorderok = (Bizorderok)this.findBean(Bizorderok.class, "payproxy_bizorderok");
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("successtime desc");
        if (bizorderok != null) {
            if (StringTools.isEmpty((String)bizorderok.getFromdate())) {
                bizorderok.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)bizorderok.getTodate())) {
                bizorderok.setTodate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)bizorderok.getBizno())) {
                bizorderok.setBiznos(this.biznosByRecRole());
            }
            if (!bizorderok.getFromdate().substring(0, 4).equals(DatetimeUtil.today().substring(0, 4))) {
                this.alertJS("\u4e0d\u5141\u8bb8\u8fdb\u884c\u8de8\u5e74\u67e5\u8be2\uff0c\u8bf7\u8f6c\u5230\u5386\u53f2\u8868\u67e5\u8be2");
                return "";
            }
            ArrayList list = new ArrayList();
            logger.info("fromdate=" + bizorderok.getFromdate() + ", todate=" + bizorderok.getTodate());
            list = (ArrayList)this.getTables(bizorderok.getFromdate(), bizorderok.getTodate());
            Collections.sort(list);
            logger.info("\u67e5\u8be2\u7684list\u8868\u4e3a\uff1a" + list);
            Sheet sheet = facade.queryBizorderokListByChangeSeqid(bizorderok, fliper, (List)list);
            long endtime = new Date().getTime();
            logger.info("end query at time : " + endtime);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public List<String> getTablesEmpty(String fromdate, String todate) {
        String toQuartTable;
        ArrayList<String> resultList = new ArrayList<String>();
        String fromQuartTable = this.getBizroderokQuartTable(fromdate);
        if (fromQuartTable.equals(toQuartTable = this.getBizroderokQuartTable(todate))) {
            resultList.add(fromQuartTable);
        } else {
            String fromQuartNum = this.getQuart(Integer.parseInt(fromdate.substring(5, 7)));
            String toQuartNum = this.getQuart(Integer.parseInt(todate.substring(5, 7)));
            for (int i = Integer.valueOf(fromQuartNum).intValue(); i <= Integer.valueOf(toQuartNum); ++i) {
                logger.info("\u5b63\u5ea6\u4e3a\uff1a" + i);
                resultList.add("bizorderok_" + fromdate.substring(0, 4) + "Q" + i);
            }
        }
        return resultList;
    }

    public List<String> getTables(String fromdate, String todate) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (BizorderokManagedBean.befSevenDays(fromdate) < 0 && BizorderokManagedBean.befSevenDays(todate) < 0) {
            resultList = this.getTablesEmpty(fromdate, todate);
        } else if (BizorderokManagedBean.befSevenDays(fromdate) < 0 || BizorderokManagedBean.befSevenDays(todate) < 0) {
            resultList = this.getTablesEmpty(fromdate, todate);
            resultList.add("bizorderok");
        } else {
            resultList.add("bizorderok");
        }
        return resultList;
    }

    public String getBizroderokQuartTable(String date) {
        logger.info("getBizroderokQuartTable-----\u67e5\u8be2\u7684\u65e5\u671f\u4e3a\uff1a" + date);
        int frommonth = Integer.parseInt(date.substring(5, 7));
        return "bizorderok_" + date.substring(0, 4) + "Q" + this.getQuart(frommonth);
    }

    public String getQuart(int month) {
        if (month >= 1 && month <= 3) {
            return "1";
        }
        if (month >= 4 && month <= 6) {
            return "2";
        }
        if (month >= 7 && month <= 9) {
            return "3";
        }
        return "4";
    }

    public String noticeSome() {
        this.authenticateAdd();
        String xunleipayids = this.findParameter("noticepayids");
        if (this.isNotEmpty(xunleipayids)) {
            String[] xlpids;
            for (String seqid : xlpids = xunleipayids.split("\\|")) {
                logger.info("noticeSome-----seqid: " + seqid);
                Bizorderok bizorderok = new Bizorderok();
                long seqidLong = 0L;
                String table = "";
                if (seqid.endsWith("00000")) {
                    seqidLong = Long.parseLong(seqid.substring(0, seqid.length() - 5));
                    table = "bizorderok";
                } else if (seqid.endsWith("11111")) {
                    seqidLong = Long.parseLong(seqid.substring(0, seqid.length() - 5));
                    table = "bizorderok_" + DatetimeUtil.today().substring(0, 4) + "Q1";
                } else if (seqid.endsWith("22222")) {
                    seqidLong = Long.parseLong(seqid.substring(0, seqid.length() - 5));
                    table = "bizorderok_" + DatetimeUtil.today().substring(0, 4) + "Q2";
                } else if (seqid.endsWith("33333")) {
                    seqidLong = Long.parseLong(seqid.substring(0, seqid.length() - 5));
                    table = "bizorderok_" + DatetimeUtil.today().substring(0, 4) + "Q3";
                } else if (seqid.endsWith("44444")) {
                    seqidLong = Long.parseLong(seqid.substring(0, seqid.length() - 5));
                    table = "bizorderok_" + DatetimeUtil.today().substring(0, 4) + "Q4";
                }
                logger.info("seqid=" + seqidLong + ",table=" + table);
                Bizorderok queryBizorderok = new Bizorderok();
                queryBizorderok.setSeqid(seqidLong);
                bizorderok = facade.findBizorderokByTable(queryBizorderok, table);
                String type = bizorderok.getType();
                String xunleipayid = bizorderok.getXunleipayid();
                logger.info("seqid[" + seqidLong + "]\u83b7\u53d6\u7684xunleipayid=" + xunleipayid + ", type=" + type);
                if (type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_TRADE)) {
                    PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)xunleipayid);
                    continue;
                }
                if (!type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_REFUND_PLATFORM) && !type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_REFUND_USER)) continue;
                PayProxyJmsMessageSender.sendRefundBizorderokByXunleiPayId((String)xunleipayid);
            }
            this.alertJS("\u53d1\u9001\u901a\u77e5\u5b8c\u6210");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportExcel() {
        logger.debug("start exportExcel");
        Object object = lock;
        synchronized (object) {
            block20: {
                this.authenticateRun();
                String optselectedids = this.findParameter("optselectedids");
                String optselectednodenames = this.findParameter("optselectednodenames");
                try {
                    String excelPath = this.getHttpServletRequest().getSession().getServletContext().getRealPath("") + File.separator + "WEB-INF" + File.separator + "download" + File.separator + "bizorderok_detail.xls";
                    File excelFile = new File(excelPath);
                    File folder = new File(excelPath.substring(0, excelPath.lastIndexOf(File.separator)));
                    if (!folder.exists()) {
                        excelFile.mkdirs();
                    }
                    if (excelFile.exists()) {
                        excelFile.delete();
                        excelFile.createNewFile();
                    } else {
                        excelFile.createNewFile();
                    }
                    ExplorerParams explorerParams = new ExplorerParams();
                    WritableWorkbook book = Workbook.createWorkbook((File)new File(excelPath));
                    String[] tHeadNames = optselectednodenames.split(",");
                    String[] tDataFieldNames = optselectedids.split(",");
                    if (!this.isNotEmpty(optselectedids)) break block20;
                    String[] optIds = optselectedids.split(",");
                    Bizorderok bizorderok = (Bizorderok)this.findBean(Bizorderok.class, "payproxy_bizorderok");
                    int pagesize = 30000;
                    if (bizorderok != null && optIds != null) {
                        if (BizorderokManagedBean.befSevenDays(bizorderok.getFromdate()) < 0 && BizorderokManagedBean.befSevenDays(bizorderok.getTodate()) < 0) {
                            Bizorderokhis bizorderokhis = new Bizorderokhis();
                            bizorderokhis = BizorderokManagedBean.copyTohis(bizorderokhis, bizorderok);
                            int counts = facade.queryBizorderokhisCount(bizorderokhis, null, 0L);
                            PagedFliper fliper = new PagedFliper();
                            fliper.setPageSize(pagesize);
                            fliper.setSortColumn("seqid");
                            long seqid = 0L;
                            for (int i = 0; i < (int)Math.ceil((double)counts * 1.0 / (double)pagesize); ++i) {
                                ArrayList hislist = new ArrayList();
                                Collection collection = facade.queryBizorderokhis(bizorderokhis, fliper, seqid).getDatas();
                                if (collection == null || collection.size() == 0) continue;
                                hislist = (ArrayList)collection;
                                logger.debug("hislist size:" + hislist.size());
                                this.writeToExcel(book, i, tHeadNames, tDataFieldNames, hislist, excelFile, bizorderokhis.getClass());
                                seqid = ((Bizorderokhis)hislist.get(hislist.size() - 1)).getSeqid();
                            }
                        } else if (BizorderokManagedBean.befSevenDays(bizorderok.getFromdate()) < 0 && BizorderokManagedBean.befSevenDays(bizorderok.getTodate()) >= 0) {
                            Collection collection;
                            Bizorderokhis bizorderokhis = new Bizorderokhis();
                            bizorderokhis = BizorderokManagedBean.copyTohis(bizorderokhis, bizorderok);
                            int counts = facade.queryBizorderokhisCount(bizorderokhis, null, 0L);
                            PagedFliper fliper = new PagedFliper();
                            fliper.setPageSize(pagesize);
                            fliper.setSortColumn("seqid");
                            long seqid = 0L;
                            for (int i = 0; i < counts / pagesize; ++i) {
                                ArrayList hislist = new ArrayList();
                                collection = facade.queryBizorderokhis(bizorderokhis, fliper, seqid).getDatas();
                                if (collection == null || collection.size() == 0) continue;
                                hislist = (ArrayList)collection;
                                logger.debug("hislist size:" + hislist.size());
                                this.writeToExcel(book, i, tHeadNames, tDataFieldNames, hislist, excelFile, bizorderokhis.getClass());
                                seqid = ((Bizorderokhis)hislist.get(hislist.size() - 1)).getSeqid();
                            }
                            Collection collection2 = facade.queryBizorderokhis(bizorderokhis, fliper, seqid).getDatas();
                            ArrayList<String> tables = new ArrayList<String>();
                            tables.add("bizorderok");
                            collection = facade.queryBizorderokhis(bizorderokhis, null, tables).getDatas();
                            collection2.addAll(collection);
                            if (collection2 != null && collection2.size() != 0) {
                                ArrayList hisListTmp = (ArrayList)collection2;
                                logger.debug("list size:" + hisListTmp.size());
                                if (hisListTmp != null && hisListTmp.size() != 0) {
                                    for (int i = 0; i < (int)Math.ceil((double)hisListTmp.size() / ((double)pagesize * 1.0)); ++i) {
                                        List<Object> subList = hisListTmp.subList(pagesize * i, pagesize * (i + 1) > hisListTmp.size() ? hisListTmp.size() : pagesize * (i + 1));
                                        logger.debug(Arrays.toString(subList.toArray()));
                                        this.writeToExcel(book, counts / pagesize + i, tHeadNames, tDataFieldNames, subList, excelFile, bizorderokhis.getClass());
                                    }
                                }
                            }
                        } else {
                            ArrayList list = new ArrayList();
                            list = (ArrayList)facade.queryBizorderok(bizorderok, null).getDatas();
                            if (list != null && list.size() != 0) {
                                for (int i = 0; i < (int)Math.ceil((double)list.size() / ((double)pagesize * 1.0)); ++i) {
                                    List<Object> subList = list.subList(pagesize * i, pagesize * (i + 1) > list.size() ? list.size() : pagesize * (i + 1));
                                    this.writeToExcel(book, i, tHeadNames, tDataFieldNames, subList, excelFile, bizorderok.getClass());
                                }
                            }
                        }
                    }
                    book.write();
                    book.close();
                    this.alertJS("\u5bfc\u51faexcel\u6587\u4ef6\u5b8c\u6210");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    this.alertJS("\u5bfc\u51fa\u6587\u4ef6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportTxt() {
        logger.debug("start exportTxt");
        Object object = lock;
        synchronized (object) {
            block47: {
                this.authenticateRun();
                String optselectedids = this.findParameter("optselectedids");
                String optselectednodenames = this.findParameter("optselectednodenames");
                BufferedOutputStream bos = null;
                try {
                    String txtPath = this.getHttpServletRequest().getSession().getServletContext().getRealPath("") + File.separator + "WEB-INF" + File.separator + "download" + File.separator + "bizorderok_detail.txt";
                    File txtFile = new File(txtPath);
                    File folder = new File(txtPath.substring(0, txtPath.lastIndexOf(File.separator)));
                    if (!folder.exists()) {
                        txtFile.mkdirs();
                    }
                    if (txtFile.exists()) {
                        txtFile.delete();
                        txtFile.createNewFile();
                    } else {
                        txtFile.createNewFile();
                    }
                    TxtParams txtParams = new TxtParams();
                    txtParams.setHeaderFieldNames(optselectednodenames.split(","));
                    if (!this.isNotEmpty(optselectedids)) break block47;
                    String[] optIds = optselectedids.split(",");
                    Bizorderok bizorderok = (Bizorderok)this.findBean(Bizorderok.class, "payproxy_bizorderok");
                    if (bizorderok == null || optIds == null) break block47;
                    txtParams.setDataFieldNames(optIds);
                    if (bizorderok == null || optIds == null) break block47;
                    if (StringTools.isEmpty((String)bizorderok.getFromdate())) {
                        bizorderok.setFromdate(DatetimeUtil.today());
                    }
                    if (StringTools.isEmpty((String)bizorderok.getTodate())) {
                        bizorderok.setTodate(DatetimeUtil.today());
                    }
                    if (StringTools.isEmpty((String)bizorderok.getBizno())) {
                        bizorderok.setBiznos(this.biznosByRecRole());
                    }
                    if (!bizorderok.getFromdate().substring(0, 4).equals(DatetimeUtil.today().substring(0, 4))) {
                        this.alertJS("\u4e0d\u5141\u8bb8\u8fdb\u884c\u8de8\u5e74\u67e5\u8be2\uff0c\u8bf7\u8f6c\u5230\u5386\u53f2\u8868\u67e5\u8be2");
                        String string = "";
                        return string;
                    }
                    txtParams.setDataFieldNames(optIds);
                    if (bizorderok != null && optIds != null) {
                        String table;
                        int i;
                        int pageSize = 200000;
                        PagedFliper fliper = this.getFliper();
                        fliper.setSortColumnIfEmpty("successtime desc");
                        fliper.setPageSize(pageSize);
                        ArrayList<String> tables = new ArrayList<String>();
                        int fromMonth = Integer.parseInt(bizorderok.getFromdate().substring(5, 7));
                        int toMonth = Integer.parseInt(bizorderok.getTodate().substring(5, 7));
                        if (BizorderokManagedBean.befSevenDays(bizorderok.getFromdate()) < 0 && BizorderokManagedBean.befSevenDays(bizorderok.getTodate()) < 0) {
                            for (i = fromMonth; i <= toMonth; ++i) {
                                table = "bizorderok_" + bizorderok.getFromdate().substring(0, 4) + "Q" + (int)Math.ceil((i + 2) / 3);
                                if (tables.contains(table)) continue;
                                tables.add(table);
                            }
                        } else if (BizorderokManagedBean.befSevenDays(bizorderok.getFromdate()) < 0 && BizorderokManagedBean.befSevenDays(bizorderok.getTodate()) >= 0) {
                            for (i = fromMonth; i <= toMonth; ++i) {
                                table = "bizorderok_" + bizorderok.getFromdate().substring(0, 4) + "Q" + (int)Math.ceil((i + 2) / 3);
                                if (tables.contains(table)) continue;
                                tables.add(table);
                            }
                            tables.add("bizorderok");
                        } else if (BizorderokManagedBean.befSevenDays(bizorderok.getFromdate()) >= 0 && BizorderokManagedBean.befSevenDays(bizorderok.getTodate()) >= 0) {
                            tables.add("bizorderok");
                        }
                        logger.info("exportTxtAgo tables:" + Arrays.toString(tables.toArray()));
                        boolean first = true;
                        if (fliper.getSortColumn().toUpperCase().contains("SUCCESSTIME DESC")) {
                            for (int i2 = tables.size() - 1; i2 >= 0; --i2) {
                                String table2 = (String)tables.get(i2);
                                boolean haveNext = true;
                                int pageNo = 1;
                                while (haveNext) {
                                    fliper.setPageNo(pageNo);
                                    ArrayList datas = facade.queryBizorderokhisToTxtDatas(bizorderok, fliper, table2, optIds);
                                    this.writeToTxt(txtFile, txtParams, datas, first);
                                    first = false;
                                    if (datas.size() < fliper.getPageSize()) {
                                        haveNext = false;
                                    }
                                    ++pageNo;
                                }
                            }
                        } else {
                            for (int i3 = 0; i3 < tables.size(); ++i3) {
                                String table3 = (String)tables.get(i3);
                                boolean haveNext = true;
                                int pageNo = 1;
                                while (haveNext) {
                                    fliper.setPageNo(pageNo);
                                    ArrayList datas = facade.queryBizorderokhisToTxtDatas(bizorderok, fliper, table3, optIds);
                                    this.writeToTxt(txtFile, txtParams, datas, first);
                                    first = false;
                                    if (datas.size() < fliper.getPageSize()) {
                                        haveNext = false;
                                    }
                                    ++pageNo;
                                }
                            }
                        }
                    }
                    this.alertJS("\u5bfc\u51fatxt\u6587\u4ef6\u5b8c\u6210");
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage());
                    this.alertJS("\u5bfc\u51fa\u6587\u4ef6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                    this.alertJS("\u5bfc\u51fa\u6587\u4ef6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
                }
                finally {
                    try {
                        if (bos != null) {
                            bos.flush();
                            bos.close();
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage());
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String exportTxtAgo() {
        logger.debug("start exportTxtAgo");
        Object object = lock;
        synchronized (object) {
            this.authenticateRun();
            String optselectedids = this.findParameter("optselectedids");
            String optselectednodenames = this.findParameter("optselectednodenames");
            BufferedOutputStream bos = null;
            try {
                String txtPath = this.getHttpServletRequest().getSession().getServletContext().getRealPath("") + File.separator + "WEB-INF" + File.separator + "download" + File.separator + "bizorderok_detail.txt";
                File txtFile = new File(txtPath);
                File folder = new File(txtPath.substring(0, txtPath.lastIndexOf(File.separator)));
                if (!folder.exists()) {
                    txtFile.mkdirs();
                }
                if (txtFile.exists()) {
                    txtFile.delete();
                    txtFile.createNewFile();
                } else {
                    txtFile.createNewFile();
                }
                TxtParams txtParams = new TxtParams();
                txtParams.setHeaderFieldNames(optselectednodenames.split(","));
                if (!this.isNotEmpty(optselectedids)) return null;
                String[] optIds = optselectedids.split(",");
                Bizorderok bizorderok = (Bizorderok)this.findBean(Bizorderok.class, "payproxy_bizorderok");
                if (bizorderok != null) {
                    if (StringTools.isEmpty((String)bizorderok.getFromdate())) {
                        bizorderok.setFromdate(this.getLastDayOfLastyear());
                    }
                    if (StringTools.isEmpty((String)bizorderok.getTodate())) {
                        bizorderok.setTodate(this.getLastDayOfLastyear());
                    }
                    if (!bizorderok.getFromdate().substring(0, 4).equals(bizorderok.getTodate().substring(0, 4))) {
                        this.alertJS("\u8d77\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u4e3a\u540c\u4e00\u5e74");
                        String string = "";
                        return string;
                    }
                    List<String> queryYears = this.getQueryYears();
                    if (!queryYears.contains(bizorderok.getFromdate().substring(0, 4))) {
                        this.alertJS("\u67e5\u8be2\u65e5\u671f\u8d85\u51fa\u53ef\u67e5\u8baf\u8303\u56f4\uff0c\u53ef\u67e5\u5e74\u4efd\u4e3a\uff1a" + queryYears);
                        String e = "";
                        return e;
                    }
                    bizorderok.setYearofago(bizorderok.getFromdate().substring(0, 4));
                }
                if (bizorderok != null && optIds != null) {
                    txtParams.setDataFieldNames(optIds);
                    if (bizorderok != null && optIds != null) {
                        int i;
                        PagedFliper fliper = this.getFliper();
                        int pageSize = 200000;
                        fliper.setSortColumnIfEmpty("successtime desc");
                        fliper.setPageSize(pageSize);
                        ArrayList<String> tables = new ArrayList<String>();
                        if (bizorderok.getYearofago().equals("2009") || bizorderok.getYearofago().equals("2010") || bizorderok.getYearofago().equals("2011")) {
                            tables.add("bizorderokhis_" + bizorderok.getYearofago());
                        } else {
                            int fromMonth = Integer.parseInt(bizorderok.getFromdate().substring(5, 7));
                            int toMonth = Integer.parseInt(bizorderok.getTodate().substring(5, 7));
                            for (int i2 = fromMonth; i2 <= toMonth; ++i2) {
                                String table = "bizorderok_" + bizorderok.getYearofago() + "Q" + (int)Math.ceil((i2 + 2) / 3);
                                if (tables.contains(table)) continue;
                                tables.add(table);
                            }
                        }
                        logger.info("exportTxtAgo tables:" + Arrays.toString(tables.toArray()));
                        boolean first = true;
                        if (fliper.getSortColumn().toUpperCase().contains("SUCCESSTIME DESC")) {
                            for (i = tables.size() - 1; i >= 0; --i) {
                                String table = (String)tables.get(i);
                                boolean haveNext = true;
                                int pageNo = 1;
                                while (haveNext) {
                                    fliper.setPageNo(pageNo);
                                    ArrayList datas = facade.queryBizorderokhisToTxtDatas(bizorderok, fliper, table, optIds);
                                    this.writeToTxt(txtFile, txtParams, datas, first);
                                    first = false;
                                    if (datas.size() < fliper.getPageSize()) {
                                        haveNext = false;
                                    }
                                    ++pageNo;
                                }
                            }
                        } else {
                            for (i = 0; i < tables.size(); ++i) {
                                String table = (String)tables.get(i);
                                boolean haveNext = true;
                                int pageNo = 1;
                                while (haveNext) {
                                    fliper.setPageNo(pageNo);
                                    ArrayList datas = facade.queryBizorderokhisToTxtDatas(bizorderok, fliper, table, optIds);
                                    this.writeToTxt(txtFile, txtParams, datas, first);
                                    first = false;
                                    if (datas.size() < fliper.getPageSize()) {
                                        haveNext = false;
                                    }
                                    ++pageNo;
                                }
                            }
                        }
                    }
                }
                this.alertJS("\u5bfc\u51fatxt\u6587\u4ef6\u5b8c\u6210");
            }
            catch (UnsupportedEncodingException e) {
                logger.error(e.getMessage());
                this.alertJS("\u5bfc\u51fa\u6587\u4ef6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            }
            catch (IOException e) {
                logger.error(e.getMessage());
                this.alertJS("\u5bfc\u51fa\u6587\u4ef6\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
            }
            finally {
                try {
                    if (bos != null) {
                        bos.flush();
                        bos.close();
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
            return null;
        }
    }

    public Map<String, String> getPaytypeMap() {
        if (paytypeMap == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            paytypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paytypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paytypeMap;
    }

    public SelectItem[] getPaytypeItem() {
        if (paytypeItem == null) {
            List list = facade.getLibclassdByClassNo("PayTypeShow");
            if (list == null) {
                paytypeItem = new SelectItem[0];
            } else {
                paytypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    BizorderokManagedBean.paytypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return paytypeItem;
    }

    public Map<String, String> getRemarkMap() {
        List list = facade.getLibclassdByClassNo("tvviptype");
        remarkMap = new Hashtable<String, String>();
        for (Libclassd data : list) {
            remarkMap.put(data.getItemno(), data.getItemname());
        }
        return remarkMap;
    }

    public SelectItem[] getRemarkItem() {
        List list = facade.getLibclassdByClassNo("tvviptype");
        if (list == null) {
            remarkItem = new SelectItem[0];
        } else {
            remarkItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                BizorderokManagedBean.remarkItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
            }
        }
        return remarkItem;
    }

    public SelectItem[] getCopartnersItem() {
        Copartners queryCopartners = new Copartners();
        Sheet sheet = facade.queryCopartners(queryCopartners, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getChooseflag() + "-" + ((Copartners)list.get(i)).getCopartnername());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getCopartnersMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Sheet sheet = facade.queryCopartners(new Copartners(), null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getCopartnername());
            }
        }
        return copMap;
    }

    public SelectItem[] getBiznoItem() {
        Copbizinfo queryCopbizinfo = new Copbizinfo();
        Sheet sheet = facade.queryCopbizinfo(queryCopbizinfo, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getBiznameMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Sheet sheet = facade.queryCopbizinfo(new Copbizinfo(), null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
        }
        return copMap;
    }

    public Map<String, String> getOrdertypeMap() {
        if (ordertypeMap == null) {
            List list = facade.getLibclassdByClassNo("OrderType");
            ordertypeMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                ordertypeMap.put(data.getItemno(), data.getItemname());
            }
        }
        return ordertypeMap;
    }

    public SelectItem[] getOrdertypeItem() {
        if (ordertypeItem == null) {
            List list = facade.getLibclassdByClassNo("OrderType");
            if (list == null) {
                ordertypeItem = new SelectItem[0];
            } else {
                ordertypeItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    BizorderokManagedBean.ordertypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return ordertypeItem;
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static int befSevenDays(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar sevenDays = Calendar.getInstance();
        sevenDays.add(5, -7);
        Calendar dateCal = Calendar.getInstance();
        try {
            dateCal.setTime(format.parse(date));
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        int result = dateCal.compareTo(sevenDays);
        return result;
    }

    private static String beforeSevenDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar sevenDays = Calendar.getInstance();
        sevenDays.add(5, -7);
        return format.format(sevenDays.getTime());
    }

    private static int befSixMonth(String date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar sixMonth = Calendar.getInstance();
        sixMonth.add(5, -180);
        Calendar dateCal = Calendar.getInstance();
        try {
            dateCal.setTime(format.parse(date));
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        int ret = dateCal.compareTo(sixMonth);
        return ret;
    }

    public String getQueryBizorderokListAgo() {
        this.authenticateRun();
        Bizorderok bizorderok = (Bizorderok)this.findBean(Bizorderok.class, "payproxy_bizorderok");
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("successtime desc");
        if (bizorderok != null) {
            if (StringTools.isEmpty((String)bizorderok.getFromdate())) {
                bizorderok.setFromdate(this.getLastDayOfLastyear());
            }
            if (StringTools.isEmpty((String)bizorderok.getTodate())) {
                bizorderok.setTodate(this.getLastDayOfLastyear());
            }
            if (!bizorderok.getFromdate().substring(0, 4).equals(bizorderok.getTodate().substring(0, 4))) {
                this.alertJS("\u8d77\u59cb\u65e5\u671f\u548c\u7ed3\u675f\u65e5\u671f\u5fc5\u987b\u4e3a\u540c\u4e00\u5e74");
                return "";
            }
            List<String> queryYears = this.getQueryYears();
            if (!queryYears.contains(bizorderok.getFromdate().substring(0, 4))) {
                this.alertJS("\u67e5\u8be2\u65e5\u671f\u8d85\u51fa\u53ef\u67e5\u8baf\u8303\u56f4\uff0c\u53ef\u67e5\u5e74\u4efd\u4e3a\uff1a" + queryYears);
                return "";
            }
            bizorderok.setYearofago(bizorderok.getFromdate().substring(0, 4));
            logger.info("getQueryBizorderokListAgo-----getyear=" + bizorderok.getYearofago());
            ArrayList<String> list = new ArrayList<String>();
            if (bizorderok.getYearofago().equals("2009") || bizorderok.getYearofago().equals("2010") || bizorderok.getYearofago().equals("2011")) {
                list.add("bizorderokhis_" + bizorderok.getYearofago());
            } else {
                int fromMonth = Integer.parseInt(bizorderok.getFromdate().substring(5, 7));
                int toMonth = Integer.parseInt(bizorderok.getTodate().substring(5, 7));
                for (int i = fromMonth; i <= toMonth; ++i) {
                    String table = "bizorderok_" + bizorderok.getYearofago() + "Q" + (int)Math.ceil((i + 2) / 3);
                    if (list.contains(table)) continue;
                    list.add(table);
                }
            }
            Sheet sheet = facade.queryBizorderokList(bizorderok, fliper, list);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String getLastDayOfLastyear() {
        String thisdayoflastYear = DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-365);
        String lastyear = thisdayoflastYear.substring(0, 4);
        return lastyear + "-12-31";
    }

    public List<String> getQueryYears() {
        ArrayList<String> resultList = new ArrayList<String>();
        String thisdayoflastYear = DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-365);
        String lastyear = thisdayoflastYear.substring(0, 4);
        for (int i = 2009; i <= Integer.parseInt(lastyear); ++i) {
            resultList.add(String.valueOf(i));
        }
        return resultList;
    }

    private static Bizorderokhis copyTohis(Bizorderokhis bizorderokhis, Bizorderok bizorderok) {
        try {
            BeanUtils.copyProperties((Object)bizorderokhis, (Object)bizorderok);
            bizorderokhis.setBiznos(bizorderok.getBiznos());
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage());
        }
        catch (InvocationTargetException e) {
            logger.error(e.getMessage());
        }
        return bizorderokhis;
    }

    private void writeToExcel(WritableWorkbook wwb, int pageCount, String[] tHeadNames, String[] tDataFieldNames, List<Object> list, File excelFile, Class clazz) {
        try {
            String sheetName = "bizorderok";
            WritableSheet ws = wwb.createSheet("\u7b2c" + pageCount + "\u9875", pageCount);
            ws.setRowView(0, 810, false);
            WritableFont wfc1 = new WritableFont(WritableFont.ARIAL, 13, WritableFont.BOLD, false, UnderlineStyle.getStyle((int)0));
            WritableCellFormat wcfFC1 = new WritableCellFormat(wfc1);
            wcfFC1.setBorder(Border.NONE, BorderLineStyle.THIN);
            wcfFC1.setAlignment(Alignment.CENTRE);
            wcfFC1.setWrap(false);
            int titlepos = tHeadNames.length / 2;
            Label label2 = new Label(titlepos, 0, sheetName, (CellFormat)wcfFC1);
            ws.addCell((WritableCell)label2);
            WritableFont wfc2 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, false, UnderlineStyle.getStyle((int)0));
            WritableCellFormat wcfFC2 = new WritableCellFormat(wfc2);
            wcfFC2.setBorder(Border.ALL, BorderLineStyle.THIN);
            wcfFC2.setAlignment(Alignment.CENTRE);
            wcfFC2.setWrap(false);
            Label[] titleLabels = new Label[tHeadNames.length];
            for (int n = 0; n < titleLabels.length; ++n) {
                ws.setColumnView(n, 20);
                titleLabels[n] = new Label(n, 1, tHeadNames[n], (CellFormat)wcfFC2);
                ws.addCell((WritableCell)titleLabels[n]);
            }
            Label[] labels = new Label[tHeadNames.length];
            for (int row = 0; row < list.size(); ++row) {
                Object t = list.get(row);
                for (int column = 0; column < labels.length; ++column) {
                    WritableFont wfc3 = new WritableFont(WritableFont.ARIAL, 10, WritableFont.NO_BOLD, false, UnderlineStyle.getStyle((int)0));
                    wfc3.setColour(Colour.BLACK);
                    WritableCellFormat wcfFC3 = new WritableCellFormat(wfc3);
                    wcfFC3.setBorder(Border.ALL, BorderLineStyle.THIN);
                    wcfFC3.setAlignment(Alignment.CENTRE);
                    wcfFC3.setWrap(false);
                    Method method = clazz.getDeclaredMethod("get" + BizorderokManagedBean.capitalize(tDataFieldNames[column]), new Class[0]);
                    Object value = method.invoke(t, new Object[0]);
                    String valuestr = value.toString();
                    Class<?> rtntype = method.getReturnType();
                    String type = rtntype.getSimpleName();
                    labels[column] = new Label(column, row + 2, valuestr, (CellFormat)wcfFC3);
                    ws.addCell((WritableCell)labels[column]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToTxt(File txtFile, TxtParams params, List list, boolean firstPage) {
        RandomAccessFile randomFile = null;
        StringBuffer writer = new StringBuffer();
        String[] headerfeildName = params.getHeaderFieldNames();
        if (firstPage) {
            boolean first = true;
            for (int i = 0; i < headerfeildName.length; ++i) {
                if (first) {
                    writer.append(headerfeildName[i]);
                    first = false;
                    continue;
                }
                writer.append("  ").append(headerfeildName[i]);
            }
            writer.append("\r\n");
        }
        try {
            randomFile = new RandomAccessFile(txtFile, "rw");
            if (!writer.toString().equals("")) {
                long fileLength = randomFile.length();
                MappedByteBuffer out = randomFile.getChannel().map(FileChannel.MapMode.READ_WRITE, fileLength, writer.toString().getBytes().length);
                out.put(writer.toString().getBytes());
                out.clear();
            }
            for (int i = 0; i < list.size(); ++i) {
                long fileLength = randomFile.length();
                String content = list.get(i) + "\r\n";
                MappedByteBuffer out = randomFile.getChannel().map(FileChannel.MapMode.READ_WRITE, fileLength, content.toString().getBytes().length);
                out.put(content.getBytes());
                out.clear();
            }
            randomFile.close();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            try {
                if (randomFile != null) {
                    randomFile.close();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    static {
        lock = new Object();
    }
}

