/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.cardpay.check.CardPayCheck;
import com.xunlei.cardpay.check.CardPayCheckRet;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.jms.send.PayProxyJmsMessageSender;
import com.xunlei.payproxy.util.CustomUtil;
import com.xunlei.payproxy.util.PayProxyFunctionConstant;
import com.xunlei.payproxy.util.TimeUtil;
import com.xunlei.payproxy.util.Utility;
import com.xunlei.payproxy.vo.Bizorder;
import com.xunlei.payproxy.vo.Bizorderfail;
import com.xunlei.payproxy.vo.Copartners;
import com.xunlei.payproxy.vo.Copbizinfo;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanUtils;

@FunRef(value="PayProxyBizorder")
public class BizorderManagedBean
extends BaseManagedBean {
    private static Map<String, String> paytypeMap;
    private static SelectItem[] paytypeItem;
    private static Map<String, String> ordertypeMap;
    private static SelectItem[] ordertypeItem;
    private static Map<String, String> paystatusMap;
    private static SelectItem[] paystatusItem;

    public String getQueryBizorderList() {
        this.authenticateRun();
        Bizorder bizorder = (Bizorder)this.findBean(Bizorder.class, "payproxy_bizorder");
        if (bizorder != null) {
            if (StringTools.isEmpty((String)bizorder.getFromdate())) {
                bizorder.setFromdate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)bizorder.getTodate())) {
                bizorder.setTodate(DatetimeUtil.today());
            }
            if (StringTools.isEmpty((String)bizorder.getBizno())) {
                bizorder.setBiznos(this.biznosByRecRole());
            }
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("inputtime desc");
        try {
            List tables = TimeUtil.getTables4Bizorder((String)bizorder.getFromdate(), (String)bizorder.getTodate());
            Sheet sheet = facade.queryBizorderhis(bizorder, fliper, tables);
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getQueryBizorderfailList() {
        this.authenticateAdd();
        Bizorder bizorder = (Bizorder)this.findBean(Bizorder.class, "payproxy_bizorder");
        Bizorderfail bizorderfail = new Bizorderfail();
        if (bizorder != null) {
            if (StringTools.isEmpty((String)bizorder.getBizno())) {
                bizorder.setBiznos(this.biznosByRecRole());
            }
            try {
                bizorder.setTodate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-180));
                BeanUtils.copyProperties((Object)bizorderfail, (Object)bizorder);
                bizorderfail.setOrderstatus("N");
                PagedFliper fliper = this.getFliper();
                fliper.setSortColumnIfEmpty("inputtime desc");
                Sheet sheet = facade.queryBizorderfail(bizorderfail, fliper);
                this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public String doBizorder() {
        String xunleipayid = this.findParameter("biz_xunleipayid");
        String cardno = this.findParameter("biz_bankno");
        double orderamt = Double.valueOf(this.findParameter("biz_orderamt").trim());
        boolean query = CustomUtil.isQuery((String)"cardpay");
        logger.info((Object)("query:" + query + "\txunleipayid:" + xunleipayid + "\tcardno:" + cardno + "\torderamt:" + orderamt));
        CardPayCheckRet cardPayChectRet = null;
        if (!query) {
            facade.moveBizorderToSuccess(xunleipayid);
            PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)xunleipayid);
            this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5b8c\u6210!");
        } else {
            cardPayChectRet = CardPayCheck.check((String)xunleipayid, (String)cardno, (double)orderamt);
            if (cardPayChectRet != null && "02".equals(cardPayChectRet.getStatus())) {
                facade.moveBizorderToSuccess(xunleipayid);
                PayProxyJmsMessageSender.sendBizorderokByXunleiPayId((String)xunleipayid);
                this.alertJS("\u4eba\u5de5\u5b9a\u5236\u5b8c\u6210!");
            } else {
                String status = "";
                status = "01".equals(cardPayChectRet.getStatus()) ? "\u672a\u652f\u4ed8" : ("03".equals(cardPayChectRet.getStatus()) ? "\u67e5\u8be2\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38" : ("04".equals(cardPayChectRet.getStatus()) ? "\u8ba2\u5355\u4e2d\u7684\u5361\u53f7\u4e0e\u652f\u4ed8\u7684\u5361\u53f7\u4e0d\u7b26\u5408" : ("05".equals(cardPayChectRet.getStatus()) ? "\u8ba2\u5355\u91d1\u989d\u4e0d\u7b26" : "\u67e5\u8be2\u5f02\u5e38")));
                this.alertJS("\u8ba2\u5355\u72b6\u6001\uff1a" + status + ";\u4e0d\u80fd\u8fdb\u884c\u4eba\u5de5\u5b9a\u5236!");
            }
        }
        return "";
    }

    public String noticeSome() {
        this.authenticateAdd();
        String xunleipayids = this.findParameter("noticepayids");
        if (this.isNotEmpty(xunleipayids)) {
            String[] xlpids;
            for (String xunleipayid : xlpids = xunleipayids.split("\\|")) {
                Bizorder bizorderQry = new Bizorder();
                bizorderQry.setXunleipayid(xunleipayid);
                Bizorder bizorder = IFacade.INSTANCE.findBizorder(bizorderQry);
                String orderstatus = bizorder.getOrderstatus();
                String type = bizorder.getType();
                if (!orderstatus.equals("N")) {
                    this.alertJS("\u8ba2\u5355\u72b6\u6001\u4e3a\u5931\u8d25\u624d\u53ef\u518d\u6b21\u8c03\u7528\u901a\u77e5");
                }
                if (type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_REFUND_PLATFORM) || type.equals(PayProxyFunctionConstant.PAYPROXY_ORDER_TYPE_REFUND_USER)) {
                    PayProxyJmsMessageSender.sendRefundBizorderByXunleiPayId((String)xunleipayid);
                    continue;
                }
                this.alertJS("\u53ea\u6709\u652f\u4ed8\u9000\u6b3e\u80fd\u591f\u53d1\u9001\u901a\u77e5");
            }
        }
        return "";
    }

    public SelectItem[] getCopartnersItem() {
        Copartners queryCopartners = new Copartners();
        Sheet sheet = facade.queryCopartners(queryCopartners, null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            SelectItem[] copItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                copItem[i] = new SelectItem((Object)((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getChooseflag() + "-" + ((Copartners)list.get(i)).getCopartnername());
            }
            return copItem;
        }
        return new SelectItem[0];
    }

    public Map<String, String> getBiznameMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Sheet sheet = facade.queryCopbizinfo(new Copbizinfo(), null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copbizinfo)list.get(i)).getBizno(), ((Copbizinfo)list.get(i)).getBizname());
            }
        }
        return copMap;
    }

    public Map<String, String> getCopartnersMap() {
        HashMap<String, String> copMap = new HashMap<String, String>();
        Sheet sheet = facade.queryCopartners(new Copartners(), null);
        if (sheet != null && sheet.getRowcount() > 0) {
            List list = (List)sheet.getDatas();
            for (int i = 0; i < list.size(); ++i) {
                copMap.put(((Copartners)list.get(i)).getCopartnerno(), ((Copartners)list.get(i)).getCopartnername());
            }
        }
        return copMap;
    }

    public Map<String, String> getPaytypeMap() {
        List list = facade.getLibclassdByClassNo("PayTypeShow");
        paytypeMap = new Hashtable<String, String>();
        for (Libclassd data : list) {
            paytypeMap.put(data.getItemno(), data.getItemname());
        }
        return paytypeMap;
    }

    public SelectItem[] getPaytypeItem() {
        List list = facade.getLibclassdByClassNo("PayTypeShow");
        if (list == null) {
            paytypeItem = new SelectItem[0];
        } else {
            paytypeItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                BizorderManagedBean.paytypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
            }
        }
        return paytypeItem;
    }

    public Converter getAmtFormater() {
        return new Converter(){

            public Object getAsObject(FacesContext context, UIComponent component, String value) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String getAsString(FacesContext context, UIComponent component, Object value) {
                return Utility.formatAmt((double)((Double)value));
            }
        };
    }

    public Map<String, String> getOrdertypeMap() {
        List list = facade.getLibclassdByClassNo("OrderType");
        ordertypeMap = new Hashtable<String, String>();
        for (Libclassd data : list) {
            ordertypeMap.put(data.getItemno(), data.getItemname());
        }
        return ordertypeMap;
    }

    public SelectItem[] getOrdertypeItem() {
        List list = facade.getLibclassdByClassNo("OrderType");
        if (list == null) {
            ordertypeItem = new SelectItem[0];
        } else {
            ordertypeItem = new SelectItem[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                BizorderManagedBean.ordertypeItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
            }
        }
        return ordertypeItem;
    }

    public Map<String, String> getPaystatusMap() {
        if (paystatusMap == null) {
            List list = facade.getLibclassdByClassNo("PayStatus");
            paystatusMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                paystatusMap.put(data.getItemno(), data.getItemname());
            }
        }
        return paystatusMap;
    }

    public SelectItem[] getPaystatusItem() {
        if (paystatusItem == null) {
            List list = facade.getLibclassdByClassNo("PayStatus");
            if (list == null) {
                paystatusItem = new SelectItem[0];
            } else {
                paystatusItem = new SelectItem[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    BizorderManagedBean.paystatusItem[i] = new SelectItem((Object)((Libclassd)list.get(i)).getItemno(), ((Libclassd)list.get(i)).getItemname());
                }
            }
        }
        return paystatusItem;
    }
}

