/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.facade.IFacade;
import com.xunlei.payproxy.vo.AutoPayDailyStatistics;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.util.List;

@FunRef(value="PayProxyAutoPayStatistics")
public class AutoPayStatisticsManagedBean
extends BaseManagedBean {
    protected static final IFacade facade = IFacade.INSTANCE;

    public String getAutoPayStatisticsList() {
        this.authenticateRun();
        AutoPayDailyStatistics apds = (AutoPayDailyStatistics)this.findBean(AutoPayDailyStatistics.class, "payproxy_autopaystatistics");
        if (apds == null) {
            apds = new AutoPayDailyStatistics();
        }
        if (StringTools.isEmpty((String)apds.getFromStatisticsDate())) {
            apds.setFromStatisticsDate(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("seqId desc");
        Sheet sheet = facade.getAutoPayDailyStatistics(apds, fliper);
        if (sheet != null && sheet.getDatas() != null) {
            List list = (List)sheet.getDatas();
            for (AutoPayDailyStatistics apds1 : list) {
                int successnum = apds1.getSuccessPayUserNum();
                int failnum = apds1.getFailPayUserNum();
                int allnum = successnum + failnum;
                String successRate = "-";
                if (allnum > 0) {
                    if (allnum == successnum) {
                        successRate = "100%";
                    }
                    double rate = (double)successnum * 1.0 / (double)allnum * 100.0;
                    successRate = String.format("%.2f", rate) + "%";
                }
                apds1.setPayUserNum(Integer.valueOf(allnum));
                apds1.setSuccessPayUserRate(successRate);
            }
        }
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }
}

