/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.channel.util.UserUtility;
import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.payproxy.vo.AutoPay;
import com.xunlei.payproxy.vo.AutoPayCondition;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunRef(value="PayProxyAutoPay")
public class AutoPayManagedBean
extends BaseManagedBean {
    private static Logger logger = LoggerFactory.getLogger(AutoPayManagedBean.class);
    private static Map<String, String> productMap;
    private static Map<String, String> autoPayFlagMap;
    private static Map<String, String> payStatusMap;

    public Map<String, String> getProductMap() {
        if (productMap == null) {
            List list = facade.getLibclassdByClassNo("AutopayProduct");
            productMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                productMap.put(data.getItemno(), data.getItemname());
            }
        }
        return productMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getAutoPayFlagMap() {
        if (autoPayFlagMap.isEmpty()) {
            Map<String, String> map = autoPayFlagMap;
            synchronized (map) {
                if (autoPayFlagMap.isEmpty()) {
                    autoPayFlagMap.put("1", "\u5426");
                    autoPayFlagMap.put("0", "\u662f");
                }
            }
        }
        return autoPayFlagMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getPayStatusMap() {
        if (payStatusMap.isEmpty()) {
            Map<String, String> map = payStatusMap;
            synchronized (map) {
                if (payStatusMap.isEmpty()) {
                    payStatusMap.put("Y", "\u6210\u529f");
                    payStatusMap.put("N", "\u5931\u8d25");
                }
            }
        }
        return payStatusMap;
    }

    public String getQuery() {
        logger.info("=====================================================");
        this.authenticateRun();
        AutoPayCondition autopay = (AutoPayCondition)this.findBean(AutoPayCondition.class, "payproxy_autopay");
        Sheet sheet = null;
        if (autopay != null) {
            logger.info("========" + autopay.getToGenernateTime());
            if (StringTools.isNotEmpty((String)autopay.getToGenernateTime())) {
                autopay.setToGenernateTime(DatetimeUtil.addDate((String)autopay.getToGenernateTime().substring(0, 10), (String)"D", (int)1));
            }
            if (StringTools.isEmpty((String)autopay.getFromGenernateTime())) {
                autopay.setFromGenernateTime(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
            if (StringTools.isNotEmpty((String)autopay.getToExpireDate())) {
                autopay.setToExpireDate(DatetimeUtil.addDate((String)autopay.getToExpireDate().substring(0, 10), (String)"D", (int)1));
            }
            PagedFliper fliper = this.getFliper();
            fliper.setSortColumnIfEmpty(" seqId desc");
            sheet = facade.getAutoPay(autopay, fliper);
            logger.debug("sheet size:" + sheet.getRowcount());
            this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        }
        return "";
    }

    public String add() {
        this.authenticateAdd();
        AutoPay data = (AutoPay)this.findBean(AutoPay.class, "payproxy_autoPay");
        try {
            AutoPayCondition query = new AutoPayCondition();
            if (data == null) {
                this.alertJS("\u53c2\u6570\u4e3a\u7a7a");
                this.getQuery();
                return "";
            }
            if (StringTools.isEmpty((String)data.getPayType())) {
                this.alertJS("\u652f\u4ed8\u7c7b\u578b\u4e3a\u7a7a");
                this.getQuery();
                return "";
            }
            if (StringTools.isEmpty((String)data.getProductType())) {
                this.alertJS("\u4ea7\u54c1\u7c7b\u578b\u4e3a\u7a7a");
                this.getQuery();
                return "";
            }
            query.setProductType(data.getProductType());
            if (StringTools.isNotEmpty((String)data.getXunleiId())) {
                query.setUserShow(UserUtility.getUserNameByUserId((String)data.getXunleiId()));
                query.setXunleiId(data.getXunleiId());
            } else if (StringTools.isNotEmpty((String)data.getUserShow())) {
                query.setXunleiId(UserUtility.getUserIdByUserName((String)data.getUserShow()));
                query.setUserShow(data.getUserShow());
            } else {
                this.alertJS("\u5185\u90e8id\u6216\u8005\u8fc5\u96f7\u8d26\u53f7\u4e3a\u7a7a");
                this.getQuery();
                return "";
            }
            List list = facade.getAutoPay(query);
            if (list != null && list.size() > 0) {
                this.alertJS(query.getUserShow() + "\u5df2\u7ed1\u5b9a");
                this.getQuery();
                return "";
            }
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String now = sf.format(new Date());
            data.setXunleiId(query.getXunleiId());
            data.setUserShow(query.getUserShow());
            if (data.getGenerateTime() == null || "".equals(data.getGenerateTime())) {
                data.setGenerateTime(this.now());
            }
            if (data.getFlag() == null || !"1".equals(data.getFlag())) {
                data.setFlag("1");
            }
            facade.insertAutoPay(data);
        }
        catch (XLRuntimeException e) {
            this.mergeBean(e.getMessage(), "jsmessage");
        }
        this.getQuery();
        return "";
    }

    public static void main(String[] args) {
        new AutoPayManagedBean().getQuery();
    }

    static {
        autoPayFlagMap = new HashMap<String, String>();
        payStatusMap = new HashMap<String, String>();
    }
}

