/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.model;

import com.xunlei.common.util.DatetimeUtil;
import com.xunlei.common.util.FunRef;
import com.xunlei.common.util.PagedFliper;
import com.xunlei.common.util.Sheet;
import com.xunlei.common.util.StringTools;
import com.xunlei.payproxy.vo.AutoPayCancle;
import com.xunlei.payproxy.vo.Libclassd;
import com.xunlei.payproxy.web.model.BaseManagedBean;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

@FunRef(value="PayProxyAutoPayCancle")
public class AutoPayCancleManagedBean
extends BaseManagedBean {
    private static Map<String, String> productMap;
    private static Map<String, String> cancleFromMap;

    public Map<String, String> getProductMap() {
        if (productMap == null) {
            List list = facade.getLibclassdByClassNo("AutopayProduct");
            productMap = new Hashtable<String, String>();
            for (Libclassd data : list) {
                productMap.put(data.getItemno(), data.getItemname());
            }
        }
        return productMap;
    }

    public Map<String, String> getCancleFromMap() {
        if (cancleFromMap == null) {
            cancleFromMap = new Hashtable<String, String>();
            cancleFromMap.put("01", "\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
            cancleFromMap.put("02", "\u6263\u8d39\u5931\u8d25\u53d6\u6d88");
        }
        return cancleFromMap;
    }

    public String getAutoPayCancleList() {
        this.authenticateRun();
        AutoPayCancle autoPayCancle = (AutoPayCancle)this.findBean(AutoPayCancle.class, "payproxy_autopaycancle");
        if (autoPayCancle != null) {
            String toCancleTime = autoPayCancle.getToCancleTime();
            if (StringTools.isNotEmpty((String)toCancleTime)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date d = sdf.parse(toCancleTime);
                    long t = d.getTime();
                    Date d2 = new Date(t += 86400000L);
                    String d3 = sdf.format(d2);
                    autoPayCancle.setToCancleTime(d3);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (StringTools.isEmpty((String)autoPayCancle.getFormCancleTime())) {
                autoPayCancle.setFormCancleTime(DatetimeUtil.addDate((String)DatetimeUtil.today(), (String)"D", (int)-2));
            }
        }
        PagedFliper fliper = this.getFliper();
        fliper.setSortColumnIfEmpty("cancleTime desc");
        Sheet sheet = facade.getAutoPayCancle(autoPayCancle, fliper);
        this.mergePagedDataModel(sheet, new PagedFliper[]{fliper});
        return "";
    }
}

