/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.channel.bestpay;

import com.xunlei.payproxy.web.channel.bestpay.BestpayRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BestpaySignUtil {
    private static final Logger logger = LoggerFactory.getLogger(BestpaySignUtil.class);
    public static Provider provider = new BouncyCastleProvider();
    private static RSAPrivateCrtKey privateKey = null;
    private static X509Certificate publicKey = null;
    private static final String encoding = "UTF-8";
    private static final String arithmetic = "SHA1withRSA";

    private static void init() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("bestpay");
            String jksPath = bundle.getString("jks_path");
            String pubPriKeyPath = bundle.getString("pub_pri_key");
            String cerPath = bundle.getString("cer_path");
            logger.debug("jksPath: {}, pubPriKeyPath: {}, cerPath: {}", new Object[]{jksPath, pubPriKeyPath, cerPath});
            privateKey = BestpaySignUtil.getPrivateKey(new FileInputStream(new File(jksPath)), pubPriKeyPath);
            logger.debug("privateKey: {}", (Object)privateKey);
            publicKey = BestpaySignUtil.getPublicKey(new FileInputStream(new File(cerPath)));
            logger.debug("publicKey: {}", (Object)publicKey);
        }
        catch (IOException e) {
            logger.error("init public/private key failed!");
        }
    }

    public static X509Certificate getPublicKey(InputStream pubKey) throws IOException {
        X509Certificate x509cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            x509cert = (X509Certificate)cf.generateCertificate(pubKey);
        }
        catch (CertificateException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            if (pubKey != null) {
                pubKey.close();
            }
        }
        return x509cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateCrtKey getPrivateKey(InputStream priKey, String keyPassword) throws IOException {
        String keyAlias = null;
        RSAPrivateCrtKey rsaPrikey = null;
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(priKey, keyPassword.toCharArray());
            Enumeration<String> myEnum = ks.aliases();
            while (myEnum.hasMoreElements()) {
                keyAlias = myEnum.nextElement();
                if (!ks.isKeyEntry(keyAlias)) continue;
                rsaPrikey = (RSAPrivateCrtKey)ks.getKey(keyAlias, keyPassword.toCharArray());
                break;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            if (priKey != null) {
                priKey.close();
            }
        }
        return rsaPrikey;
    }

    public static String encryptBySHA256(String str) throws Exception {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes());
            return BestpaySignUtil.byteToString(messageDigest.digest());
        }
        catch (Exception e) {
            throw new Exception("encrypt data error :" + e.getMessage());
        }
    }

    public static String byteToString(byte[] digest) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < digest.length; ++i) {
            String tempStr = Integer.toHexString(digest[i] & 0xFF);
            if (tempStr.length() == 1) {
                buf.append("0").append(tempStr);
                continue;
            }
            buf.append(tempStr);
        }
        return buf.toString().toLowerCase();
    }

    public static String sign(RSAPrivateCrtKey priKey, String tobeSigned) throws Exception {
        try {
            Signature sign = Signature.getInstance(arithmetic);
            sign.initSign(priKey);
            sign.update(tobeSigned.getBytes(encoding));
            byte[] signed = sign.sign();
            return Base64.encodeBase64String((byte[])signed);
        }
        catch (Exception e) {
            throw new Exception("\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public static String genAESkey() throws Exception {
        KeyGenerator kg = null;
        try {
            kg = KeyGenerator.getInstance("AES");
            kg.init(128);
            SecretKey secretKey = kg.generateKey();
            return Base64.encodeBase64String((byte[])secretKey.getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("gen the key failure.msg is : " + e.getMessage());
        }
    }

    public static Key toKey(byte[] key) throws Exception {
        return new SecretKeySpec(key, "AES");
    }

    public static String encryptByAES(String data, String key, String iv) throws Exception {
        Key k = BestpaySignUtil.toKey(Base64.decodeBase64((String)key));
        IvParameterSpec ivs = new IvParameterSpec(iv.getBytes(encoding));
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, k, ivs);
        return Base64.encodeBase64String((byte[])cipher.doFinal(data.getBytes(encoding)));
    }

    public static String encryptMsg(String tobeEncryptMsg, X509Certificate pubKey) throws Exception {
        try {
            Cipher instance = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            instance.init(1, pubKey);
            String encryMsg = Base64.encodeBase64String((byte[])instance.doFinal(Base64.encodeBase64((byte[])tobeEncryptMsg.getBytes(encoding))));
            return encryMsg;
        }
        catch (Exception e) {
            throw new Exception("\u52a0\u5bc6\u5931\u8d25", e);
        }
    }

    public static String decodeMsg(String tobeDecodeMsg, RSAPrivateCrtKey priKey) throws Exception {
        Cipher instance = null;
        try {
            instance = Cipher.getInstance(priKey.getAlgorithm());
            instance.init(2, priKey);
            String string = new String(Base64.decodeBase64((byte[])instance.doFinal(Base64.decodeBase64((String)tobeDecodeMsg))), encoding);
            return string;
        }
        catch (Exception e) {
            throw new Exception("\u89e3\u5bc6\u5931\u8d25", e);
        }
    }

    public static String decryptByAES(String data, String key, String iv) throws Exception {
        Key k = BestpaySignUtil.toKey(Base64.decodeBase64((String)key));
        IvParameterSpec ivs = new IvParameterSpec(iv.getBytes(encoding));
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, k, ivs);
        return new String(cipher.doFinal(Base64.decodeBase64((String)data)), encoding);
    }

    public static boolean verifyMsgByPubKey(String tobeVerfied, String plainText, X509Certificate pubkey) throws Exception {
        return BestpaySignUtil.verify(pubkey, tobeVerfied, plainText);
    }

    public static boolean verify(X509Certificate pubkey, String tobeVerfied, String plainText) throws Exception {
        try {
            Signature verify = Signature.getInstance(arithmetic);
            verify.initVerify(pubkey);
            verify.update(plainText.getBytes(encoding));
            return verify.verify(Base64.decodeBase64((String)tobeVerfied));
        }
        catch (Exception e) {
            throw new Exception("\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    public static void main(String[] args) throws Exception {
        String data = "reqSeq=121212121&merchantCode=043101180050000&merchantPwd=534231";
        String sign = BestpaySignUtil.encryptBySHA256(data);
        String digest = BestpaySignUtil.sign(privateKey, sign);
        String body = "reqSeq=121212121&merchantCode=043101180050000&merchantPwd=534231&digest=" + digest;
        String aesKey = BestpaySignUtil.genAESkey();
        String encryptData = BestpaySignUtil.encryptByAES(body, aesKey, "QUJDREVGR0hJS0w=");
        String encryptKey = BestpaySignUtil.encryptMsg(aesKey, publicKey);
        System.out.println("\u5f85\u7b7e\u540d\u62fc\u63a5\u5b57\u7b26\u4e32:" + data);
        System.out.println("\u5f85\u7b7e\u540d\u6458\u8981:" + sign);
        System.out.println("\u7b7e\u540d\u7ed3\u679c:" + digest);
        System.out.println("\u5f85\u52a0\u5bc6\u7684\u62a5\u6587\u4ee5\u53ca\u7b7e\u540d:" + body);
        System.out.println("\u751f\u6210\u7684\u5bf9\u79f0AES key:" + aesKey);
        System.out.println("encryptData\u5bf9\u79f0\u52a0\u5bc6\u7684\u7ed3\u679c:" + encryptData);
        System.out.println("encryptKey\u5c06AES key\u52a0\u5bc6\u7684\u7ed3\u679c:" + encryptKey);
        String req = "merchantId='\u5546\u6237\u53f7'&encryptData=" + encryptData + "&encryptKey=" + encryptKey;
        System.out.println("\u6700\u7ec8\u7684\u8bf7\u6c42\u4fe1\u606f:" + req);
        String decodeAesKey = BestpaySignUtil.decodeMsg(encryptKey, privateKey);
        String decryptBody = BestpaySignUtil.decryptByAES(encryptData, decodeAesKey, "QUJDREVGR0hJS0w=");
        System.out.println("\u5f00\u59cb\u9006\u5411\u64cd\u4f5c");
        System.out.println("\u89e3\u5bc6\u5bf9\u79f0KEY\u4e3a:" + decodeAesKey);
        System.out.println("\u89e3\u5bc6\u52a0\u5bc6\u62a5\u6587\u4e3a:" + decryptBody);
        String[] split = StringUtils.delimitedListToStringArray((String)decryptBody, (String)"&");
        String[] digestResp = StringUtils.delimitedListToStringArray((String)split[split.length - 1], (String)"=");
        String decdata = "";
        for (int i = 0; i < split.length - 1; ++i) {
            decdata = i == split.length - 2 ? decdata + split[i] : decdata + split[i] + "&";
        }
        String encryptBySHA1 = BestpaySignUtil.encryptBySHA256(decdata);
        boolean verifyResult = BestpaySignUtil.verifyMsgByPubKey(digestResp[1], encryptBySHA1, publicKey);
        if (verifyResult) {
            System.out.println("\u9a8c\u7b7e\u6210\u529f.\u53ef\u5bf9\u660e\u6587\u8fdb\u884c\u64cd\u4f5c");
        } else {
            System.out.println("\u9a8c\u7b7e\u5931\u8d25");
        }
    }

    public static BestpayRequest generateBestpayRequest(StringBuilder content) throws Exception {
        logger.info("sign content: {}", (Object)content.toString());
        String sign = BestpaySignUtil.encryptBySHA256(content.toString());
        logger.info("encryptBySHA256 sign: {}", (Object)sign);
        String digest = BestpaySignUtil.sign(privateKey, sign);
        logger.info("digest: {}", (Object)digest);
        String body = content.append("&digest=").append(digest).toString();
        logger.info("body: {}", (Object)body);
        String aesKey = BestpaySignUtil.genAESkey();
        String encryptData = BestpaySignUtil.encryptByAES(body, aesKey, "QVBPQkNET0tIWUw=");
        String encryptKey = BestpaySignUtil.encryptMsg(aesKey, publicKey);
        BestpayRequest bestpayRequest = new BestpayRequest();
        bestpayRequest.setEncryptData(encryptData);
        bestpayRequest.setEncryptKey(encryptKey);
        return bestpayRequest;
    }

    public static String decodeBestpayResponse(String encryptKey, String encryptData) throws Exception {
        String decodeAesKey = BestpaySignUtil.decodeMsg(encryptKey, privateKey);
        return BestpaySignUtil.decryptByAES(encryptData, decodeAesKey, "QVBPQkNET0tIWUw=");
    }

    public static boolean checkSign(String decryptBody) throws Exception {
        String[] split = StringUtils.delimitedListToStringArray((String)decryptBody, (String)"&");
        String[] digestResp = StringUtils.delimitedListToStringArray((String)split[split.length - 1], (String)"=");
        String decdata = "";
        for (int i = 0; i < split.length - 1; ++i) {
            decdata = i == split.length - 2 ? decdata + split[i] : decdata + split[i] + "&";
        }
        String encryptBySHA1 = BestpaySignUtil.encryptBySHA256(decdata);
        return BestpaySignUtil.verifyMsgByPubKey(digestResp[1], encryptBySHA1, publicKey);
    }

    public static String generateSign(String inputString) throws Exception {
        logger.info("sign content: {}", (Object)inputString);
        String sign = BestpaySignUtil.encryptBySHA256(inputString);
        logger.info("encryptBySHA256 sign: {}", (Object)sign);
        return sign;
    }

    public static String generateSign(Map<String, String> responseMap, String removeKey) throws Exception {
        StringBuilder contentBuilder = new StringBuilder();
        if (responseMap.containsKey(removeKey)) {
            responseMap.remove(removeKey);
        }
        Set<Map.Entry<String, String>> entrySet = responseMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            String value = entry.getValue();
            contentBuilder.append(key).append("=").append(value).append("&");
        }
        String resultString = contentBuilder.substring(0, contentBuilder.length() - 1);
        logger.info("sign content: {}", (Object)resultString);
        String sign = BestpaySignUtil.encryptBySHA256(resultString);
        logger.info("encryptBySHA256 sign: {}", (Object)sign);
        String digest = BestpaySignUtil.sign(privateKey, sign);
        logger.info("digest: {}", (Object)digest);
        return digest;
    }

    static {
        BestpaySignUtil.init();
    }
}

