/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.api.agreement;

import com.xunlei.payproxy.vo.AgreementJson;
import com.xunlei.payproxy.web.api.agreement.AgreementVO;
import com.xunlei.payproxy.web.utils.MD5Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

public class BuilderUtils {
    public static Map<String, String> AUTO_PAY_INFO = new HashMap<String, String>();
    public static String KEY;

    public static Map<String, AgreementJson> conformityMap(List<AgreementJson> list, Map<String, AgreementJson> resultMap) {
        if (null != list) {
            for (AgreementJson temp : list) {
                boolean haveKey = resultMap.containsKey(temp.getBalanceDate());
                if (haveKey) {
                    AgreementJson json = resultMap.get(temp.getBalanceDate());
                    json.setUnsignNum(temp.getUnsignNum());
                    continue;
                }
                resultMap.put(temp.getBalanceDate(), temp);
            }
        }
        return resultMap;
    }

    public static Map<String, AgreementVO> conformityMap(String payType, Map<String, AgreementVO> resultMap, Map<String, AgreementJson> map) {
        for (String key : map.keySet()) {
            boolean haveKey = resultMap.containsKey(key);
            AgreementJson value = map.get(key);
            AgreementVO vo = null;
            vo = haveKey ? resultMap.get(key) : new AgreementVO();
            if ("AM".equals(payType)) {
                vo.setPayReqAM(value.getPayReqNum());
                vo.setPayOkAM(value.getPayOkNum());
                vo.setSignNumAM(value.getSignNum());
                vo.setUnSignNumAM(value.getUnsignNum());
            }
            if ("W5".equals(payType)) {
                vo.setPayReqW5(value.getPayReqNum());
                vo.setPayOkW5(value.getPayOkNum());
                vo.setSignNumW5(value.getSignNum());
                vo.setUnSignNumW5(value.getUnsignNum());
            }
            if ("E3".equals(payType)) {
                vo.setPayReqE3(value.getPayReqNum());
                vo.setPayOkE3(value.getPayOkNum());
                vo.setSignNumE3(value.getSignNum());
                vo.setUnSignNumE3(value.getUnsignNum());
            }
            if ("AS".equals(payType)) {
                vo.setPayReqAS(value.getPayReqNum());
                vo.setPayOkAS(value.getPayOkNum());
                vo.setSignNumAS(value.getSignNum());
                vo.setUnSignNumAS(value.getUnsignNum());
            }
            if ("F".equals(payType)) {
                vo.setPayReqF(value.getPayReqNum());
                vo.setPayOkF(value.getPayOkNum());
                vo.setSignNumF(value.getSignNum());
                vo.setUnSignNumF(value.getUnsignNum());
            }
            if ("TP".equals(payType)) {
                vo.setPayReqTP(value.getPayReqNum());
                vo.setPayOkTP(value.getPayOkNum());
                vo.setSignNumTP(value.getSignNum());
                vo.setUnSignNumTP(value.getUnsignNum());
            }
            if ("UP".equals(payType)) {
                vo.setPayReqUP(value.getPayReqNum());
                vo.setPayOkUP(value.getPayOkNum());
                vo.setSignNumUP(value.getSignNum());
                vo.setUnSignNumUP(value.getUnsignNum());
            }
            if ("YM".equals(payType)) {
                vo.setPayReqYM(value.getPayReqNum());
                vo.setPayOkYM(value.getPayOkNum());
                vo.setSignNumYM(value.getSignNum());
                vo.setUnSignNumYM(value.getUnsignNum());
            }
            if ("AS".equals(payType) || "YM".equals(payType) || "UP".equals(payType) || "TP".equals(payType) || "F".equals(payType)) {
                vo.setPayReqPhone(value.getPayReqNum() + vo.getPayReqPhone());
                vo.setPayOkPhone(value.getPayOkNum() + vo.getPayOkPhone());
                vo.setSignNumPhone(value.getSignNum() + vo.getSignNumPhone());
                vo.setUnSignNumPhone(value.getUnsignNum() + vo.getUnSignNumPhone());
            }
            vo.setBalanceDate(value.getBalanceDate());
            resultMap.put(key, vo);
        }
        return resultMap;
    }

    public static void init() {
        ResourceBundle rb = ResourceBundle.getBundle("agreement");
        KEY = rb.getString("key");
        String autoPayTemp = rb.getString("auto_pay_product_type");
        for (String productType : autoPayTemp.split(",")) {
            String[] biznos;
            for (String bizNo : biznos = rb.getString(productType + "_biz_nos").split(",")) {
                AUTO_PAY_INFO.put(bizNo, productType);
            }
        }
    }

    public static String getProductType(String bizNo) {
        if (null == AUTO_PAY_INFO || AUTO_PAY_INFO.size() == 0) {
            BuilderUtils.init();
        }
        return AUTO_PAY_INFO.get(bizNo);
    }

    public static String sign(Map<String, String> map, String key) {
        StringBuilder builder = new StringBuilder();
        builder.append(BuilderUtils.createLinkString(map)).append(key);
        return MD5Utils.getMD5Str(builder.toString(), "UTF-8");
    }

    private static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (StringUtils.isEmpty((String)value)) continue;
            if (i == keys.size() - 1) {
                builder.append(key).append("=").append(value);
                continue;
            }
            builder.append(key).append("=").append(value).append("&");
        }
        return builder.toString();
    }

    static {
        BuilderUtils.init();
    }
}

