/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.payproxy.web.api.agreement;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.xunlei.payproxy.vo.AgreementJson;
import com.xunlei.payproxy.web.api.agreement.AgreementAMBuilder;
import com.xunlei.payproxy.web.api.agreement.AgreementASBuilder;
import com.xunlei.payproxy.web.api.agreement.AgreementE3Builder;
import com.xunlei.payproxy.web.api.agreement.AgreementFBuilder;
import com.xunlei.payproxy.web.api.agreement.AgreementTPBuilder;
import com.xunlei.payproxy.web.api.agreement.AgreementUPBuilder;
import com.xunlei.payproxy.web.api.agreement.AgreementVO;
import com.xunlei.payproxy.web.api.agreement.AgreementW5Builder;
import com.xunlei.payproxy.web.api.agreement.AgreementYMBuilder;
import com.xunlei.payproxy.web.api.agreement.BuilderUtils;
import com.xunlei.payproxy.web.api.agreement.JsonResult;
import com.xunlei.payproxy.web.api.agreement.ResultDirector;
import com.xunlei.payproxy.web.utils.ExcelBaseBean;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgreementQueryServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(AgreementQueryServlet.class);
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        PrintWriter out = null;
        TreeMap<String, Object> resultJson = new TreeMap<String, Object>();
        try {
            out = response.getWriter();
            logger.info("entered the AgreementQueryServlet #doPost Method...");
            String sign = request.getParameter("sign");
            if (StringUtils.isEmpty((String)sign)) {
                logger.info("sign\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                resultJson.put("result", "ILLEGAL_SIGN");
                resultJson.put("status", "F");
                out.write(JSONArray.toJSONString(resultJson));
                return;
            }
            String beginDate = request.getParameter("begin_date");
            if (StringUtils.isEmpty((String)beginDate)) {
                logger.info("begin_date\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                resultJson.put("result", "ILLEGAL_BEGIN_DATE");
                resultJson.put("status", "F");
                out.write(JSONArray.toJSONString(resultJson));
                return;
            }
            String endDate = request.getParameter("end_date");
            if (StringUtils.isEmpty((String)endDate)) {
                logger.info("end_date\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                resultJson.put("result", "ILLEGAL_END_DATE");
                resultJson.put("status", "F");
                out.write(JSONArray.toJSONString(resultJson));
                return;
            }
            String bizNo = request.getParameter("biz_no");
            HashMap<String, String> signMap = new HashMap<String, String>();
            signMap.put("begin_date", beginDate);
            signMap.put("biz_no", bizNo);
            signMap.put("end_date", endDate);
            String localSign = BuilderUtils.sign(signMap, BuilderUtils.KEY);
            String admin = request.getParameter("admin");
            if (admin == null && !sign.equals(localSign)) {
                logger.info("\u7b7e\u540d\u4e0d\u4e00\u81f4\uff01");
                resultJson.put("result", "ERROR_SIGN");
                resultJson.put("status", "F");
                out.write(JSONArray.toJSONString(resultJson));
                return;
            }
            AgreementJson query = new AgreementJson(beginDate, endDate, bizNo);
            ResultDirector resultDirectorAM = new ResultDirector(new AgreementAMBuilder());
            ResultDirector resultDirectorW5 = new ResultDirector(new AgreementW5Builder());
            ResultDirector resultDirectorE3 = new ResultDirector(new AgreementE3Builder());
            ResultDirector resultDirectorAS = new ResultDirector(new AgreementASBuilder());
            ResultDirector resultDirectorYM = new ResultDirector(new AgreementYMBuilder());
            ResultDirector resultDirectorUP = new ResultDirector(new AgreementUPBuilder());
            ResultDirector resultDirectorTP = new ResultDirector(new AgreementTPBuilder());
            ResultDirector resultDirectorF = new ResultDirector(new AgreementFBuilder());
            Map<String, AgreementVO> resultMap = new TreeMap<String, AgreementVO>();
            Map<String, AgreementJson> resultAMMap = resultDirectorAM.construct(query);
            Map<String, AgreementJson> resultW5Map = resultDirectorW5.construct(query);
            Map<String, AgreementJson> resultE3Map = resultDirectorE3.construct(query);
            Map<String, AgreementJson> resultASMap = resultDirectorAS.construct(query);
            Map<String, AgreementJson> resultYMMap = resultDirectorYM.construct(query);
            Map<String, AgreementJson> resultUPMap = resultDirectorUP.construct(query);
            Map<String, AgreementJson> resultTPMap = resultDirectorTP.construct(query);
            Map<String, AgreementJson> resultFMap = resultDirectorF.construct(query);
            resultMap = BuilderUtils.conformityMap("AM", resultMap, resultAMMap);
            resultMap = BuilderUtils.conformityMap("W5", resultMap, resultW5Map);
            resultMap = BuilderUtils.conformityMap("E3", resultMap, resultE3Map);
            resultMap = BuilderUtils.conformityMap("AS", resultMap, resultASMap);
            resultMap = BuilderUtils.conformityMap("YM", resultMap, resultYMMap);
            resultMap = BuilderUtils.conformityMap("UP", resultMap, resultUPMap);
            resultMap = BuilderUtils.conformityMap("TP", resultMap, resultTPMap);
            resultMap = BuilderUtils.conformityMap("F", resultMap, resultFMap);
            Iterator<String> iter = resultMap.keySet().iterator();
            ArrayList<AgreementVO> resultList = new ArrayList<AgreementVO>();
            while (iter.hasNext()) {
                AgreementVO vo = resultMap.get(iter.next());
                resultList.add(vo);
            }
            resultJson.put("result", resultList);
            resultJson.put("status", "T");
            String result = JSONArray.toJSONString(resultJson);
            String excel = request.getParameter("excel");
            if (excel != null) {
                this.getExcel(result, response);
            } else {
                out.write(result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error:{}", (Object)e.toString());
            resultJson.put("result", "ERROR_SERVER");
            resultJson.put("status", "F");
            out.write(JSONArray.toJSONString(resultJson));
        }
        finally {
            if (out != null) {
                out.close();
            }
            long endTime = System.currentTimeMillis();
            logger.info("\u7b7e\u7ea6\u7edf\u8ba1\u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        }
    }

    public void getExcel(String json, HttpServletResponse response) {
        ExcelBaseBean te = new ExcelBaseBean();
        JsonResult temp = (JsonResult)JSON.parseObject((String)json, JsonResult.class);
        String status = temp.getStatus();
        List<AgreementVO> list = temp.getResult();
        if (status.equals("F")) {
            return;
        }
        response.reset();
        response.setContentType("application/ms-excel");
        try {
            HSSFWorkbook wb = te.makeAgreementExcel(list);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String fileName = "\u5305\u6708\u6570\u636e" + sdf.format(new Date());
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("gb2312"), "ISO8859-1") + ".xls");
            wb.write((OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            logger.error("excel err:" + e.toString());
            e.printStackTrace();
        }
    }
}

