/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.mycard.member;

import com.xunlei.mycard.member.MemberServiceAuthResult_vo;
import com.xunlei.mycard.member.MemberServiceAuthWithOTP_vo;
import com.xunlei.mycard.member.MemberServiceAuth_vo;
import com.xunlei.mycard.member.MemberTradeQuerySingleResult;
import com.xunlei.mycard.utils.MyCardReq2RespParser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class MemberServiceUtil {
    private static Logger logger = Logger.getLogger(MemberServiceUtil.class);
    public static String memberServiceAuth_url;
    public static String memberLoginService_url;
    public static String memberCostListRender_url;
    public static String memberServiceTradeQuery_url;
    public static String memberAddListRender_url;
    public static String memberServiceAuthWithOTP_url;
    public static String memberCostTradeQueryMutli_url;
    public static String memberAddTradeQueryMutli_url;
    public static String member_factoryid;
    public static String member_factoryserviceid;
    public static String memberQueryData_url;
    public static String memberloginnotice_url;
    public static String memberserviceauthwithopt_url;
    public static final String PAYSTATUS_Y = "Y";
    public static final String PAYSTATUS_W = "W";
    public static final String PAYSTATUS_F = "N";
    public static final String MEMBER_PAYTYPE = "Q2";

    public static void init() {
        InputStream inputStream = MemberServiceUtil.class.getResourceAsStream("/mycard.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            logger.error((Object)("load mycard.properties error : " + e.getMessage()));
            e.printStackTrace();
        }
        memberServiceAuth_url = properties.getProperty("memberServiceAuth_url").toString();
        memberLoginService_url = properties.getProperty("memberLoginService_url");
        memberCostListRender_url = properties.getProperty("memberCostListRender_url");
        memberServiceTradeQuery_url = properties.getProperty("memberServiceTradeQuery_url");
        memberAddListRender_url = properties.getProperty("memberAddListRender_url");
        memberServiceAuthWithOTP_url = properties.getProperty("memberServiceAuthWithOTP_url");
        memberAddTradeQueryMutli_url = properties.getProperty("memberAddTradeQueryMutli_url");
        member_factoryid = properties.getProperty("member_factoryid");
        member_factoryserviceid = properties.getProperty("member_factoryserviceid");
        memberQueryData_url = properties.getProperty("memberQueryData_url");
        memberloginnotice_url = properties.getProperty("memberloginnotice_url");
        memberserviceauthwithopt_url = properties.getProperty("memberserviceauthwithopt_url");
    }

    public static String getMemberServiceAuthReq_url(MemberServiceAuth_vo auth) {
        auth.setFactoryId(member_factoryid);
        auth.setFactoryServiceId(member_factoryserviceid);
        auth.setFactoryReturnUrl(memberloginnotice_url);
        StringBuilder authUrl = new StringBuilder(memberServiceAuth_url);
        authUrl.append("?");
        Map<String, String> authMap = MemberServiceUtil.formatObject2Map(auth);
        Iterator<Map.Entry<String, String>> iterator = authMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String val = entry.getValue();
            if (iterator.hasNext()) {
                authUrl.append(key).append("=").append(val).append("&");
                continue;
            }
            authUrl.append(key).append("=").append(val);
        }
        String url = authUrl.toString();
        logger.debug((Object)("MemberServiceAuthReq_url : " + url));
        return url;
    }

    public static MemberServiceAuthResult_vo getMemberServiceAuthResult(MemberServiceAuth_vo auth) throws Exception {
        String authUrl = MemberServiceUtil.getMemberServiceAuthReq_url(auth);
        Element root = MyCardReq2RespParser.getRootElem(authUrl);
        String returnMsgNo = root.elementText("ReturnMsgNo");
        String returnTradeSeq = root.elementText("ReturnTradeSeq");
        String returnAuthCode = root.elementText("ReturnAuthCode");
        MemberServiceAuthResult_vo result = new MemberServiceAuthResult_vo();
        result.setReturnAuthCode(returnAuthCode);
        result.setReturnMsgNo(returnMsgNo);
        result.setReturnTradeSeq(returnTradeSeq);
        return result;
    }

    public static String getMemberLoginService_url(String authcode) {
        String url = memberLoginService_url + "?" + "AuthCode=" + authcode;
        logger.debug((Object)("MemberLoginService_url : " + url));
        return url;
    }

    public static String getMemberCostListRender_url(String authcode, String oneTimePassword) {
        String url = memberCostListRender_url + "?" + "AuthCode=" + authcode + "&OneTimePassword=" + oneTimePassword;
        logger.debug((Object)("memberCostListRender_url = " + url));
        return url;
    }

    public static String getMemberAddListRender_url(String authcode, String oneTimePassword) {
        String url = memberAddListRender_url + "?" + "AuthCode=" + authcode + "&OneTimePassword=" + oneTimePassword;
        logger.debug((Object)("memberAddListRender_url : " + url));
        return url;
    }

    public static String getMemberServiceAuthWithOTP_url(MemberServiceAuthWithOTP_vo opt) {
        opt.setFactoryId(member_factoryid);
        opt.setFactoryServiceId(member_factoryserviceid);
        opt.setFactoryReturnUrl(memberserviceauthwithopt_url);
        StringBuilder authUrl = new StringBuilder(memberServiceAuthWithOTP_url);
        authUrl.append("?");
        Map<String, String> optMap = MemberServiceUtil.formatObject2Map(opt);
        Iterator<Map.Entry<String, String>> iterator = optMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String key = entry.getKey();
            String val = entry.getValue();
            if (iterator.hasNext()) {
                authUrl.append(key).append("=").append(val).append("&");
                continue;
            }
            authUrl.append(key).append("=").append(val);
        }
        String url = authUrl.toString();
        logger.debug((Object)("memberServiceAuthWithOTP_url : " + url));
        return url;
    }

    public static String getMemberServiceTradeQuery_url(String authcode, String oneTimePassword) {
        String url = memberServiceTradeQuery_url + "?" + "AuthCode=" + authcode + "&OneTimePassword=" + oneTimePassword;
        logger.debug((Object)("memberServiceTradeQuery_url : " + url));
        return url;
    }

    public static MemberTradeQuerySingleResult queryMemberTradeSingleResult(String authcode, String oneTimePassword) throws Exception {
        String queryUrl = MemberServiceUtil.getMemberServiceTradeQuery_url(authcode, oneTimePassword);
        Element root = MyCardReq2RespParser.getRootElem(queryUrl);
        String myCardCustId = root.elementText("MyCardCustId");
        String myCardPoint = root.elementText("MyCardPoint");
        String myCardBonus = root.elementText("MyCardBonus");
        String facTradeSeq = root.elementText("FacTradeSeq");
        String tradeResult = root.elementText("TradeResult");
        String returnMsgNo = root.elementText("ReturnMsgNo");
        MemberTradeQuerySingleResult result = new MemberTradeQuerySingleResult();
        result.setMyCardCustId(myCardCustId);
        result.setMyCardPoint(myCardPoint);
        result.setMyCardBonus(myCardBonus);
        result.setFacTradeSeq(facTradeSeq);
        result.setTradeResult(tradeResult);
        result.setReturnMsgNo(returnMsgNo);
        return result;
    }

    public static String getMemberCostTradeQueryMutli_url(String factoryId, String startDate, String endDate) {
        String url = memberCostTradeQueryMutli_url + "FactoryId=" + factoryId + "&StartDate=" + startDate + "&EndDate=" + endDate;
        logger.debug((Object)("memberCostTradeQueryMutli_url = " + url));
        return url;
    }

    public static String getMemberAddTradeQueryMulti_url(String factoryId, String startDate, String endDate) {
        String url = memberAddTradeQueryMutli_url + "FactoryId=" + factoryId + "&StartDate=" + startDate + "&EndDate=" + endDate;
        logger.debug((Object)("memberAddTradeQueryMutli_url = " + url));
        return url;
    }

    private static Map<String, String> formatObject2Map(Object obj) {
        Method[] methods;
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = obj.getClass();
        for (Method one : methods = clazz.getDeclaredMethods()) {
            if (!one.getName().startsWith("get")) continue;
            try {
                map.put(one.getName().substring(3), one.invoke(obj, new Object[0]).toString());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                logger.error((Object)("method : " + one.getName() + "InvocationTargetException : " + e.getMessage()));
                e.printStackTrace();
            }
        }
        return map;
    }

    static {
        MemberServiceUtil.init();
    }
}

