/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.mycard.ingame;

import com.xunlei.mycard.axis.client.MyCardInGameQueryLocator;
import com.xunlei.mycard.axis.client.MyCardInGameQuerySoap;
import com.xunlei.mycard.axis.client.MyCardServiceLocator;
import com.xunlei.mycard.axis.client.MyCardServiceSoap;
import com.xunlei.mycard.axis.client.QueryInGameResult;
import com.xunlei.mycard.axis.client.ReturnSaveResult;
import com.xunlei.mycard.ingame.MyCardRender_vo;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class MyCardIngameUtil {
    private static Logger logger = Logger.getLogger(MyCardIngameUtil.class);
    public static String service_url;
    public static String ingamequery_url;
    public static String ingame_gamefacid;

    private static void init() {
        InputStream inputStream = MyCardIngameUtil.class.getResourceAsStream("/mycard.properties");
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            logger.error((Object)("load mycard.properties error : " + e.getMessage()));
            e.printStackTrace();
        }
        service_url = properties.get("service_url").toString();
        ingamequery_url = properties.get("ingamequery_url").toString();
        ingame_gamefacid = properties.getProperty("ingame_gamefacid");
    }

    public static ReturnSaveResult getCardRenderResult(MyCardRender_vo render) {
        MyCardServiceLocator service = new MyCardServiceLocator();
        MyCardServiceSoap soap = null;
        try {
            soap = service.getMyCardServiceSoap();
        }
        catch (ServiceException e1) {
            logger.error((Object)("getCardRenderResult catch ServiceException : " + e1.getMessage()));
            e1.printStackTrace();
        }
        ReturnSaveResult result = null;
        try {
            result = soap.myCardRender(render.getMyCardCardId(), render.getMyCArdPwd(), render.getGameFaceId(), render.getGameUser(), render.getGame_No(), render.getGameCard_ID());
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    public static QueryInGameResult getQueryIngameResult(String myCardCardId) {
        QueryInGameResult result = null;
        MyCardInGameQueryLocator query2 = new MyCardInGameQueryLocator();
        try {
            MyCardInGameQuerySoap soap = query2.getMyCardInGameQuerySoap();
            result = soap.queryInGame(myCardCardId, ingame_gamefacid);
        }
        catch (ServiceException e) {
            logger.error((Object)e.getMessage());
        }
        catch (RemoteException e) {
            logger.error((Object)e.getMessage());
        }
        return result;
    }

    public static void main(String[] args) {
        MyCardIngameUtil.init();
    }

    static {
        MyCardIngameUtil.init();
    }
}

