/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.report.service.pay;

import com.xunlei.channel.report.dao.PayProxyPayOrderDao;
import com.xunlei.channel.report.id.IdOffsetRepository;
import com.xunlei.channel.report.pojo.ReportData;
import com.xunlei.channel.report.pojo.ReportDataSet;
import com.xunlei.channel.report.pojo.pay.PayOrderReportDataSet;
import com.xunlei.channel.report.record.impl.PayOrderFailedRecordFileRepository;
import com.xunlei.channel.report.service.ReportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class PayProxyPayOrderReportService
implements ReportService,
BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(PayProxyPayOrderReportService.class);
    private String beanName;
    @Autowired
    private IdOffsetRepository idOffsetRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private PayOrderFailedRecordFileRepository payOrderFailedRecordRepository;
    @Autowired
    private PayProxyPayOrderDao payProxyPayOrderDao;
    private String bizorderFailedRecordsFile = "xlpayproxy-bizorder-failed-records.json";
    private String bizorderIdOffsetFile = "xlpayproxy-bizorder.properties";
    private String bizorderOkIdOffsetFile = "xlpayproxy-bizorder-okid.properties";

    @Override
    public ReportDataSet nextDataSet() {
        PayOrderReportDataSet dataSet = new PayOrderReportDataSet();
        Collection<ReportData> reportDataCollection = this.getPayProxyReportDataCollection();
        dataSet.setPayOrderReportDatas(reportDataCollection);
        HashSet<ReportData> failedRecords = new HashSet<ReportData>();
        failedRecords.addAll(reportDataCollection);
        dataSet.setFailedRecords(failedRecords);
        return dataSet;
    }

    private Collection<ReportData> getPayProxyReportDataCollection() {
        long currentId = this.idOffsetRepository.currentId(this.bizorderIdOffsetFile);
        long currentOkId = this.idOffsetRepository.currentId(this.bizorderOkIdOffsetFile);
        Long maxId = this.payProxyPayOrderDao.queryMaxId(currentId, 65535L);
        Long maxOkId = this.payProxyPayOrderDao.queryMaxOkId(currentOkId, 65535L);
        if (maxId == null) {
            maxId = currentId;
        }
        if (maxOkId == null) {
            maxOkId = currentOkId;
        }
        List payOrderReportDataList = this.payProxyPayOrderDao.queryPayProxyOrderList(currentId, maxId.longValue(), currentOkId, maxOkId.longValue());
        Set failedRecords = this.payOrderFailedRecordRepository.getFailedRecords(this.bizorderFailedRecordsFile);
        if (!CollectionUtils.isEmpty((Collection)failedRecords)) {
            logger.warn("Getting fail records: {} from payOrderFailedRecordRepository", (Object)failedRecords);
        }
        ArrayList<ReportData> reportDataCollection = new ArrayList<ReportData>();
        reportDataCollection.addAll(payOrderReportDataList);
        reportDataCollection.addAll(failedRecords);
        this.setNextSeqId(maxId, maxOkId);
        return reportDataCollection;
    }

    private void setNextSeqId(Long maxId, Long maxOkId) {
        if (maxId != null) {
            this.idOffsetRepository.setCurrentId(this.bizorderIdOffsetFile, maxId);
        }
        if (maxOkId != null) {
            this.idOffsetRepository.setCurrentId(this.bizorderOkIdOffsetFile, maxOkId);
        }
    }

    @Override
    public void handleFailedRecords(Set<ReportData> failedRecords) {
        this.payOrderFailedRecordRepository.saveFailedRecords(this.bizorderFailedRecordsFile, failedRecords);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setIdOffsetRepository(IdOffsetRepository idOffsetRepository) {
        this.idOffsetRepository = idOffsetRepository;
    }

    public IdOffsetRepository getIdOffsetRepository() {
        return this.idOffsetRepository;
    }

    public PayOrderFailedRecordFileRepository getPayOrderFailedRecordRepository() {
        return this.payOrderFailedRecordRepository;
    }

    public void setPayOrderFailedRecordRepository(PayOrderFailedRecordFileRepository payOrderFailedRecordRepository) {
        this.payOrderFailedRecordRepository = payOrderFailedRecordRepository;
    }

    public PayProxyPayOrderDao getPayProxyPayOrderDao() {
        return this.payProxyPayOrderDao;
    }

    public void setPayProxyPayOrderDao(PayProxyPayOrderDao payProxyPayOrderDao) {
        this.payProxyPayOrderDao = payProxyPayOrderDao;
    }

    public String getBizorderokIdOffsetFile() {
        return this.bizorderIdOffsetFile;
    }

    public void setBizorderokIdOffsetFile(String bizorderokIdOffsetFile) {
        this.bizorderIdOffsetFile = bizorderokIdOffsetFile;
    }

    public String getBizorderokFailedRecordsFile() {
        return this.bizorderFailedRecordsFile;
    }

    public void setBizorderokFailedRecordsFile(String bizorderokFailedRecordsFile) {
        this.bizorderFailedRecordsFile = bizorderokFailedRecordsFile;
    }
}

