/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.report.service.pay;

import com.xunlei.channel.report.dao.PayProxyPayOrderOKDao;
import com.xunlei.channel.report.id.IdOffsetRepository;
import com.xunlei.channel.report.pojo.ReportData;
import com.xunlei.channel.report.pojo.ReportDataSet;
import com.xunlei.channel.report.pojo.pay.PayOrderReportDataSet;
import com.xunlei.channel.report.record.impl.PayOrderFailedRecordFileRepository;
import com.xunlei.channel.report.service.ReportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class PayProxyPayOrderOKReportService
implements ReportService,
BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(PayProxyPayOrderOKReportService.class);
    private String beanName;
    @Autowired
    private IdOffsetRepository idOffsetRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private PayOrderFailedRecordFileRepository payOrderFailedRecordRepository;
    @Autowired
    private PayProxyPayOrderOKDao payProxyPayOrderOKDao;
    private String bizorderokFailedRecordsFile = "xlpayproxy-bizorderok-failed-records.json";
    private String bizorderokIdOffsetFile = "xlpayproxy-bizorderok.properties";

    @Override
    public ReportDataSet nextDataSet() {
        PayOrderReportDataSet dataSet = new PayOrderReportDataSet();
        Collection<ReportData> reportDataCollection = this.getPayProxyReportDataCollection();
        dataSet.setPayOrderReportDatas(reportDataCollection);
        HashSet<ReportData> failedRecords = new HashSet<ReportData>();
        failedRecords.addAll(reportDataCollection);
        dataSet.setFailedRecords(failedRecords);
        return dataSet;
    }

    private Collection<ReportData> getPayProxyReportDataCollection() {
        long currentId = this.idOffsetRepository.currentId(this.bizorderokIdOffsetFile);
        Long maxId = this.payProxyPayOrderOKDao.queryMaxId(currentId, 65535L);
        if (maxId == null) {
            maxId = currentId;
        }
        List payOrderReportDataList = this.payProxyPayOrderOKDao.queryPayProxyOrderList(currentId, maxId.longValue());
        Set failedRecords = this.payOrderFailedRecordRepository.getFailedRecords(this.bizorderokFailedRecordsFile);
        ArrayList<ReportData> reportDataCollection = new ArrayList<ReportData>();
        reportDataCollection.addAll(payOrderReportDataList);
        reportDataCollection.addAll(failedRecords);
        this.setNextSeqId(maxId);
        return reportDataCollection;
    }

    private void setNextSeqId(Long maxId) {
        if (maxId != null) {
            this.idOffsetRepository.setCurrentId(this.bizorderokIdOffsetFile, maxId);
        }
    }

    @Override
    public void handleFailedRecords(Set<ReportData> failedRecords) {
        this.payOrderFailedRecordRepository.saveFailedRecords(this.bizorderokFailedRecordsFile, failedRecords);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setIdOffsetRepository(IdOffsetRepository idOffsetRepository) {
        this.idOffsetRepository = idOffsetRepository;
    }

    public IdOffsetRepository getIdOffsetRepository() {
        return this.idOffsetRepository;
    }

    public PayOrderFailedRecordFileRepository getPayOrderFailedRecordRepository() {
        return this.payOrderFailedRecordRepository;
    }

    public void setPayOrderFailedRecordRepository(PayOrderFailedRecordFileRepository payOrderFailedRecordRepository) {
        this.payOrderFailedRecordRepository = payOrderFailedRecordRepository;
    }

    public PayProxyPayOrderOKDao getPayProxyPayOrderOKDao() {
        return this.payProxyPayOrderOKDao;
    }

    public void setPayProxyPayOrderOKDao(PayProxyPayOrderOKDao payProxyPayOrderOKDao) {
        this.payProxyPayOrderOKDao = payProxyPayOrderOKDao;
    }

    public String getBizorderokIdOffsetFile() {
        return this.bizorderokIdOffsetFile;
    }

    public void setBizorderokIdOffsetFile(String bizorderokIdOffsetFile) {
        this.bizorderokIdOffsetFile = bizorderokIdOffsetFile;
    }

    public String getBizorderokFailedRecordsFile() {
        return this.bizorderokFailedRecordsFile;
    }

    public void setBizorderokFailedRecordsFile(String bizorderokFailedRecordsFile) {
        this.bizorderokFailedRecordsFile = bizorderokFailedRecordsFile;
    }
}

