/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.report.service.pay;

import com.xunlei.channel.report.dao.GatewayPayOrderDao;
import com.xunlei.channel.report.id.IdOffsetRepository;
import com.xunlei.channel.report.pojo.ReportData;
import com.xunlei.channel.report.pojo.ReportDataSet;
import com.xunlei.channel.report.pojo.pay.PayOrderReportDataSet;
import com.xunlei.channel.report.record.impl.PayOrderFailedRecordFileRepository;
import com.xunlei.channel.report.service.ReportService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class GatewayPayOrderReportService
implements ReportService,
BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(GatewayPayOrderReportService.class);
    private String beanName;
    @Autowired
    private IdOffsetRepository idOffsetRepository;
    @Autowired
    private PayOrderFailedRecordFileRepository payOrderFailedRecordRepository;
    @Autowired
    private GatewayPayOrderDao payOrderDao;
    private String payorderFailedRecordsFile = "gateway-payorder-failed-records.json";
    private String payorderIdOffsetFile = "gateway-payorder.properties";

    @Override
    public ReportDataSet nextDataSet() {
        PayOrderReportDataSet dataSet = new PayOrderReportDataSet();
        Collection<ReportData> reportDataCollection = this.getReportDataCollection();
        dataSet.setPayOrderReportDatas(reportDataCollection);
        HashSet<ReportData> failedRecords = new HashSet<ReportData>();
        failedRecords.addAll(reportDataCollection);
        dataSet.setFailedRecords(failedRecords);
        return dataSet;
    }

    private Collection<ReportData> getReportDataCollection() {
        long currentId = this.idOffsetRepository.currentId(this.payorderIdOffsetFile);
        Long maxId = this.payOrderDao.queryMaxId(currentId, 65535L);
        if (maxId == null) {
            maxId = currentId;
        }
        List payOrderReportDataList = this.payOrderDao.queryGatewayOrders(currentId, maxId.longValue());
        Set failedRecords = this.payOrderFailedRecordRepository.getFailedRecords(this.payorderFailedRecordsFile);
        if (!CollectionUtils.isEmpty((Collection)failedRecords)) {
            logger.warn("Getting fail records: {} from payOrderFailedRecordRepository", (Object)failedRecords);
        }
        ArrayList<ReportData> reportDataCollection = new ArrayList<ReportData>();
        reportDataCollection.addAll(payOrderReportDataList);
        reportDataCollection.addAll(failedRecords);
        this.setNextSeqId(maxId);
        return reportDataCollection;
    }

    private void setNextSeqId(Long maxId) {
        if (maxId != null) {
            this.idOffsetRepository.setCurrentId(this.payorderIdOffsetFile, maxId);
        }
    }

    @Override
    public void handleFailedRecords(Set<ReportData> failedRecords) {
        this.payOrderFailedRecordRepository.saveFailedRecords(this.payorderFailedRecordsFile, failedRecords);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setPayOrderFailedRecordRepository(PayOrderFailedRecordFileRepository payOrderFailedRecordRepository) {
        this.payOrderFailedRecordRepository = payOrderFailedRecordRepository;
    }

    public void setIdOffsetRepository(IdOffsetRepository idOffsetRepository) {
        this.idOffsetRepository = idOffsetRepository;
    }

    public void setPayOrderDao(GatewayPayOrderDao payOrderDao) {
        this.payOrderDao = payOrderDao;
    }

    public IdOffsetRepository getIdOffsetRepository() {
        return this.idOffsetRepository;
    }

    public PayOrderFailedRecordFileRepository getPayOrderFailedRecordRepository() {
        return this.payOrderFailedRecordRepository;
    }

    public GatewayPayOrderDao getPayOrderDao() {
        return this.payOrderDao;
    }

    public String getPayorderokFailedRecordsFile() {
        return this.payorderFailedRecordsFile;
    }

    public void setPayorderokFailedRecordsFile(String payorderokFailedRecordsFile) {
        this.payorderFailedRecordsFile = payorderokFailedRecordsFile;
    }

    public String getPayorderokIdOffsetFile() {
        return this.payorderIdOffsetFile;
    }

    public void setPayorderokIdOffsetFile(String payorderokIdOffsetFile) {
        this.payorderIdOffsetFile = payorderokIdOffsetFile;
    }
}

