/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.report.service.machine;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.report.id.IdOffsetRepository;
import com.xunlei.channel.report.pojo.ReportData;
import com.xunlei.channel.report.pojo.ReportDataSet;
import com.xunlei.channel.report.pojo.machine.MachineReportData;
import com.xunlei.channel.report.pojo.machine.MachineReportDataSet;
import com.xunlei.channel.report.service.ReportService;
import com.xunlei.channel.report.util.ConfigFileUtil;
import com.xunlei.channel.report.util.HttpUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class MachineReportService
implements ReportService,
BeanNameAware {
    @Autowired
    private IdOffsetRepository idOffsetRepository;
    private static final Logger logger = LoggerFactory.getLogger(MachineReportService.class);
    private String beanName;
    private String machineIdOffsetFile = "machineInfo.properties";

    @Override
    public ReportDataSet nextDataSet() {
        MachineReportDataSet machineReportDataSet = new MachineReportDataSet();
        long seqId = this.idOffsetRepository.currentId(this.machineIdOffsetFile);
        long id = seqId < 1L ? 1L : seqId;
        Collection<ReportData> reportDataCollection = this.getReportDataCollection(id);
        machineReportDataSet.setMachineReportDataCollection(reportDataCollection);
        this.increaseSeqId(reportDataCollection.size());
        return machineReportDataSet;
    }

    @Override
    public void handleFailedRecords(Set<ReportData> failedRecords) {
    }

    private long increaseSeqId(int currentDataSize) {
        Long seqId = this.idOffsetRepository.currentId(this.machineIdOffsetFile);
        Long id = seqId == null || seqId < 1L ? 1L : seqId;
        id = id + (long)currentDataSize;
        this.idOffsetRepository.setCurrentId(this.getKey(), id);
        return id;
    }

    public Collection<ReportData> getReportDataCollection(long currentId) {
        ArrayList<ReportData> reportDataCollection = new ArrayList<ReportData>();
        Map<String, String> machineInfoMap = this.getConfigMap();
        Set<String> keySet = machineInfoMap.keySet();
        for (String machineNo : keySet) {
            String url = machineInfoMap.get(machineNo);
            MachineReportData machineReportData = this.requestMachineReportData(machineNo, url, currentId);
            reportDataCollection.add((ReportData)machineReportData);
            if (logger.isDebugEnabled()) {
                logger.debug("Getting report data collection... add machineReportData: {}", (Object)machineReportData);
            }
            ++currentId;
        }
        return reportDataCollection;
    }

    public Map<String, String> getConfigMap() {
        HashMap<String, String> machineInfoMap = new HashMap<String, String>();
        ConfigFileUtil.parsingConfig((String)this.machineIdOffsetFile, machineInfoMap);
        return machineInfoMap;
    }

    public MachineReportData requestMachineReportData(String machineNo, String url, long currentId) {
        MachineReportData machineReportData = new MachineReportData();
        machineReportData.setSeqId(currentId);
        machineReportData.setMachineNo(machineNo);
        String responseData = HttpUtil.doGet((String)url);
        if (StringUtils.isEmpty((Object)responseData)) {
            logger.error("serverName: {}, url: {}, occurred some problems, responseData: {}", new Object[]{machineNo, url, responseData});
            machineReportData.setSuccess(false);
        } else {
            JSONObject responseObj = JSON.parseObject((String)responseData);
            machineReportData.setCpuUsage(responseObj.getFloat("cpuUsage").floatValue());
            machineReportData.setMemUsage(responseObj.getFloat("memUsage").floatValue());
            machineReportData.setIoUsage(responseObj.getFloat("ioUsage").floatValue());
            machineReportData.setTimestamp(responseObj.getLong("timestamp").longValue());
            machineReportData.setSuccess(true);
        }
        return machineReportData;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getKey() {
        return this.machineIdOffsetFile;
    }

    public void setIdOffsetRepository(IdOffsetRepository idOffsetRepository) {
        this.idOffsetRepository = idOffsetRepository;
    }
}

