/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.service;

import com.xunlei.channel.report.MachineInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MachineStatisticsService {
    private static final Logger logger = LoggerFactory.getLogger(MachineStatisticsService.class);

    public MachineInfo getMachineInfo() {
        float cpuUsage = 0.0f;
        float memUsage = 0.0f;
        float ioUsage = 0.0f;
        try {
            cpuUsage = this.getCPU();
            memUsage = this.getMem();
            ioUsage = this.getIO();
        }
        catch (Exception e) {
            logger.error("error: {}", (Object)e.getMessage());
        }
        MachineInfo machineInfo = new MachineInfo();
        machineInfo.setCpuUsage(cpuUsage);
        machineInfo.setMemUsage(memUsage);
        machineInfo.setIoUsage(ioUsage);
        machineInfo.setTimestamp(new Date().getTime());
        return machineInfo;
    }

    private float getIO() {
        float ioUsage = 0.0f;
        Process pro = null;
        Runtime r = Runtime.getRuntime();
        try {
            String command = "iostat -d -x";
            pro = r.exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            String line = null;
            int count = 0;
            while ((line = in.readLine()) != null) {
                String[] temp;
                if (++count < 4 || (temp = line.split("\\s+")).length <= 1) continue;
                float util = Float.parseFloat(temp[temp.length - 1]);
                ioUsage = ioUsage > util ? ioUsage : util;
            }
            if (ioUsage > 0.0f) {
                logger.info("IO Usage: " + ioUsage);
                ioUsage /= 100.0f;
            }
            in.close();
            pro.destroy();
        }
        catch (IOException e) {
            logger.error("calculating IO failed, error: {}", (Object)e.getMessage());
        }
        return ioUsage;
    }

    private float getMem() {
        float memUsage = 0.0f;
        Process pro = null;
        Runtime r = Runtime.getRuntime();
        try {
            String command = "cat /proc/meminfo";
            pro = r.exec(command);
            BufferedReader in = new BufferedReader(new InputStreamReader(pro.getInputStream()));
            String line = null;
            int count = 0;
            long totalMem = 0L;
            long freeMem = 0L;
            while ((line = in.readLine()) != null) {
                System.out.println(line);
                String[] memInfo = line.split("\\s+");
                if (memInfo[0].startsWith("MemTotal")) {
                    totalMem = Long.parseLong(memInfo[1]);
                }
                if (memInfo[0].startsWith("MemFree")) {
                    freeMem = Long.parseLong(memInfo[1]);
                }
                memUsage = 1.0f - (float)freeMem / (float)totalMem;
                logger.info("memory usage: " + memUsage);
                if (++count != 2) continue;
                break;
            }
            in.close();
            pro.destroy();
        }
        catch (IOException e) {
            logger.error("calculating memory usage failed, error: " + e.getMessage(), (Throwable)e);
        }
        return memUsage;
    }

    private float getCPU() throws Exception {
        float cpuUsage = 0.0f;
        Runtime r = Runtime.getRuntime();
        try {
            String command = "cat /proc/stat";
            long startTime = System.currentTimeMillis();
            Process pro1 = r.exec(command);
            BufferedReader in1 = new BufferedReader(new InputStreamReader(pro1.getInputStream()));
            String line = null;
            long idleCpuTime1 = 0L;
            long totalCpuTime1 = 0L;
            while ((line = in1.readLine()) != null) {
                if (!line.startsWith("cpu")) continue;
                line = line.trim();
                logger.info(line);
                String[] temp = line.split("\\s+");
                idleCpuTime1 = Long.parseLong(temp[4]);
                for (String s : temp) {
                    if (s.equals("cpu")) continue;
                    totalCpuTime1 += Long.parseLong(s);
                }
                logger.info("IdleCpuTime: {},  TotalCpuTime: {}", (Object)idleCpuTime1, (Object)totalCpuTime1);
                break;
            }
            in1.close();
            pro1.destroy();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                logger.error("error: {}", (Object)e.getMessage());
            }
            long endTime = System.currentTimeMillis();
            Process pro2 = r.exec(command);
            BufferedReader in2 = new BufferedReader(new InputStreamReader(pro2.getInputStream()));
            long idleCpuTime2 = 0L;
            long totalCpuTime2 = 0L;
            while ((line = in2.readLine()) != null) {
                if (!line.startsWith("cpu")) continue;
                line = line.trim();
                logger.info(line);
                String[] temp = line.split("\\s+");
                idleCpuTime2 = Long.parseLong(temp[4]);
                for (String s : temp) {
                    if (s.equals("cpu")) continue;
                    totalCpuTime2 += Long.parseLong(s);
                }
                logger.info("IdleCpuTime: {},  TotalCpuTime: {}", (Object)idleCpuTime2, (Object)totalCpuTime2);
                break;
            }
            if (idleCpuTime1 != 0L && totalCpuTime1 != 0L && idleCpuTime2 != 0L && totalCpuTime2 != 0L) {
                cpuUsage = 1.0f - (float)(idleCpuTime2 - idleCpuTime1) / (float)(totalCpuTime2 - totalCpuTime1);
                logger.info("cpuUsage: " + cpuUsage);
            }
            in2.close();
            pro2.destroy();
        }
        catch (IOException e) {
            logger.error("calculating CPU faced some error: {}", (Object)e.getMessage());
        }
        return cpuUsage;
    }

    public static void main(String[] args) {
        MachineStatisticsService machineStatisticsService = new MachineStatisticsService();
        MachineInfo machineInfo = machineStatisticsService.getMachineInfo();
        System.out.println(machineInfo);
    }
}

