/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.report.dao;

import com.xunlei.channel.report.pojo.pay.PayOrderReportData;
import com.xunlei.channel.util.AmountUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class PayProxyPayOrderDao {
    private static final Logger logger = LoggerFactory.getLogger(PayProxyPayOrderDao.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String QUERY_SQL = "SELECT p.SeqId, p.Version, p.XunleiPayId, p.BgUrl, p.FgUrl, p.BizNo,b.BizName, p.BizOrderId, p.PayType,c.ItemName, p.OrderAmt, p.ExtPayCompany, p.ExtPayOrderId, p.OrderTime,p.InputTime, p.BankNo, p.UserShow, p.ProductName, p.ProductDesc,  p.XunleiId,   p.OrderStatus, p.OrderGroup, p.Ext1, p.Ext2, p.OrderIp, p.Type, p.PeerId, p.SendNoticeStatus FROM (SELECT SeqId, Version, XunleiPayId, BgUrl, FgUrl, BizNo, BizOrderId, PayType,OrderAmt, ExtPayCompany, ExtPayOrderId, OrderTime,InputTime, BankNo, UserShow, ProductName, ProductDesc,  XunleiId,   OrderStatus, OrderGroup, Ext1, Ext2, OrderIp, Type, PeerId, SendNoticeStatus          from xlpayproxy.bizorder WHERE SeqId>? AND SeqId<=?      UNION      SELECT SeqId, Version, XunleiPayId, BgUrl, FgUrl, BizNo, BizOrderId, PayType,OrderAmt, ExtPayCompany, ExtPayOrderId, OrderTime,OrderTime AS InputTime, BankNo, UserShow, ProductName, ProductDesc,  XunleiId, 'S' AS OrderStatus, OrderGroup, Ext1, Ext2, OrderIp, Type, PeerId, SendNoticeStatus       from xlpayproxy.bizorderok WHERE SeqId>? AND SeqId<=?     ) as p, xlpayproxy.libclassd c, xlpayproxy.copbizinfo b WHERE p.PayType=c.ItemNo AND c.ClassNo='PayTypeShow' AND p.BizNo=b.BizNo  ORDER by p.SeqId";
    private static final String QUERY_MAX_ID_SQL = "SELECT max(SeqId) FROM (SELECT seqid FROM xlpayproxy.bizorder WHERE SeqId>? ORDER by SeqId limit ?) p";
    private static final String QUERY_MAX_OK_ID_SQL = "SELECT max(SeqId) FROM (SELECT seqid FROM xlpayproxy.bizorderok WHERE SeqId>? ORDER by SeqId limit ?) p ";

    public List<PayOrderReportData> queryPayProxyOrderList(long reqMinSeqId, long reqMaxId, long okMinSeqId, long okMaxId) {
        final ArrayList<PayOrderReportData> payOrderReportDataList = new ArrayList<PayOrderReportData>();
        this.jdbcTemplate.query(QUERY_SQL, (Object[])new Long[]{reqMinSeqId, reqMaxId, okMinSeqId, okMaxId}, new int[]{-5, -5, -5, -5}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                PayOrderReportData payOrderReportData = new PayOrderReportData();
                long seqId = rs.getLong("SeqId");
                payOrderReportData.setId("xlpayproxy.bizorder-" + seqId);
                payOrderReportData.setVersion(rs.getString("Version"));
                payOrderReportData.setXunleiPayId(rs.getString("XunleiPayId"));
                payOrderReportData.setPageUrl(rs.getString("FgUrl"));
                payOrderReportData.setNotifyUrl(rs.getString("BgUrl"));
                payOrderReportData.setBizNo(rs.getString("BizNo"));
                payOrderReportData.setBizName(rs.getString("BizName"));
                payOrderReportData.setBizOrderId(rs.getString("BizOrderId"));
                payOrderReportData.setPayType(rs.getString("PayType"));
                payOrderReportData.setPayTypeDisplay(rs.getString("ItemName"));
                payOrderReportData.setOrderAmt(AmountUtil.doubleYuanToIntFen((String)rs.getString("OrderAmt")));
                payOrderReportData.setOrderGroup(rs.getString("OrderGroup"));
                payOrderReportData.setXunleiId(rs.getString("XunleiId"));
                payOrderReportData.setUserShow(rs.getString("UserShow"));
                payOrderReportData.setProductName(rs.getString("ProductName"));
                payOrderReportData.setProductDesc(rs.getString("ProductDesc"));
                payOrderReportData.setBankNo(rs.getString("BankNo"));
                payOrderReportData.setStatus(rs.getString("OrderStatus"));
                payOrderReportData.setBizExt(rs.getString("Ext1") + "-" + rs.getString("Ext2"));
                payOrderReportData.setOrderIp(rs.getString("OrderIp"));
                payOrderReportData.setOrderType(rs.getString("Type"));
                payOrderReportData.setPeerId(rs.getString("PeerId"));
                payOrderReportData.setReqTime(rs.getString("InputTime"));
                payOrderReportDataList.add(payOrderReportData);
            }
        });
        return payOrderReportDataList;
    }

    public Long queryMaxId(long minSeqId, long maxSize) {
        Long aLong = (Long)this.jdbcTemplate.queryForObject(QUERY_MAX_ID_SQL, (Object[])new Long[]{minSeqId, maxSize}, new int[]{-5, -5}, Long.class);
        return aLong;
    }

    public Long queryMaxOkId(long minSeqId, long maxSize) {
        Long aLong = (Long)this.jdbcTemplate.queryForObject(QUERY_MAX_OK_ID_SQL, (Object[])new Long[]{minSeqId, maxSize}, new int[]{-5, -5}, Long.class);
        return aLong;
    }
}

