/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.report.dao;

import com.xunlei.channel.report.pojo.pay.PayOrderReportData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class GatewayPayOrderDao {
    private static final Logger logger = LoggerFactory.getLogger(GatewayPayOrderDao.class);
    public static final String QUERY_SQL = "SELECT p.id,p.version,p.xunlei_pay_id,p.page_url,p.notify_url,p.biz_no,b.BizName,p.biz_order_id,p.pay_type,c.itemName,p.order_amt,p.order_group,p.xunlei_id,p.user_show,p.product_name,p.product_desc,p.fact_amt,p.fare_amt,p.biz_ext,p.order_ip,p.order_type,p.peer_id,p.balance_date,p.send_notice_status,p.req_time,p.channel_order_id,p.product_id,p.phone,p.extra_json FROM gateway.pay_order_ok p, xlpayproxy.libclassd c, xlpayproxy.copbizinfo b WHERE p.id > ? AND p.id <= ? AND p.pay_type=c.ItemNo AND c.ClassNo='PayTypeShow' AND p.biz_no=b.BizNo ORDER BY p.id";
    public static final String QUERY_MAX_ID_SQL = "SELECT max(id) AS id FROM gateway.pay_order_ok WHERE id > ? LIMIT ?";
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<PayOrderReportData> queryGatewayOrders(long minSeqId, long maxId) {
        final ArrayList<PayOrderReportData> payOrderReportDataList = new ArrayList<PayOrderReportData>();
        this.jdbcTemplate.query(QUERY_SQL, (Object[])new Long[]{minSeqId, maxId}, new int[]{-5, -5}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                PayOrderReportData payOrderReportData = new PayOrderReportData();
                long seqId = rs.getLong("id");
                payOrderReportData.setId(seqId + "");
                payOrderReportData.setVersion(rs.getString("version"));
                payOrderReportData.setXunleiPayId(rs.getString("xunlei_pay_id"));
                payOrderReportData.setPageUrl(rs.getString("page_url"));
                payOrderReportData.setNotifyUrl(rs.getString("notify_url"));
                payOrderReportData.setBizNo(rs.getString("biz_no"));
                payOrderReportData.setBizName(rs.getString("BizName"));
                payOrderReportData.setBizOrderId(rs.getString("biz_order_id"));
                payOrderReportData.setPayType(rs.getString("pay_type"));
                payOrderReportData.setPayTypeDisplay(rs.getString("itemName"));
                payOrderReportData.setOrderAmt(rs.getInt("order_amt"));
                payOrderReportData.setOrderGroup(rs.getString("order_group"));
                payOrderReportData.setXunleiId(rs.getString("xunlei_id"));
                payOrderReportData.setUserShow(rs.getString("user_show"));
                payOrderReportData.setProductName(rs.getString("product_name"));
                payOrderReportData.setProductDesc(rs.getString("product_desc"));
                payOrderReportData.setStatus("S");
                payOrderReportData.setFactAmt(Integer.valueOf(rs.getInt("fact_amt")));
                payOrderReportData.setFareAmt(Integer.valueOf(rs.getInt("fare_amt")));
                payOrderReportData.setBizExt(rs.getString("biz_ext"));
                payOrderReportData.setOrderIp(rs.getString("order_ip"));
                payOrderReportData.setOrderType(rs.getString("order_type"));
                payOrderReportData.setPeerId(rs.getString("peer_id"));
                payOrderReportData.setBalanceDate(rs.getString("balance_date"));
                payOrderReportData.setSendNoticeStatus(rs.getString("send_notice_status"));
                payOrderReportData.setReqTime(rs.getString("req_time"));
                payOrderReportData.setChannelOrderId(rs.getString("channel_order_id"));
                payOrderReportData.setProductId(rs.getLong("product_id"));
                payOrderReportData.setPhone(rs.getString("phone"));
                payOrderReportData.setExtraJson(rs.getString("extra_json"));
                payOrderReportDataList.add(payOrderReportData);
            }
        });
        return payOrderReportDataList;
    }

    public Long queryMaxId(long minSeqId, long maxSize) {
        Long aLong = (Long)this.jdbcTemplate.queryForObject(QUERY_MAX_ID_SQL, (Object[])new Long[]{minSeqId, maxSize}, new int[]{-5, -5}, Long.class);
        return aLong;
    }
}

