/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.report.dao;

import com.xunlei.channel.report.dao.GatewayPayOrderDao;
import com.xunlei.channel.report.pojo.pay.PayOrderReportData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class PayProxyPayOrderDao {
    private static final Logger logger = LoggerFactory.getLogger(GatewayPayOrderDao.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final String QUERY_SQL = "SELECT p.SeqId, p.Version, p.XunleiPayId, p.BgUrl, p.FgUrl, p.BizNo,b.BizName, p.BizOrderId, p.PayType,c.ItemName, p.OrderAmt, p.ExtPayCompany, p.ExtPayOrderId, p.OrderTime, p.BankNo, p.UserShow, p.ProductName, p.ProductDesc, p.SuccessTime, p.XunleiId, p.BalanceDate, p.FareAmt, p.DivideAmt, p.OrderGroup, p.Ext1, p.Ext2, p.OrderIp, p.Type, p.PeerId, p.SendNoticeStatus FROM xlpayproxy.bizorderok p, xlpayproxy.libclassd c, xlpayproxy.copbizinfo b  WHERE p.SeqId>? AND p.SeqId<=? AND p.PayType=c.ItemNo AND c.ClassNo='PayTypeShow' AND p.BizNo=b.BizNo  ORDER by p.SeqId ";
    private static final String QUERY_MAX_ID_SQL = "SELECT max(SeqId) FROM xlpayproxy.bizorderok WHERE SeqId>? ORDER by SeqId limit ? ";

    private static int parsePayProxyAmount(String amt) {
        if (!StringUtils.hasText((String)amt)) {
            return 0;
        }
        try {
            double i = Double.parseDouble(amt);
            int amtInt = (int)(i * 100.0);
            return amtInt;
        }
        catch (Exception e) {
            logger.error("Parsing string amt error:  " + amt + " message: " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public List<PayOrderReportData> queryPayProxyOrderList(long minSeqId, long maxId) {
        final ArrayList<PayOrderReportData> payOrderReportDataList = new ArrayList<PayOrderReportData>();
        this.jdbcTemplate.query(QUERY_SQL, (Object[])new Long[]{minSeqId, maxId}, new int[]{-5, -5}, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                PayOrderReportData payOrderReportData = new PayOrderReportData();
                long seqId = rs.getLong("SeqId");
                payOrderReportData.setId("xlpayproxy.bizorderok-" + seqId);
                payOrderReportData.setVersion(rs.getString("Version"));
                payOrderReportData.setXunleiPayId(rs.getString("XunleiPayId"));
                payOrderReportData.setPageUrl(rs.getString("FgUrl"));
                payOrderReportData.setNotifyUrl(rs.getString("BgUrl"));
                payOrderReportData.setBizNo(rs.getString("BizNo"));
                payOrderReportData.setBizName(rs.getString("BizName"));
                payOrderReportData.setBizOrderId(rs.getString("BizOrderId"));
                payOrderReportData.setPayType(rs.getString("PayType"));
                payOrderReportData.setPayTypeDisplay(rs.getString("ItemName"));
                payOrderReportData.setOrderAmt((int)(rs.getDouble("OrderAmt") * 100.0));
                payOrderReportData.setOrderGroup(rs.getString("OrderGroup"));
                payOrderReportData.setXunleiId(rs.getString("XunleiId"));
                payOrderReportData.setUserShow(rs.getString("UserShow"));
                payOrderReportData.setProductName(rs.getString("ProductName"));
                payOrderReportData.setProductDesc(rs.getString("ProductDesc"));
                payOrderReportData.setBankNo(rs.getString("BankNo"));
                payOrderReportData.setStatus("S");
                payOrderReportData.setFactAmt(Integer.valueOf((int)(rs.getDouble("DivideAmt") * 100.0)));
                payOrderReportData.setFareAmt(Integer.valueOf((int)(rs.getDouble("FareAmt") * 100.0)));
                payOrderReportData.setBizExt(rs.getString("Ext1") + "-" + rs.getString("Ext2"));
                payOrderReportData.setOrderIp(rs.getString("OrderIp"));
                payOrderReportData.setOrderType(rs.getString("Type"));
                payOrderReportData.setPeerId(rs.getString("PeerId"));
                payOrderReportData.setBalanceDate(rs.getString("BalanceDate"));
                payOrderReportData.setSendNoticeStatus(rs.getString("SendNoticeStatus"));
                payOrderReportData.setReqTime(rs.getString("OrderTime"));
                payOrderReportDataList.add(payOrderReportData);
            }
        });
        return payOrderReportDataList;
    }

    public Long queryMaxId(long minSeqId, long maxSize) {
        Long aLong = (Long)this.jdbcTemplate.queryForObject(QUERY_MAX_ID_SQL, (Object[])new Long[]{minSeqId, maxSize}, new int[]{-5, -5}, Long.class);
        return aLong;
    }
}

