/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.aop;

import com.google.common.base.Optional;
import com.xunlei.channel.api.entity.ReturnResult;
import com.xunlei.channel.api.util.BindingResultUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;

@Aspect
@Component
@Order(value=0)
public class BindingResultAspect {
    private static final Logger logger = LoggerFactory.getLogger(BindingResultAspect.class);

    @Pointcut(value="execution(* com.xunlei.channel.api.controller..*.*(..))")
    public void controllerMethods() {
    }

    @Pointcut(value="execution(public com.xunlei.channel.api.entity.ReturnResult+ (com.xunlei.channel.api..*).*(.., @javax.validation.Valid (*),org.springframework.validation.BindingResult, ..))")
    public void validMethods() {
    }

    @Around(value="validMethods()")
    public Object aop(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            Optional<ReturnResult> returnResultOptional = this.buildResultIfHasErrors(arg);
            if (!returnResultOptional.isPresent()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Intercept binding result, and returns: {}", returnResultOptional.get());
            }
            return returnResultOptional.get();
        }
        return pjp.proceed();
    }

    private Optional<ReturnResult> buildResultIfHasErrors(Object arg) {
        if (!(arg instanceof BindingResult)) {
            return Optional.absent();
        }
        BindingResult bindingResult = (BindingResult)arg;
        if (!bindingResult.hasErrors()) {
            return Optional.absent();
        }
        ReturnResult returnResult = BindingResultUtils.buildResult(bindingResult);
        if (returnResult == null) {
            return Optional.absent();
        }
        return Optional.of((Object)returnResult);
    }
}

