/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.base.sign.service;

import com.xunlei.channel.api.base.sign.dao.ConfigInfoSign;
import com.xunlei.channel.api.base.sign.dao.ConfigInfoSignDao;
import com.xunlei.channel.api.entity.AppIdRequestBase;
import com.xunlei.channel.api.util.reflect.ReflectionUtils;
import com.xunlei.channel.common.utils.sign.SignUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SignUtilsService {
    private static final Logger logger = LoggerFactory.getLogger(SignUtilsService.class);
    @Autowired
    private ConfigInfoSignDao configInfoDao;
    public static String BASE_SIGN = "base_sign";
    public static String SIGN_APPID = "sign_appid";
    public static String SIGN_APPSECRET = "sign_appsecret";

    public boolean checkSign(AppIdRequestBase appIdRequestBase) {
        if (StringUtils.isEmpty((Object)appIdRequestBase.getTimestamp()) || StringUtils.isEmpty((Object)appIdRequestBase.getAppId()) || StringUtils.isEmpty((Object)appIdRequestBase.getSign())) {
            return false;
        }
        Map<String, String> signParams = this.getSignParams(appIdRequestBase);
        List<ConfigInfoSign> configInfoList = this.configInfoDao.findValue(BASE_SIGN, null);
        String key = "";
        String appIds = "";
        String appId = "";
        for (ConfigInfoSign configInfo : configInfoList) {
            if (SIGN_APPID.equals(configInfo.getPropertyKey())) {
                appId = configInfo.getPropertyValue();
            }
            if (!SIGN_APPSECRET.equals(configInfo.getPropertyKey())) continue;
            key = configInfo.getPropertyValue();
        }
        if (appIds.equals(appId)) {
            logger.error("appId is error");
            return false;
        }
        boolean match = SignUtils.checkSign((String)appIdRequestBase.getSign(), signParams, this.ignoreFieldSet(), (String)key, (String)"UTF-8", (boolean)true);
        return match;
    }

    private Map<String, String> getSignParams(AppIdRequestBase appIdRequestBase) {
        Map map = ReflectionUtils.convertObjectFieldsToMap((Object)appIdRequestBase);
        Map mapSuper = ReflectionUtils.convertObjectFieldsToMap((Object)appIdRequestBase, AppIdRequestBase.class);
        map.putAll(mapSuper);
        return map;
    }

    private Set<String> ignoreFieldSet() {
        HashSet<String> ignoreFieldSet = new HashSet<String>();
        ignoreFieldSet.add("sign");
        return ignoreFieldSet;
    }
}

