/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.base.sign.service;

import com.google.common.collect.Sets;
import com.xunlei.channel.api.base.sign.dao.BizInfoDao;
import com.xunlei.channel.api.entity.RequestBase;
import com.xunlei.channel.common.utils.reflect.ReflectionUtils;
import com.xunlei.channel.common.utils.sign.SignUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SignService {
    private static final Logger logger = LoggerFactory.getLogger(SignService.class);
    @Autowired
    private BizInfoDao bizInfoDao;

    public Boolean checkSign(RequestBase requestBase) {
        String bizNo = requestBase.getBizNo();
        String signMessage = requestBase.getSignMessage();
        Map map = ReflectionUtils.convertObjectFieldsToMap((Object)requestBase);
        String key = this.bizInfoDao.findBizKey(bizNo);
        if (StringUtils.isEmpty((Object)key)) {
            logger.warn("Could'nt found key of bizNo: {}", (Object)bizNo);
            return false;
        }
        String signed = SignUtils.sign((Map)map, (Set)Sets.newHashSet((Object[])new String[]{"signMessage"}), (String)key, (String)"UTF-8", (boolean)true);
        boolean isMatch = SignUtils.checkSign((String)signMessage, (Map)map, (Set)Sets.newHashSet((Object[])new String[]{"signMessage"}), (String)key, (String)"UTF-8", (boolean)true);
        if (isMatch) {
            if (logger.isDebugEnabled()) {
                logger.debug("Success check sign! signed: {}, signMessage: {}", (Object)signed, (Object)signMessage);
            }
        } else {
            logger.warn("Mismatch sign message! signed: {}, signMessage: {}", (Object)signed, (Object)signMessage);
        }
        return isMatch;
    }
}

