/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.base.sign.aop;

import com.google.common.base.Optional;
import com.xunlei.channel.api.base.sign.service.SignService;
import com.xunlei.channel.api.entity.RequestBase;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order(value=1)
public class CheckSignAspect {
    private static final Logger logger = LoggerFactory.getLogger(CheckSignAspect.class);
    @Autowired(required=false)
    private SignService signService;

    @Pointcut(value="execution(public com.xunlei.channel.api.entity.ReturnResult+ (com.xunlei.channel.api..*).*(.., @com.xunlei.channel.api.base.sign.annotation.CheckSign (com.xunlei.channel.api.entity.RequestBase+), ..))")
    public void validMethods() {
    }

    @Around(value="validMethods()")
    public Object aop(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            try {
                Optional<ReturnResult> returnResultOptional = this.checkSign(arg);
                if (!returnResultOptional.isPresent() || ((ReturnResult)returnResultOptional.get()).isSuccess()) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Intercept check sign result, and returns: {}", returnResultOptional.get());
                }
                return returnResultOptional.get();
            }
            catch (Exception e) {
                logger.error("Error when check sign of arg: " + arg + ". Message: " + e.getMessage(), (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Passed check sign. args: {}", (Object)Arrays.toString(args));
        }
        return pjp.proceed();
    }

    private Optional<ReturnResult> checkSign(Object arg) {
        if (!(arg instanceof RequestBase)) {
            return Optional.absent();
        }
        RequestBase requestBase = (RequestBase)arg;
        Boolean signOk = this.signService.checkSign(requestBase);
        if (!signOk.booleanValue()) {
            logger.warn("Failed match sign! request: {}", (Object)requestBase);
            return Optional.of((Object)ReturnResult.CHECK_SIGN_ERROR);
        }
        return Optional.absent();
    }
}

