/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.base.sign.aop;

import com.google.common.base.Optional;
import com.xunlei.channel.api.base.sign.service.SignUtilsService;
import com.xunlei.channel.api.entity.AppIdRequestBase;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Order
public class CheckAppIdSignAspect {
    private static final Logger logger = LoggerFactory.getLogger(CheckAppIdSignAspect.class);
    @Autowired(required=true)
    private SignUtilsService signUtilsService;

    @Pointcut(value="execution(public com.xunlei.channel.api.entity.JsonResult+ (com.xunlei.channel.api..*).*(.., @com.xunlei.channel.api.base.sign.annotation.CheckAppIdSign (com.xunlei.channel.api.entity.AppIdRequestBase+), ..))")
    public void validMethods() {
    }

    @Around(value="validMethods()")
    public Object aop(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            try {
                Optional<JsonResult> returnResultOptional = this.checkSign(arg);
                if (!returnResultOptional.isPresent() || ((JsonResult)returnResultOptional.get()).getIsSuccess() == 0) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Intercept check sign result, and returns: {}", returnResultOptional.get());
                }
                return returnResultOptional.get();
            }
            catch (Exception e) {
                logger.error("Error when check sign of arg: " + arg + ". Message: " + e.getMessage(), (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Passed check sign. args: {}", (Object)Arrays.toString(args));
        }
        return pjp.proceed();
    }

    private Optional<JsonResult> checkSign(Object arg) {
        if (!(arg instanceof AppIdRequestBase)) {
            return Optional.absent();
        }
        AppIdRequestBase appIdRequestBase = (AppIdRequestBase)arg;
        boolean signOk = this.signUtilsService.checkSign(appIdRequestBase);
        if (!signOk) {
            logger.warn("Failed match sign! request: {}", (Object)appIdRequestBase);
            JsonResult jsonResult = new JsonResult(ReturnResult.CHECK_SIGN_ERROR.getCode().intValue(), ReturnResult.CHECK_SIGN_ERROR.getMessage(), ReturnResult.CHECK_SIGN_ERROR.getDescribe(), null);
            return Optional.of((Object)jsonResult);
        }
        return Optional.absent();
    }
}

