/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.service;

import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.dao.ConfigInfoDao;
import com.xunlei.channel.api.basechannel.entity.ConfigInfo;
import com.xunlei.channel.api.basechannel.entity.QueryRequest;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.util.reflect.ReflectionUtils;
import com.xunlei.channel.api.util.sign.SignUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SignUtilsServiceImpl
implements SignUtilsService {
    private static final Logger logger = LoggerFactory.getLogger(SignUtilsServiceImpl.class);
    @Autowired
    private ConfigInfoDao configInfoDao;

    @Override
    public boolean checkSign(String timestamp, String appId, String sign) {
        if (StringUtils.isEmpty((Object)timestamp) || StringUtils.isEmpty((Object)appId) || StringUtils.isEmpty((Object)sign)) {
            return false;
        }
        Map<String, String> signParams = this.getSignParams(timestamp, appId, sign);
        List<ConfigInfo> configInfoList = this.configInfoDao.findValue(Constants.BASE_SIGN, null);
        String key = "";
        String appIds = "";
        for (ConfigInfo configInfo : configInfoList) {
            if (Constants.SIGN_APPID.equals(configInfo.getPropertyKey())) {
                appId = configInfo.getPropertyValue();
            }
            if (!Constants.SIGN_APPSECRET.equals(configInfo.getPropertyKey())) continue;
            key = configInfo.getPropertyValue();
        }
        if (appIds.equals(appId)) {
            logger.error("appId is error");
            return false;
        }
        boolean match = SignUtils.checkSign((String)sign, signParams, this.ignoreFieldSet(), (String)key, (String)"UTF-8", (boolean)true);
        return match;
    }

    private Map<String, String> getSignParams(String timestamp, String appId, String sign) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setTimestamp(timestamp);
        queryRequest.setAppId(appId);
        queryRequest.setSign(sign);
        Map map = ReflectionUtils.convertObjectFieldsToMap((Object)queryRequest);
        Map mapSuper = ReflectionUtils.convertObjectFieldsToMap((Object)queryRequest, QueryRequest.class);
        map.putAll(mapSuper);
        return map;
    }

    private Set<String> ignoreFieldSet() {
        HashSet<String> ignoreFieldSet = new HashSet<String>();
        ignoreFieldSet.add("sign");
        return ignoreFieldSet;
    }
}

