/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.xunlei.channel.api.basechannel.dao.OnethingcoinpayBizDao;
import com.xunlei.channel.api.basechannel.dao.OnethingcoinpayOrderDao;
import com.xunlei.channel.api.basechannel.dao.OnethingcoinpayPocketDao;
import com.xunlei.channel.api.basechannel.dao.OnethingcoinpaySelectBizDao;
import com.xunlei.channel.api.basechannel.dao.OnethingcoinpayTransferDao;
import com.xunlei.channel.api.basechannel.dao.OnethingcoinpayTransferOrderDao;
import com.xunlei.channel.api.basechannel.entity.OneThingCoinPayResponse;
import com.xunlei.channel.api.basechannel.entity.OneThingCoinPayTransferOrder;
import com.xunlei.channel.api.basechannel.entity.OneThingCoinPayTransferReponse;
import com.xunlei.channel.api.basechannel.entity.OneThingCoinTransferRequest;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpayBiz;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpayOrderPocketRequest;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpayOrderQueryRequest;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpaySelectBizItem;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpayTransferOrderQueryRequest;
import com.xunlei.channel.api.basechannel.jdbc.Pagination;
import com.xunlei.channel.api.basechannel.service.OnethingcoinpayService;
import com.xunlei.channel.api.util.DateUtils;
import com.xunlei.channel.common.utils.JacksonHelper;
import com.xunlei.channel.common.utils.arith.Arith;
import com.xunlei.channel.common.utils.http.HttpUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OnethingcoinpayServiceImpl
implements OnethingcoinpayService {
    static final Logger logger = LoggerFactory.getLogger(OnethingcoinpayServiceImpl.class);
    @Autowired
    private OnethingcoinpayOrderDao onethingcoinpayOrderDao;
    @Autowired
    private OnethingcoinpayTransferDao onethingcoinpayTransferDao;
    @Autowired
    OnethingcoinpayBizDao onethingcoinpayBizDao;
    @Autowired
    private OnethingcoinpaySelectBizDao onethingcoinpaySelectBizDao;
    @Autowired
    private OnethingcoinpayPocketDao onethingcoinpayPocketDao;
    @Autowired
    private OnethingcoinpayTransferOrderDao onethingcoinpayTransferOrderDao;
    private static final String queryOrderRecordsUrl = "https://walletapi.onethingpcs.com:443/getTransactionRecords";
    public static final String GET_BALANCE = "https://walletapi.onethingpcs.com:443/getBalance";

    @Override
    public Pagination queryOnethingcoinpayOrder(OnethingcoinpayOrderQueryRequest onethingcoinpayOrderQueryRequest) {
        Pagination oneThingCoinPayOrder = this.onethingcoinpayOrderDao.queryOnethingcoinpayOrder(onethingcoinpayOrderQueryRequest);
        return oneThingCoinPayOrder;
    }

    @Override
    public Pagination queryOnethingcoinpayTransferOrder(OnethingcoinpayTransferOrderQueryRequest onethingcoinpayOrderQueryRequest) {
        Pagination oneThingCoinPayTransferOrder = this.onethingcoinpayTransferDao.queryOnethingcoinpayTransferOrder(onethingcoinpayOrderQueryRequest);
        return oneThingCoinPayTransferOrder;
    }

    @Override
    public List<OnethingcoinpayBiz> query() {
        try {
            List<OnethingcoinpayBiz> list = this.onethingcoinpayBizDao.query();
            HashMap<String, String> balanceMap = new HashMap<String, String>();
            for (OnethingcoinpayBiz onethingcoinpayBiz : list) {
                String address = onethingcoinpayBiz.getAccountAddress();
                String balance = "";
                if (balanceMap.containsKey(address)) {
                    balance = (String)balanceMap.get(address);
                } else {
                    String reponse = OnethingcoinpayServiceImpl.getBalance(onethingcoinpayBiz.getAccountAddress());
                    if (reponse.indexOf("error") > 0) {
                        onethingcoinpayBiz.setBalance(balance);
                    } else {
                        OneThingCoinPayResponse oneThingCoinPayResponse = (OneThingCoinPayResponse)JacksonHelper.convertJsonByClass((String)reponse, OneThingCoinPayResponse.class);
                        String restult = oneThingCoinPayResponse.getResult();
                        BigDecimal bigDecimal = new BigDecimal(new BigInteger(restult.replaceFirst("0x", ""), 16).toString());
                        BigDecimal divResult = Arith.divide((BigDecimal)bigDecimal, (BigDecimal)new BigDecimal(new Double(Math.pow(10.0, 18.0))), (int)8);
                        balance = divResult.toPlainString();
                    }
                    balanceMap.put(address, balance);
                }
                onethingcoinpayBiz.setBalance(balance);
            }
            return list;
        }
        catch (Exception e) {
            logger.error("query OnethingcoinpayBiz error:{} ", (Object)e.getMessage());
            return null;
        }
    }

    public static String getBalance(String address) throws Exception {
        OneThingCoinTransferRequest<String[]> oneThingCoinTransferRequest = new OneThingCoinTransferRequest<String[]>();
        oneThingCoinTransferRequest.setRequestParams(new String[]{address, "delay"});
        String json = JacksonHelper.getJsonString(oneThingCoinTransferRequest);
        System.out.println("\u94fe\u514b\u4f59\u989d\u67e5\u8be2\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        String response = HttpUtils.post((String)GET_BALANCE, (String)json, (String)"UTF-8", (int)6000);
        System.out.println("\u94fe\u514b\u4f59\u989d\u67e5\u8be2\u54cd\u5e94\u4fe1\u606f\uff1a" + response);
        return response;
    }

    @Override
    public List<OnethingcoinpaySelectBizItem> querySelectItem() {
        return this.onethingcoinpaySelectBizDao.querySelectItem();
    }

    @Override
    public Pagination queryOnethingcoinpayOrderPocket(OnethingcoinpayOrderPocketRequest onethingcoinpayOrderPocketRequest) {
        if (onethingcoinpayOrderPocketRequest.getOffset() <= onethingcoinpayOrderPocketRequest.getLimit()) {
            this.insert(onethingcoinpayOrderPocketRequest);
        }
        Pagination pagination = this.onethingcoinpayPocketDao.queryOnethingcoinpayOrderPocket(onethingcoinpayOrderPocketRequest);
        return pagination;
    }

    @Override
    public void insert(OnethingcoinpayOrderPocketRequest onethingcoinpayOrderPocketRequest) {
        String[] params = new String[]{onethingcoinpayOrderPocketRequest.getAccount(), "631123200", "0", "1", "40"};
        Object jsonParams = JSONArray.toJSON((Object)params);
        int totalPage = 0;
        int i = 1;
        ArrayList<OneThingCoinPayTransferOrder> listAll = new ArrayList<OneThingCoinPayTransferOrder>();
        int currentNum = 0;
        logger.info("request OnethingcoinpayTransfer records parms :{}", (Object)jsonParams.toString());
        try {
            int totalRecords = this.onethingcoinpayPocketDao.getTotalRecords(onethingcoinpayOrderPocketRequest);
            String reponse = HttpUtils.post((String)queryOrderRecordsUrl, (String)jsonParams.toString(), (String)"UTF-8", (int)3000);
            logger.info("request OnethingcoinpayTransfer records reponse :{}", (Object)reponse);
            OneThingCoinPayTransferReponse oneThingCoinPayResponse = (OneThingCoinPayTransferReponse)JSON.parseObject((String)reponse, OneThingCoinPayTransferReponse.class);
            int totalNum = oneThingCoinPayResponse.getTotalnum();
            if (totalNum == totalRecords) {
                return;
            }
            int increaNum = totalNum - totalRecords;
            OneThingCoinPayTransferOrder[] result = null;
            totalPage = totalNum / 40;
            if (totalNum % 40 != 0) {
                ++totalPage;
            }
            while (i <= totalPage && currentNum != increaNum) {
                if (i == 1) {
                    result = oneThingCoinPayResponse.getResult();
                } else {
                    params[3] = String.valueOf(i);
                    jsonParams = JSONArray.toJSON((Object)params);
                    reponse = HttpUtils.post((String)queryOrderRecordsUrl, (String)jsonParams.toString(), (String)"UTF-8", (int)6000);
                    logger.info("request OnethingcoinpayTransfer records reponse :{}", (Object)reponse);
                    if (reponse.indexOf("error") > 0) continue;
                    oneThingCoinPayResponse = (OneThingCoinPayTransferReponse)JSON.parseObject((String)reponse, OneThingCoinPayTransferReponse.class);
                    result = oneThingCoinPayResponse.getResult();
                }
                for (int j = 0; j < result.length; ++j) {
                    ++currentNum;
                    result[j].setFromAccount(onethingcoinpayOrderPocketRequest.getAccount());
                    BigDecimal amoutDivden = new BigDecimal(new BigInteger(result[j].getAmount().replaceFirst("0x", ""), 16).toString());
                    String amout = amoutDivden.divide(new BigDecimal(10).pow(18)).toPlainString();
                    result[j].setAmount(amout);
                    BigDecimal costDivden = new BigDecimal(new BigInteger(result[j].getCost().replace("0x", ""), 16).toString());
                    String cost = costDivden.divide(new BigDecimal(10).pow(18)).toPlainString();
                    result[j].setCost(cost);
                    String successTime = result[j].getTimestamp();
                    result[j].setTimestamp(DateUtils.TimeStampToDate((String)"yyyy-MM-dd HH:mm:ss", (String)successTime));
                    listAll.add(result[j]);
                    if (currentNum == increaNum) break;
                }
                ++i;
            }
            this.onethingcoinpayTransferOrderDao.insert(listAll);
        }
        catch (Exception e) {
            logger.info("insert onethingcoinpayTransferOrder error:{}", (Object)e.getMessage());
        }
    }
}

