/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.service;

import com.xunlei.channel.api.basechannel.dao.ChannelBusinessDao;
import com.xunlei.channel.api.basechannel.dao.ChannelDao;
import com.xunlei.channel.api.basechannel.dao.ChannelLabelDao;
import com.xunlei.channel.api.basechannel.entity.Channel;
import com.xunlei.channel.api.basechannel.entity.ChannelLabel;
import com.xunlei.channel.api.basechannel.entity.ChannelLabelQueryRequery;
import com.xunlei.channel.api.basechannel.entity.ChannelQueryRequest;
import com.xunlei.channel.api.basechannel.service.ChannelService;
import com.xunlei.channel.api.util.DateUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelServiceImpl
implements ChannelService {
    @Autowired
    private ChannelDao channelDao;
    @Autowired
    private ChannelLabelDao channelLabelDao;
    @Autowired
    private ChannelBusinessDao channelBusinessDao;

    @Override
    public List<Channel> query(ChannelQueryRequest object) {
        return this.channelDao.query(object);
    }

    @Override
    public int insert(ChannelQueryRequest object) {
        return this.channelDao.insert(object);
    }

    @Override
    public int delete(ChannelQueryRequest object) {
        return this.channelDao.delete(object);
    }

    @Override
    public int update(ChannelQueryRequest object) {
        ChannelLabel channelLabelDel = new ChannelLabel();
        channelLabelDel.setChannelNo(object.getChannelNo());
        this.channelLabelDao.delete(channelLabelDel);
        for (String labelNo : object.getLabelNo().split(",")) {
            ChannelLabelQueryRequery channelLabel = new ChannelLabelQueryRequery();
            channelLabel.setIsUse("Y");
            channelLabel.setLabelNo(labelNo);
            channelLabel.setChannelNo(object.getChannelNo());
            channelLabel.setCreateTime(DateUtils.getNowDateTime());
            channelLabel.setUpdateTime(DateUtils.getNowDateTime());
            this.channelLabelDao.insert(channelLabel);
        }
        return this.channelDao.update(object);
    }

    @Override
    public int isInUse(ChannelQueryRequest object) {
        return this.channelDao.isInUse(object);
    }

    @Override
    public List<Channel> queryChannel(ChannelQueryRequest object) {
        return this.channelDao.queryChannel(object);
    }

    @Override
    public List<Channel> queryChannelByName(ChannelQueryRequest object) {
        return this.channelDao.queryChannelByName(object);
    }

    @Override
    public List<Channel> queryChannelByNo(ChannelQueryRequest object) {
        return this.channelDao.queryChannelByNo(object);
    }
}

