/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.jdbc;

import com.xunlei.channel.api.basechannel.jdbc.PageParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class Pagination
extends JdbcDaoSupport {
    private static final Logger logger = LoggerFactory.getLogger(Pagination.class);
    private int pageSize;
    private int totalRows;
    private int totalPages;
    private int currentPage;
    private int startIndex;
    private int lastIndex;
    private List result;

    public Pagination() {
    }

    public Pagination(String sql, Object[] params, PageParam pageParam, RowMapper rowMapper, JdbcTemplate jTemplate) {
        if (jTemplate == null) {
            throw new IllegalArgumentException("Pagination.jTemplate is null,please initial it first. ");
        }
        if (sql == null || sql.equals("")) {
            throw new IllegalArgumentException("Pagination.sql is empty,please initial it first. ");
        }
        this.setPageSize(pageParam.getLimit());
        StringBuffer totalSQL = new StringBuffer(" SELECT count(*) FROM ( ");
        totalSQL.append(sql);
        totalSQL.append(" ) totalTable ");
        this.setJdbcTemplate(jTemplate);
        this.setTotalRows((Integer)this.getJdbcTemplate().queryForObject(totalSQL.toString(), params, Integer.class));
        this.setTotalPages();
        this.setStartIndex(pageParam.getOffset());
        this.setLastIndex();
        String sqlStr = this.getMySQLPageSQL(new StringBuilder(sql), pageParam);
        this.setResult(this.getJdbcTemplate().query(sqlStr, rowMapper, params));
    }

    public String getMySQLPageSQL(StringBuilder queryString, PageParam pageParam) {
        String resultSql = null;
        if (pageParam != null && pageParam.getSort() != null && pageParam.getDir() != null) {
            queryString.append(" order by ").append(pageParam.getSort()).append(" ").append(pageParam.getDir());
        }
        resultSql = 0 != this.pageSize ? queryString.append(" limit ").append(this.startIndex).append(",").append(this.pageSize).toString() : queryString.toString();
        logger.info("page sql:{}", (Object)resultSql);
        return resultSql;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage < 0 ? 1 : currentPage;
    }

    public List getResult() {
        return this.result;
    }

    public void setResult(List result) {
        this.result = result;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages() {
        this.totalPages = this.pageSize == 0 ? (this.totalRows > 0 ? 1 : 0) : (this.totalRows % this.pageSize == 0 ? this.totalRows / this.pageSize : this.totalRows / this.pageSize + 1);
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setLastIndex(int lastIndex) {
        this.lastIndex = lastIndex;
    }

    public void setLastIndex() {
        logger.debug("totalRows={}", (Object)this.totalRows);
        logger.debug("pageSize={}", (Object)this.pageSize);
        if (this.pageSize != 0) {
            if (this.totalRows < this.pageSize) {
                this.lastIndex = this.totalRows;
            } else if (this.totalRows % this.pageSize == 0 || this.totalRows % this.pageSize != 0 && this.currentPage < this.totalPages) {
                this.lastIndex = this.currentPage * this.pageSize;
            } else if (this.totalRows % this.pageSize != 0 && this.currentPage == this.totalPages) {
                this.lastIndex = this.totalRows;
            }
        }
    }
}

