/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.entity.ServiceProvider;
import com.xunlei.channel.api.basechannel.entity.ServiceProviderQueryRequest;
import com.xunlei.channel.api.basechannel.mapper.ServiceProviderMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class ServiceProviderDao
extends GatewayBaseDao<ServiceProvider> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceProviderDao.class);

    public List<ServiceProvider> query(ServiceProviderQueryRequest object) {
        StringBuffer sql = new StringBuffer("SELECT * FROM service_provider where 1=1 ");
        if (!"".equals(object.getProviderName()) && null != object.getProviderName()) {
            sql.append("and provider_name like  '%" + object.getProviderName() + "%'");
        }
        sql.append(" order by provider_no asc");
        logger.info(sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new ServiceProviderMapper());
        return list;
    }

    public List<ServiceProvider> findServiceProvider(ServiceProviderQueryRequest object) {
        StringBuffer sql = new StringBuffer("SELECT * FROM service_provider where 1=1 ");
        if (!StringUtils.isEmpty((Object)object.getProviderName())) {
            sql.append("and provider_name = '" + object.getProviderName() + "'");
        }
        if (!StringUtils.isEmpty((Object)object.getProviderFullName())) {
            sql.append("and provider_full_name = '" + object.getProviderFullName() + "'");
        }
        if (!StringUtils.isEmpty((Object)object.getProviderNo())) {
            sql.append("and provider_no = '" + object.getProviderNo() + "'");
        }
        logger.info(sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new ServiceProviderMapper());
        return list;
    }

    public int insert(ServiceProviderQueryRequest object) {
        StringBuffer sql = new StringBuffer(" INSERT INTO  service_provider  (provider_no,provider_name ,                            remark ,                            deleted,                            create_time,                              update_time,provider_full_name) values(?,?,?,?,NOW(),NOW(),?) ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getProviderNo(), object.getProviderName(), object.getRemark(), Constants.IS_NOT_DELETED, object.getProviderFullName()});
        return temp;
    }

    public int update(ServiceProviderQueryRequest object) {
        StringBuffer sql = new StringBuffer("update service_provider set provider_name = ?,remark = ?, update_time = now(), provider_full_name=? where provider_no = ? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getProviderName(), object.getRemark(), object.getProviderFullName(), object.getProviderNo()});
        return temp;
    }

    public int delete(ServiceProviderQueryRequest object) {
        StringBuffer sql = new StringBuffer("DELETE FROM  service_provider WHERE provider_no = ?");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getProviderNo()});
        return temp;
    }

    public int getMaxProviderNo() {
        String sql = "SELECT IFNULL((MAX( CAST(provider_no AS UNSIGNED INTEGER)) ),0) AS c FROM service_provider  ";
        return (Integer)this.jdbcTemplate.queryForObject(sql.toString(), null, Integer.class);
    }

    public static void main(String[] args) {
        String tempNo = "10000010";
        String providerNo = tempNo.substring(tempNo.length() - 5, tempNo.length());
        System.out.print(providerNo);
    }
}

