/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.RefundOrder;
import com.xunlei.channel.api.basechannel.entity.RefundOrderQueryRequest;
import com.xunlei.channel.api.basechannel.jdbc.PageParam;
import com.xunlei.channel.api.basechannel.jdbc.Pagination;
import com.xunlei.channel.api.basechannel.mapper.RefundOrderMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class RefundOrderDao
extends GatewayBaseDao<RefundOrder> {
    private static final Logger logger = LoggerFactory.getLogger(RefundOrderDao.class);

    public Pagination query(RefundOrderQueryRequest object, PageParam pageParam) {
        ArrayList<String> payRefundOrderParams = new ArrayList<String>();
        StringBuffer paramStr = new StringBuffer();
        if (!StringUtils.isEmpty((Object)object.getXunleiPayid())) {
            paramStr.append(" and a.xunlei_pay_id = ? ");
            payRefundOrderParams.add(object.getXunleiPayid());
        }
        if (!StringUtils.isEmpty((Object)object.getBizorderId())) {
            paramStr.append(" and a.biz_order_id = ? ");
            payRefundOrderParams.add(object.getBizorderId());
        }
        if (!StringUtils.isEmpty((Object)object.getChannelOrderId())) {
            paramStr.append(" and a.channel_order_id = ? ");
            payRefundOrderParams.add(object.getChannelOrderId());
        }
        if (!StringUtils.isEmpty((Object)object.getBizName())) {
            paramStr.append(" and c.biz_name = ? ");
            payRefundOrderParams.add(object.getBizName());
        }
        if (!StringUtils.isEmpty((Object)object.getRefundStatus())) {
            paramStr.append(" and a.refund_status = ? ");
            payRefundOrderParams.add(object.getRefundStatus());
        }
        if (!StringUtils.isEmpty((Object)object.getBeginTime()) && !StringUtils.isEmpty((Object)object.getEndTime())) {
            paramStr.append(" and a.create_time between ? and ?");
            payRefundOrderParams.add(object.getBeginTime() + " 00:00:00");
            payRefundOrderParams.add(object.getEndTime() + " 23:59:59");
        }
        StringBuffer sql = new StringBuffer("SELECT   a.*,  b.channel_name ,c.biz_name  FROM   refund_order a   LEFT JOIN channel b     ON a.pay_type = b.channel_no     LEFT JOIN biz c ON a.biz_no = c.biz_no where 1=1  ").append(paramStr);
        logger.info(sql.toString());
        logger.info(payRefundOrderParams.toArray().toString());
        return new Pagination(sql.toString(), payRefundOrderParams.toArray(), pageParam, new RefundOrderMapper(), this.jdbcTemplate);
    }
}

