/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.PayLabQueryRequest;
import com.xunlei.channel.api.basechannel.entity.PayLabel;
import com.xunlei.channel.api.basechannel.mapper.PayLabelMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class PayLabDao
extends GatewayBaseDao<PayLabel> {
    private static final Logger logger = LoggerFactory.getLogger(PayLabDao.class);

    public List<PayLabel> query(PayLabQueryRequest object) {
        StringBuffer sql = new StringBuffer("SELECT   a.*,  COUNT(DISTINCT b.channel_no) AS channels,  GROUP_CONCAT(DISTINCT b.channel_no) AS channel_no ,  GROUP_CONCAT(DISTINCT c.channel_name) AS channel_name  FROM   pay_label a   LEFT JOIN channel_label b     ON a.label_no = b.label_no   LEFT JOIN channel c   ON b.channel_no = c.channel_no WHERE 1 = 1   ");
        if (!StringUtils.isEmpty((Object)object.getLabelName())) {
            sql.append(" and a.label_name like '%").append(object.getLabelName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getLabelShowNo())) {
            sql.append(" and a.label_show_no like '%").append(object.getLabelShowNo()).append("%'");
        }
        sql.append(" GROUP BY a.label_no");
        sql.append(" order by a.label_no asc");
        logger.info("query pay_label " + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new PayLabelMapper());
        return list;
    }

    public List<PayLabel> queryLabel(PayLabQueryRequest object) {
        StringBuffer sql = new StringBuffer("SELECT label_no,label_name,label_show_no from pay_label where 1=1  ");
        if (!StringUtils.isEmpty((Object)object.getLabelName())) {
            sql.append(" and label_name='").append(object.getLabelName()).append("'");
        }
        logger.info("query pay_label " + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public PayLabel mapRow(ResultSet rs, int rowNum) throws SQLException {
                PayLabel payLabel = new PayLabel();
                payLabel.setLabelName(rs.getString("label_name"));
                payLabel.setLabelShowNo(rs.getString("label_show_no"));
                payLabel.setLabelNo(rs.getString("label_no"));
                return payLabel;
            }
        });
        return list;
    }

    public int insert(PayLabQueryRequest object) {
        StringBuffer sql = new StringBuffer("INSERT INTO pay_label            (             label_no,label_show_no,             label_name,             remark,             create_time,             update_time)VALUES (        ?,?,        ?,        ?,        NOW(),        NOW());");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getLabelNo(), object.getLabelShowNo(), object.getLabelName(), object.getRemark()});
        return temp;
    }

    public int update(PayLabQueryRequest object) {
        StringBuffer sql = new StringBuffer("    UPDATE pay_label                   SET label_show_no= ?,                           label_name = ?,                         remark = ?,                         update_time=NOW() where label_no= ?");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getLabelShowNo(), object.getLabelName(), object.getRemark(), object.getLabelNo()});
        return temp;
    }

    public int delete(PayLabQueryRequest object) {
        StringBuffer sql = new StringBuffer(" DELETE FROM pay_label  WHERE label_no = ?");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getLabelNo()});
        return temp;
    }
}

