/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.OneThingCoinPayTransferOrder;
import com.xunlei.channel.api.dao.PayproxyBaseDao;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class OnethingcoinpayTransferOrderDao
extends PayproxyBaseDao<OneThingCoinPayTransferOrder> {
    private static final Logger logger = LoggerFactory.getLogger(OnethingcoinpayTransferOrderDao.class);

    public void insert(List<OneThingCoinPayTransferOrder> params) {
        StringBuffer sql = new StringBuffer("   INSERT INTO onethingcoinpaytransferorder (  successTime, TYPE,tradeAccount,amount,cost,HASH,extra,title,orderId,nonce,createTime,fromAccount)        VALUES (?,?,?,?,?,?,?,?,?,?,NOW(),?);");
        logger.info("insert into OneThingCoinPayTransferOrder sql:{}", (Object)sql.toString());
        int listSize = params.size();
        int init = 10000;
        int times = listSize / init;
        if (listSize % init != 0) {
            ++times;
        }
        for (int j = 0; j < times; ++j) {
            int beginIdex = j * init;
            int endIndex = (j + 1) * init;
            if (endIndex > listSize) {
                endIndex = listSize;
            }
            final List<OneThingCoinPayTransferOrder> list = params.subList(beginIdex, endIndex);
            this.jdbcTemplate.batchUpdate(sql.toString(), new BatchPreparedStatementSetter(){

                public void setValues(PreparedStatement preparedStatement, int i) throws SQLException {
                    OneThingCoinPayTransferOrder param = (OneThingCoinPayTransferOrder)list.get(i);
                    preparedStatement.setString(1, param.getTimestamp());
                    preparedStatement.setString(2, param.getType());
                    preparedStatement.setString(3, param.getTradeAccount());
                    preparedStatement.setString(4, param.getAmount());
                    preparedStatement.setString(5, param.getCost());
                    preparedStatement.setString(6, param.getHash());
                    preparedStatement.setString(7, param.getExtra());
                    preparedStatement.setString(8, param.getTitle());
                    preparedStatement.setString(9, param.getOrderId());
                    preparedStatement.setString(10, param.getNonce());
                    preparedStatement.setString(11, param.getFromAccount());
                }

                public int getBatchSize() {
                    return list.size();
                }
            });
        }
    }

    public List<OneThingCoinPayTransferOrder> query(OneThingCoinPayTransferOrder object) {
        StringBuffer sql = new StringBuffer("SELECT *  FROM onethingcoinpaytransferorder WHERE orderId='").append(object.getOrderId()).append("'").append(" and fromAccount='").append(object.getFromAccount()).append("'").append(" and tradeAccount='").append(object.getTradeAccount()).append("'");
        logger.info("OneThingCoinPayTransferOrder query sql :{}", (Object)sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new RowMapper<OneThingCoinPayTransferOrder>(){

            public OneThingCoinPayTransferOrder mapRow(ResultSet resultSet, int i) throws SQLException {
                OneThingCoinPayTransferOrder oneThingCoinPayTransferOrder = new OneThingCoinPayTransferOrder();
                oneThingCoinPayTransferOrder.setOrderId(resultSet.getString("orderId"));
                return oneThingCoinPayTransferOrder;
            }
        });
        return list;
    }

    public String getLastOrderTime(String account) {
        StringBuffer sql = new StringBuffer("SELECT SuccessTime FROM onethingcoinpaytransferorder WHERE fromAccount='").append(account).append("' ORDER BY successTime DESC LIMIT 1;");
        logger.info(" query getLastOrderTime sql:{} ", (Object)sql.toString());
        String successTime = (String)this.jdbcTemplate.queryForObject(sql.toString(), String.class);
        return successTime;
    }

    public int getMaxNonce(String account) {
        StringBuffer sql = new StringBuffer("SELECT max(nonce+0) FROM onethingcoinpaytransferorder WHERE type=0 and  fromAccount='").append(account).append("'");
        int maxNonce = (Integer)this.jdbcTemplate.queryForObject(sql.toString(), Integer.class);
        return maxNonce;
    }

    public void updateNonce(String account) {
        int maxNonce = this.getMaxNonce(account);
        int init = 10000;
        int times = maxNonce / init;
        if (maxNonce % init != 0) {
            ++times;
        }
        ArrayList list = new ArrayList();
        for (int j = 0; j < times; ++j) {
            for (int k = j * init; k < (j + 1) * init && k < maxNonce; ++k) {
            }
        }
        StringBuffer sql = new StringBuffer("UPDATE onethingcoinpaytransferorder SET nonce =").append("CONCAT('0x',LOWER(CONV(").append(maxNonce).append("-(nonce+0),10,16))) WHERE fromAccount ='").append(account).append("'").append(" and type='0'");
        logger.info("update nonce sql:{}", (Object)sql.toString());
        this.jdbcTemplate.update(sql.toString());
    }

    public void delete(String fromAddress) {
        StringBuffer sql = new StringBuffer(" delete from onethingcoinpaytransferorder where fromAccount='").append(fromAddress).append("'");
        logger.info("delete porket order sql :{}", (Object)sql.toString());
        this.jdbcTemplate.update(sql.toString());
    }
}

