/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.ContactResultQueryRequest;
import com.xunlei.channel.api.basechannel.jdbc.PageParam;
import com.xunlei.channel.api.basechannel.jdbc.Pagination;
import com.xunlei.channel.api.basechannel.mapper.ContactResultMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class ContactResultDao
extends GatewayBaseDao<ContactResultDao> {
    private static final Logger logger = LoggerFactory.getLogger(ContactResultDao.class);

    public Pagination queryContactResult(ContactResultQueryRequest object, PageParam pageParam) {
        ArrayList<String> contractResultParams = new ArrayList<String>();
        StringBuffer paramStr = new StringBuffer();
        if (!StringUtils.isEmpty((Object)object.getBizOrderId())) {
            paramStr.append(" and a.biz_order_id = ? ");
            contractResultParams.add(object.getBizOrderId());
        }
        if (!StringUtils.isEmpty((Object)object.getBizNo())) {
            paramStr.append(" and c.biz_name = ? ");
            contractResultParams.add(object.getBizNo());
        }
        if (!StringUtils.isEmpty((Object)object.getBizName())) {
            paramStr.append(" and c.biz_name = ? ");
            contractResultParams.add(object.getBizName());
        }
        if (!StringUtils.isEmpty((Object)object.getUseShow())) {
            paramStr.append(" and a.xunlei_pay_id = ? ");
            contractResultParams.add(object.getUseShow());
        }
        if (!StringUtils.isEmpty((Object)object.getXunleiId())) {
            paramStr.append(" and a.channel_order_id = ? ");
            contractResultParams.add(object.getXunleiId());
        }
        if (!StringUtils.isEmpty((Object)object.getThirdpartyAccount())) {
            paramStr.append(" and a.refund_status = ? ");
            contractResultParams.add(object.getThirdpartyAccount());
        }
        if (!StringUtils.isEmpty((Object)object.getBeginTime()) && !StringUtils.isEmpty((Object)object.getEndTime())) {
            paramStr.append(" and a.create_time between ? and ?");
            contractResultParams.add(object.getBeginTime() + " 00:00:00");
            contractResultParams.add(object.getEndTime() + " 23:59:59");
        }
        StringBuffer sql = new StringBuffer("SELECT   a.*,  b.order_amt,  c.channel_name,  d.biz_name  FROM   contact_result a   LEFT JOIN channel_auto_pay_result b    ON a.sign_no = a.sign_no   LEFT JOIN channel c    ON a.pay_type = c.channel_no   LEFT JOIN biz d     ON b.biz_no = d.biz_no     WHERE a.the_type='QY' where 1=1  ").append(paramStr);
        logger.info(sql.toString());
        logger.info(contractResultParams.toArray().toString());
        return new Pagination(sql.toString(), contractResultParams.toArray(), pageParam, new ContactResultMapper(), this.jdbcTemplate);
    }

    public Pagination queryQuitContactResult(ContactResultQueryRequest object, PageParam pageParam) {
        ArrayList<String> contractResultParams = new ArrayList<String>();
        StringBuffer paramStr = new StringBuffer();
        if (!StringUtils.isEmpty((Object)object.getBizOrderId())) {
            paramStr.append(" and a.biz_order_id = ? ");
            contractResultParams.add(object.getBizOrderId());
        }
        if (!StringUtils.isEmpty((Object)object.getBizNo())) {
            paramStr.append(" and c.biz_name = ? ");
            contractResultParams.add(object.getBizNo());
        }
        if (!StringUtils.isEmpty((Object)object.getBizName())) {
            paramStr.append(" and c.biz_name = ? ");
            contractResultParams.add(object.getBizName());
        }
        if (!StringUtils.isEmpty((Object)object.getUseShow())) {
            paramStr.append(" and a.xunlei_pay_id = ? ");
            contractResultParams.add(object.getUseShow());
        }
        if (!StringUtils.isEmpty((Object)object.getXunleiId())) {
            paramStr.append(" and a.channel_order_id = ? ");
            contractResultParams.add(object.getXunleiId());
        }
        if (!StringUtils.isEmpty((Object)object.getThirdpartyAccount())) {
            paramStr.append(" and a.refund_status = ? ");
            contractResultParams.add(object.getThirdpartyAccount());
        }
        if (!StringUtils.isEmpty((Object)object.getBeginTime()) && !StringUtils.isEmpty((Object)object.getEndTime())) {
            paramStr.append(" and a.create_time between ? and ?");
            contractResultParams.add(object.getBeginTime() + " 00:00:00");
            contractResultParams.add(object.getEndTime() + " 23:59:59");
        }
        StringBuffer sql = new StringBuffer("SELECT   a.*,  b.order_amt,  c.channel_name,  d.biz_name  FROM   contact_result a   LEFT JOIN channel_auto_pay_quit b    ON a.sign_no = a.sign_no   LEFT JOIN channel c    ON a.pay_type = c.channel_no   LEFT JOIN biz d     ON b.biz_no = d.biz_no     WHERE a.the_type='JY' where 1=1  ").append(paramStr);
        logger.info(sql.toString());
        logger.info(contractResultParams.toArray().toString());
        return new Pagination(sql.toString(), contractResultParams.toArray(), pageParam, new ContactResultMapper(), this.jdbcTemplate);
    }
}

