/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.Channel;
import com.xunlei.channel.api.basechannel.entity.ChannelQueryRequest;
import com.xunlei.channel.api.basechannel.mapper.ChannelMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class ChannelDao
extends GatewayBaseDao<Channel> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelDao.class);

    public List<Channel> query(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer(" select id,channel_no,channel_name, in_use , label_name, service_name,label_no ,remark ,service_no,type from (SELECT a.id,   a.channel_no,  a.channel_name,  a.in_use, a.remark,a.service_no, a.type,  GROUP_CONCAT(DISTINCT c.label_name) as label_name,  d.service_name , GROUP_CONCAT(DISTINCT c.label_no) as label_no FROM   channel a   LEFT JOIN channel_label b     ON a.channel_no = b.channel_no   LEFT JOIN pay_label c     ON b.label_no = c.label_no   LEFT JOIN sign_service d     ON a.service_no = d.service_no  GROUP BY a.channel_no ) as channel  where 1=1  ");
        if (!StringUtils.isEmpty((Object)object.getChannelName())) {
            sql.append(" and channel.channel_name like '%").append(object.getChannelName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getServiceName())) {
            sql.append(" and channel.service_name like '%").append(object.getServiceName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getInUse())) {
            sql.append(" and channel.in_use ='").append(object.getInUse()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getLabelName())) {
            sql.append(" and channel.label_name like '%").append(object.getLabelName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getServiceNo())) {
            sql.append(" and channel.service_no='").append(object.getServiceNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getType())) {
            sql.append(" and channel.type='").append(object.getType()).append("'");
        }
        sql.append(" order by channel.channel_no asc");
        logger.info("query channel:" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Channel mapRow(ResultSet rs, int rowNum) throws SQLException {
                Channel temp = new Channel();
                temp.setId(rs.getInt("id"));
                temp.setChannelName(rs.getString("channel_name") == null ? "" : rs.getString("channel_name"));
                temp.setChannelNo(rs.getString("channel_no"));
                temp.setInUse(rs.getString("in_use"));
                temp.setLabelName(rs.getString("label_name") == null ? "" : rs.getString("label_name"));
                temp.setServiceName(rs.getString("service_name") == null ? "" : rs.getString("service_name"));
                temp.setLabelNo(rs.getString("label_no") == null ? "" : rs.getString("label_no"));
                temp.setRemark(rs.getString("remark") == null ? "" : rs.getString("remark"));
                temp.setServiceNo(rs.getString("service_no") == null ? "" : rs.getString("service_no"));
                temp.setType(rs.getString("type") == null ? "" : rs.getString("type"));
                return temp;
            }
        });
        return list;
    }

    public List<Channel> queryChannel(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer("SELECT  a.id, a.channel_no,  a.service_no,  a.channel_name,  a.in_use,  a.remark ,a.type,  GROUP_CONCAT(b.label_no) as label_no  FROM   channel a   LEFT JOIN channel_label b   ON a.channel_no = b.channel_no   where 1=1 ");
        if (!StringUtils.isEmpty((Object)object.getChannelName())) {
            sql.append(" and  channel_name = '").append(object.getChannelName()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getChannelNo())) {
            sql.append(" and  a.channel_no = '").append(object.getChannelNo()).append("'");
        }
        sql.append("  GROUP BY a.channel_no");
        logger.info("query channel sql :" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Channel mapRow(ResultSet rs, int rowNum) throws SQLException {
                Channel temp = new Channel();
                temp.setId(rs.getInt("id"));
                temp.setChannelName(rs.getString("channel_name") == null ? "" : rs.getString("channel_name"));
                temp.setChannelNo(rs.getString("channel_no") == null ? "" : rs.getString("channel_no"));
                temp.setInUse(rs.getString("in_use") == null ? "" : rs.getString("in_use"));
                temp.setServiceNo(rs.getString("service_no") == null ? "" : rs.getString("service_no"));
                temp.setRemark(rs.getString("remark") == null ? "" : rs.getString("remark"));
                temp.setLabelNo(rs.getString("label_no") == null ? "" : rs.getString("label_no"));
                temp.setType(rs.getString("type"));
                return temp;
            }
        });
        return list;
    }

    public List<Channel> queryChannelAndService(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer(" SELECT   a.channel_name,  b.service_name,  c.provider_name,  c.provider_no FROM  channel a   LEFT JOIN sign_service b     ON a.service_no = b.service_no   LEFT JOIN service_provider c     ON b.provider_no = c.provider_no  ");
        logger.info("query channel:" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Channel mapRow(ResultSet rs, int rowNum) throws SQLException {
                Channel temp = new Channel();
                temp.setChannelName(rs.getString("channel_name") == null ? "" : rs.getString("channel_name"));
                temp.setServiceName(rs.getString("service_name") == null ? "" : rs.getString("service_name"));
                temp.setProviderName(rs.getString("provider_name") == null ? "" : rs.getString("provider_name"));
                temp.setProviderNo(rs.getString("provider_no") == null ? "" : rs.getString("provider_no"));
                return temp;
            }
        });
        return list;
    }

    public List<Channel> queryChannelByName(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer(" SELECT * FROM channel where 1=1  ");
        if (!StringUtils.isEmpty((Object)object.getChannelName())) {
            sql.append(" and  channel_name = '").append(object.getChannelName()).append("'");
        }
        logger.info("query channel by Name :" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new ChannelMapper());
        return list;
    }

    public List<Channel> queryChannelByNo(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer(" SELECT * FROM channel where 1=1  ");
        if (!StringUtils.isEmpty((Object)object.getChannelNo())) {
            sql.append(" and  channel_no = '").append(object.getChannelNo()).append("'");
        }
        logger.info("query channel by channel_no :" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new ChannelMapper());
        return list;
    }

    public int insert(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer("   INSERT INTO channel            (             channel_no,             service_no,             channel_name,             in_use,             deleted,             remark,type,             create_time,             update_time)VALUES (        ?,        ?,       ?,        ?,        'N',        ?,?,        NOW(),        NOW(),?)");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getChannelNo(), object.getServiceNo(), object.getChannelName(), object.getInUse(), object.getRemark(), object.getType()});
        return temp;
    }

    public int delete(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer("DELETE FROM channel WHERE  channel_no=?  ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getChannelNo()});
        return temp;
    }

    public int update(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer("UPDATE   channel SET  channel_no = ? ,service_no = ?,  channel_name = ?,  in_use = ?,  remark = ?,type=?,  update_time = NOW() WHERE id = ? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getChannelNo(), object.getServiceNo(), object.getChannelName(), object.getInUse(), object.getRemark(), object.getType(), object.getId()});
        logger.info("update channel " + sql.toString());
        return temp;
    }

    public int isInUse(ChannelQueryRequest object) {
        StringBuffer sql = new StringBuffer("UPDATE channel SET in_use=? WHERE  channel_no=?  ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getInUse(), object.getChannelNo()});
        return temp;
    }
}

