/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.ChannelBusiness;
import com.xunlei.channel.api.basechannel.mapper.ChannelBusinessMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class ChannelBusinessDao
extends GatewayBaseDao<ChannelBusiness> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelBusinessDao.class);

    public List<ChannelBusiness> query(ChannelBusiness channelBiz) {
        StringBuffer sql = new StringBuffer(" select * from channel_business  where selected='Y' ");
        sql.append(" and  channel_no = '").append(channelBiz.getChannelNo()).append("'");
        sql.append(" and provider_no = '").append(channelBiz.getProviderNo()).append("'");
        sql.append(" and service_no = '").append(channelBiz.getServiceNo()).append("'");
        sql.append(" and account_no = '").append(channelBiz.getAccountNo()).append("'");
        sql.append(" and biz_no = '").append(channelBiz.getBizNo()).append("'");
        logger.info("\u67e5\u8be2\u4fdd\u5b58\u7684\u6e20\u9053\uff0c\u670d\u52a1\u5546\uff0c\u670d\u52a1\u6240\u9009\u4e2d\u7684\u8d26\u6237 :{} :\u67e5\u8be2\u7684\u5bf9\u8c61\uff1a{}", (Object)sql.toString(), (Object)channelBiz.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new ChannelBusinessMapper());
        return list;
    }

    public List<ChannelBusiness> getByChannelNo(List<String> nos) {
        return this.getListIn("channel_no", nos);
    }

    public List<ChannelBusiness> getByBizNo(List<String> nos) {
        return this.getListIn("biz_no", nos);
    }

    public List<ChannelBusiness> getByAccountNo(List<String> nos) {
        return this.getListIn("account_no", nos);
    }

    private List<ChannelBusiness> getListIn(String column, List<String> data) {
        StringBuilder sql = new StringBuilder("select * from channel_business where ");
        sql.append(column).append(" in (:list)");
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("list", data);
        NamedParameterJdbcTemplate namedParameterJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)this.jdbcTemplate);
        return namedParameterJdbcTemplate.query(sql.toString(), (SqlParameterSource)parameterSource, (RowMapper)new ChannelBusinessMapper());
    }

    public List<ChannelBusiness> queryByNo(ChannelBusiness channelBiz) {
        StringBuffer sql = new StringBuffer("select * from channel_business where 1=1");
        if (!StringUtils.isEmpty((Object)channelBiz.getBizNo())) {
            sql.append(" and biz_no = '").append(channelBiz.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBiz.getChannelNo())) {
            sql.append(" and channel_no = '").append(channelBiz.getChannelNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBiz.getAccountNo())) {
            sql.append(" and account_no = '").append(channelBiz.getAccountNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBiz.getProviderNo())) {
            sql.append(" and provider_no = '").append(channelBiz.getProviderNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBiz.getServiceNo())) {
            sql.append(" and service_no = '").append(channelBiz.getServiceNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBiz.getSelected())) {
            sql.append(" and selected = '").append(channelBiz.getSelected()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBiz.getChannelStatus())) {
            sql.append(" and channel_status = '").append(channelBiz.getChannelStatus()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBiz.getBizStatus())) {
            sql.append(" and biz_status = '").append(channelBiz.getBizStatus()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBiz.getAccountStatus())) {
            sql.append(" and account_status = '").append(channelBiz.getAccountStatus()).append("'");
        }
        logger.info("\u6839\u636e\u7f16\u7801,\u72b6\u6001\u67e5\u8be2channel_business\u4e2d\u95f4\u8868\u4e2d\u4fdd\u5b58\u7684\u6570\u636esql :{} :serviceNo\uff1a{}", (Object)sql.toString(), (Object)channelBiz);
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new ChannelBusinessMapper());
        return list;
    }

    public List<ChannelBusiness> queryChannelByBiz(ChannelBusiness object) {
        StringBuffer sql = new StringBuffer("SELECT   a.biz_no,g.channel_no,  e.provider_no,  f.service_no,  e.provider_name,  f.service_name,  g.channel_name,  GROUP_CONCAT(DISTINCT d.account_no) as account_no ,  GROUP_CONCAT(DISTINCT d.account_name) as account_name  FROM   biz a   LEFT JOIN biz_line b     ON a.biz_line_no = b.biz_line_no   LEFT JOIN merchants c     ON b.merchants_no = c.merchants_no   LEFT JOIN account d     ON c.merchants_no = d.merchants_no RIGHT JOIN account_sign_service h     ON h.account_no=d.account_no   LEFT JOIN service_provider e     ON d.provider_no = e.provider_no   LEFT JOIN sign_service f     ON e.provider_no = f.provider_no   LEFT JOIN channel g     ON f.service_no = g.service_no  where  d.is_use='Y' and g.in_use='Y' and a.biz_status='Y' ");
        if (!StringUtils.isEmpty((Object)object.getBizNo())) {
            sql.append(" and a.biz_no = '").append(object.getBizNo()).append("'");
        }
        sql.append(" GROUP BY  g.channel_no,e.provider_no,f.service_no ");
        logger.info("\u6839\u636e\u4e1a\u52a1\u7f16\u7801\u67e5\u8be2\u670d\u52a1\u5bf9\u5e94\u7684\u8d26\u6237\uff0c\u670d\u52a1\u5546\uff0c\u670d\u52a1\u4fe1\u606f " + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public ChannelBusiness mapRow(ResultSet rs, int rowNum) throws SQLException {
                ChannelBusiness temp = new ChannelBusiness();
                temp.setServiceNo(rs.getString("service_no") == null ? "" : rs.getString("service_no"));
                temp.setProviderNo(rs.getString("provider_no") == null ? "" : rs.getString("provider_no"));
                temp.setAccountNo(rs.getString("account_no") == null ? "" : rs.getString("account_no"));
                temp.setChannelNo(rs.getString("channel_no") == null ? "" : rs.getString("channel_no"));
                temp.setBizNo(rs.getString("biz_no") == null ? "" : rs.getString("biz_no"));
                temp.setChannelName(rs.getString("channel_name") == null ? "" : rs.getString("channel_name"));
                temp.setProviderName(rs.getString("provider_name") == null ? "" : rs.getString("provider_name"));
                temp.setServiceName(rs.getString("service_name") == null ? "" : rs.getString("service_name"));
                temp.setAccountName(rs.getString("account_name") == null ? "" : rs.getString("account_name"));
                return temp;
            }
        });
        return list;
    }

    public int insert(ChannelBusiness object) {
        StringBuffer sql = new StringBuffer("INSERT INTO channel_business (  biz_no,  channel_no,  provider_no,  service_no,  account_no,  sign_body_no,  selected,  create_time,  update_time,  remark,biz_status,channel_status,account_status) VALUES  (?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), ?,?,?,?)");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getBizNo(), object.getChannelNo(), object.getProviderNo(), object.getServiceNo(), object.getAccountNo(), object.getSignBodyNo(), "Y", object.getRemark(), "Y", "Y", "Y"});
        logger.info("\u65b0\u589e\u6e20\u9053\u4e1a\u52a1\u5173\u7cfb\uff1a{} \u65b0\u589e\u5bf9\u8c61\uff1a{}", (Object)sql.toString(), (Object)object.toString());
        return temp;
    }

    public int delete(ChannelBusiness channelBiz) {
        StringBuffer sql = new StringBuffer(" delete from  channel_business  where service_no= ? and provider_no= ? and channel_no= ? and biz_no= ? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{channelBiz.getServiceNo(), channelBiz.getProviderNo(), channelBiz.getChannelNo(), channelBiz.getBizNo()});
        logger.info("\u5220\u9664\u9009\u4e2d\u7684\u8d26\u6237\u4fe1\u606fsql:{},\u5220\u9664\u7684\u5bf9\u8c61\uff1a{}", (Object)sql.toString(), (Object)channelBiz.toString());
        return temp;
    }

    public int deleteByNo(ChannelBusiness channelBusiness) {
        StringBuffer sql = new StringBuffer(" delete from  channel_business  where 1=1  ");
        if (!StringUtils.isEmpty((Object)channelBusiness.getBizNo())) {
            sql.append("  and biz_no= '").append(channelBusiness.getBizNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBusiness.getServiceNo())) {
            sql.append("  and service_no= '").append(channelBusiness.getServiceNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBusiness.getChannelNo())) {
            sql.append("  and channel_no= '").append(channelBusiness.getChannelNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)channelBusiness.getAccountNo())) {
            sql.append("  and account_no= '").append(channelBusiness.getAccountNo()).append("'");
        }
        int temp = this.jdbcTemplate.update(sql.toString());
        logger.info("\u5220\u9664\u9009\u4e2d\u7684\u8d26\u6237\u4fe1\u606fsql:{},\u5220\u9664\u7684\u5bf9\u8c61\uff1a{}", (Object)sql.toString(), (Object)channelBusiness.toString());
        return temp;
    }

    public int updateStatus(ChannelBusiness object) {
        StringBuffer sql = new StringBuffer(" update channel_business set update_time=NOW() ");
        StringBuffer parms = new StringBuffer();
        if (!StringUtils.isEmpty((Object)object.getSelected())) {
            sql.append(" , selected=? ");
            parms.append(",").append(object.getSelected());
        }
        if (!StringUtils.isEmpty((Object)object.getBizStatus())) {
            sql.append(" , biz_status=? ");
            parms.append(",").append(object.getBizStatus());
        }
        if (!StringUtils.isEmpty((Object)object.getChannelStatus())) {
            sql.append(" , channel_status=? ");
            parms.append(",").append(object.getChannelStatus());
        }
        if (!StringUtils.isEmpty((Object)object.getAccountStatus())) {
            sql.append(" , account_status=? ");
            parms.append(",").append(object.getAccountStatus());
        }
        sql.append("where 1=1");
        if (!StringUtils.isEmpty((Object)object.getBizNo())) {
            sql.append(" and biz_no=? ");
            parms.append(",").append(object.getBizNo());
        }
        if (!StringUtils.isEmpty((Object)object.getChannelNo())) {
            sql.append(" and channel_no=? ");
            parms.append(",").append(object.getChannelNo());
        }
        if (!StringUtils.isEmpty((Object)object.getAccountNo())) {
            sql.append(" and account_no=? ");
            parms.append(",").append(object.getAccountNo());
        }
        if (!StringUtils.isEmpty((Object)object.getServiceNo())) {
            sql.append(" and service_no=? ");
            parms.append(",").append(object.getServiceNo());
        }
        String parmsStr = parms.toString().trim();
        logger.info("\u4fee\u6539channelBusiness \u4e2d\u95f4\u8868\u4e2d\u7684\u72b6\u6001sql:{},parms:{}", (Object)sql.toString(), (Object)parms.toString());
        int temp = this.jdbcTemplate.update(sql.toString(), (Object[])parmsStr.substring(1, parmsStr.length()).split(","));
        return temp;
    }
}

