/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.BizLine;
import com.xunlei.channel.api.basechannel.entity.BizLineQueryRequest;
import com.xunlei.channel.api.basechannel.mapper.BizLineMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class BizLineDao
extends GatewayBaseDao<BizLine> {
    private static final Logger logger = LoggerFactory.getLogger(BizLineDao.class);

    public List<BizLine> query(BizLineQueryRequest object) {
        StringBuffer sql = new StringBuffer(" SELECT   a.biz_line_no,  a.biz_line_name , a.create_time, a.update_time,  a.source,  a.contract,  a.phone,   a.contract_info,  a.remark,  b.merchants_name, b.merchants_no  FROM   biz_line a    LEFT JOIN merchants b     ON a.merchants_no = b.merchants_no  where 1=1  ");
        logger.info("query businessline:" + sql.toString());
        if (!StringUtils.isEmpty((Object)object.getBizLineName())) {
            sql.append(" and a.biz_line_name like '%").append(object.getBizLineName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getMerchantsName())) {
            sql.append(" and b.merchants_name like '%").append(object.getMerchantsName()).append("%'");
        }
        sql.append(" order by a.biz_line_no asc ");
        logger.info("bizLine qurey :" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public BizLine mapRow(ResultSet rs, int rowNum) throws SQLException {
                BizLine temp = new BizLine();
                temp.setBizLineNo(rs.getString("biz_line_no") == null ? "" : rs.getString("biz_line_no"));
                temp.setBizLineName(rs.getString("biz_line_name") == null ? "" : rs.getString("biz_line_name"));
                temp.setCreateTime(rs.getString("create_time") == null ? "" : rs.getString("create_time"));
                temp.setUpdateTime(rs.getString("update_time") == null ? "" : rs.getString("update_time"));
                temp.setSource(rs.getString("source") == null ? "" : rs.getString("source"));
                temp.setContract(rs.getString("contract") == null ? "" : rs.getString("contract"));
                temp.setPhone(rs.getString("phone") == null ? "" : rs.getString("phone"));
                temp.setRemark(rs.getString("remark") == null ? "" : rs.getString("remark"));
                temp.setContractInfo(rs.getString("contract_info") == null ? "" : rs.getString("contract_info"));
                temp.setMerchantsName(rs.getString("merchants_name") == null ? "" : rs.getString("merchants_name"));
                temp.setMerchantsNo(rs.getString("merchants_no") == null ? "" : rs.getString("merchants_no"));
                return temp;
            }
        });
        return list;
    }

    public List<BizLine> findBusinessLine(BizLineQueryRequest object) {
        StringBuffer sql = new StringBuffer(" select *  from biz_line where biz_line_name='").append(object.getBizLineName()).append("'");
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new BizLineMapper());
        return list;
    }

    public int insert(BizLineQueryRequest object) {
        StringBuffer sql = new StringBuffer("INSERT INTO biz_line            (             biz_line_no,             biz_line_name,             merchants_no,             source,             contract,             phone,             contract_info,             remark, deleted ,             create_time,             update_time)VALUES (        ?,        ?,        ?,       'INSIDE_MER',       ?,        ?,        ?,        ?,'N',        NOW(),        NOW())");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getBizLineNo(), object.getBizLineName(), object.getMerchantsNo(), object.getContract(), object.getPhone(), object.getContractInfo(), object.getRemark()});
        return temp;
    }

    public int delete(BizLineQueryRequest object) {
        StringBuffer sql = new StringBuffer(" DELETE FROM biz_line WHERE biz_line_no=? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getBizLineNo()});
        return temp;
    }

    public int update(BizLineQueryRequest object) {
        StringBuffer sql = new StringBuffer("UPDATE biz_line SET  biz_line_name = ?,  merchants_no =?,  source = ?,  contract =?,  phone= ?,  contract_info = ?,  remark = ?,  update_time = NOW()WHERE biz_line_no= ?");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getBizLineName(), object.getMerchantsNo(), object.getSource(), object.getContract(), object.getPhone(), object.getContractInfo(), object.getRemark(), object.getBizLineNo()});
        return temp;
    }
}

