/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.entity.Biz;
import com.xunlei.channel.api.basechannel.entity.BizQueryRequest;
import com.xunlei.channel.api.basechannel.mapper.BizMapper;
import com.xunlei.channel.api.basechannel.utils.CommonUtils;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class BizDao
extends GatewayBaseDao<Biz> {
    private static final Logger logger = LoggerFactory.getLogger(BizDao.class);

    public List<Biz> query(BizQueryRequest object) {
        StringBuffer sql = new StringBuffer(" SELECT DISTINCT  a.biz_no,  a.biz_name,  a.contact_name,  a.contact_phone, a.biz_key ,  a.biz_status,  a.remark,  a.partner_id,  a.create_time,  a.update_time,  a.biz_line_no,  a.type,  b.biz_line_name,  b.merchants_no,  c.merchants_name  FROM biz a LEFT JOIN channel_business d ON a.biz_no = d.biz_no  LEFT JOIN biz_line b ON a.biz_line_no = b.biz_line_no LEFT JOIN channel e     ON d.channel_no=d.channel_no LEFT JOIN merchants c ON b.merchants_no = c.merchants_no WHERE 1=1 ");
        if (!StringUtils.isEmpty((Object)object.getBizName())) {
            sql.append(" and a.biz_name like '%").append(object.getBizName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getBizLineName())) {
            sql.append(" and b.biz_line_name like '%").append(object.getBizLineName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getBizStatus())) {
            sql.append(" and a.biz_status ='").append(object.getBizStatus()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getMerchantsName())) {
            sql.append(" and c.merchants_name like '%").append(object.getMerchantsName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getChannelNo())) {
            sql.append(" and d.channel_no='").append(object.getChannelNo()).append("'");
            sql.append(" and selected='Y'");
        }
        if (!StringUtils.isEmpty((Object)object.getBizLineNo())) {
            sql.append(" and a.biz_line_no='").append(object.getBizLineNo()).append("'");
        }
        sql.append(" order by a.biz_no asc");
        logger.info("b :" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Biz mapRow(ResultSet rs, int rowNum) throws SQLException {
                Biz temp = new Biz();
                temp.setBizNo(rs.getString("biz_no") == null ? "" : rs.getString("biz_no"));
                temp.setBizName(rs.getString("biz_name") == null ? "" : rs.getString("biz_name"));
                temp.setBizLineNo(rs.getString("biz_line_no") == null ? "" : rs.getString("biz_line_no"));
                temp.setBizStatus(rs.getString("biz_status") == null ? "" : rs.getString("biz_status"));
                temp.setCreateTime(rs.getString("create_time") == null ? "" : rs.getString("create_time"));
                temp.setUpdateTime(rs.getString("update_time") == null ? "" : rs.getString("update_time"));
                temp.setType(rs.getString("type") == null ? "" : rs.getString("type"));
                temp.setContactName(rs.getString("contact_name") == null ? "" : rs.getString("contact_name"));
                temp.setRemark(rs.getString("remark") == null ? "" : rs.getString("remark"));
                temp.setContactPhone(rs.getString("contact_phone") == null ? "" : rs.getString("contact_phone"));
                temp.setBizLineName(rs.getString("biz_line_name") == null ? "" : rs.getString("biz_line_name"));
                temp.setMerchantsName(rs.getString("merchants_name") == null ? "" : rs.getString("merchants_name"));
                temp.setMerchantsNo(rs.getString("merchants_no") == null ? "" : rs.getString("merchants_no"));
                temp.setBizKey(rs.getString("biz_key") == null ? "" : rs.getString("biz_key"));
                return temp;
            }
        });
        return list;
    }

    public List<Biz> findBusiess(BizQueryRequest object) {
        StringBuffer sql = new StringBuffer("SELECT * FROM biz WHERE biz_name='").append(object.getBizName()).append("'");
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new BizMapper());
        return list;
    }

    public List<Biz> findBizByBizNo(String bizNo) {
        StringBuffer sql = new StringBuffer("SELECT * FROM biz WHERE biz_no='").append(bizNo).append("'");
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new BizMapper());
        return list;
    }

    public int insert(BizQueryRequest object) {
        String bizKey = CommonUtils.getRandomString(16);
        StringBuffer sql = new StringBuffer(" INSERT INTO  biz  (biz_no,biz_name ,                            biz_line_no ,                            biz_status,                             create_time,                             update_time,                             type,contact_name,contact_phone,remark,biz_key,partner_id)                            values(?,?,?,?,now(),now(),?,?,?,?,?,?) ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getBizNo(), object.getBizName(), object.getBizLineNo(), object.getBizStatus(), object.getType(), object.getContactName(), object.getContactPhone(), object.getRemark(), bizKey, Constants.PARTNER_ID});
        return temp;
    }

    public int delete(BizQueryRequest object) {
        StringBuffer sql = new StringBuffer(" DELETE FROM biz WHERE biz_no=? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getBizNo()});
        return temp;
    }

    public int updateStatus(BizQueryRequest object) {
        StringBuffer sql = new StringBuffer("UPDATE biz SET biz_status=? WHERE biz_no=? ");
        return this.jdbcTemplate.update(sql.toString(), new Object[]{object.getBizStatus(), object.getBizNo()});
    }

    public int update(BizQueryRequest object) {
        StringBuffer sql = new StringBuffer("UPDATE biz                        SET                        biz_name = ?,                          biz_line_no =?,                        biz_status = ?,                         update_time = NOW(),                          type =?,                          contact_name =?,                          remark = ?,                          contact_phone = ?                        WHERE biz_no = ?");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getBizName(), object.getBizLineNo(), object.getBizStatus(), object.getType(), object.getContactName(), object.getRemark(), object.getContactPhone(), object.getBizNo()});
        return temp;
    }
}

