/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.AccountSignService;
import com.xunlei.channel.api.basechannel.mapper.AccountSignServiceMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class AccountSignServiceDao
extends GatewayBaseDao<AccountSignService> {
    private static final Logger logger = LoggerFactory.getLogger(AccountSignServiceDao.class);

    public List<AccountSignService> query(AccountSignService object) {
        StringBuffer sql = new StringBuffer("SELECT  a.id ,   a.account_no,  a.service_no,  a.rate,  a.sign_time,  a.expire_time,  a.remark,  b.service_name,  c.account_name FROM  account_sign_service a  LEFT JOIN sign_service b     ON a.service_no = b.service_no     LEFT JOIN account c ON a.account_no=c.account_no where c.is_use='Y'");
        if (!StringUtils.isEmpty((Object)object.getServiceNo())) {
            sql.append(" and a.service_no = '").append(object.getServiceNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getAccountNo())) {
            sql.append(" and a.account_no = '").append(object.getAccountNo()).append("'");
        }
        logger.info("query account_sign_service " + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new RowMapper<AccountSignService>(){

            public AccountSignService mapRow(ResultSet resultSet, int i) throws SQLException {
                AccountSignService accountSignService = new AccountSignService();
                accountSignService.setId(resultSet.getInt("id"));
                accountSignService.setAccountNo(resultSet.getString("account_no") == null ? "" : resultSet.getString("account_no"));
                accountSignService.setServiceNo(resultSet.getString("service_no") == null ? "" : resultSet.getString("service_no"));
                accountSignService.setRate(resultSet.getFloat("rate"));
                accountSignService.setSignTime(resultSet.getString("sign_time") == null ? "" : resultSet.getString("sign_time"));
                accountSignService.setExpireTime(resultSet.getString("expire_time") == null ? "" : resultSet.getString("expire_time"));
                accountSignService.setRemark(resultSet.getString("remark") == null ? "" : resultSet.getString("remark"));
                accountSignService.setServiceName(resultSet.getString("service_name") == null ? "" : resultSet.getString("service_name"));
                accountSignService.setAccountName(resultSet.getString("account_name") == null ? "" : resultSet.getString("account_name"));
                return accountSignService;
            }
        });
        return list;
    }

    public List<AccountSignService> queryAccountAndService(AccountSignService object) {
        StringBuffer sql = new StringBuffer("SELECT  * from account_sign_service where 1=1 ");
        if (!StringUtils.isEmpty((Object)object.getServiceNo())) {
            sql.append(" and service_no = '").append(object.getServiceNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getAccountNo())) {
            sql.append(" and account_no = '").append(object.getAccountNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getId())) {
            sql.append(" and id = ").append(object.getId());
        }
        logger.info("query account_sign_service " + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new AccountSignServiceMapper());
        return list;
    }

    public int insert(AccountSignService accountSignService) {
        StringBuffer sql = new StringBuffer("INSERT INTO account_sign_service(  account_no,  service_no,  create_time,  update_time,  rate,  sign_time,  expire_time,  remark) VALUES  (   ?,   ?,    NOW(),    NOW(),    ?,    ?,    ?,    ?  ) ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{accountSignService.getAccountNo(), accountSignService.getServiceNo(), Float.valueOf(accountSignService.getRate()), accountSignService.getSignTime(), accountSignService.getExpireTime(), accountSignService.getRemark()});
        return temp;
    }

    public int delete(AccountSignService accountSignService) {
        StringBuffer sql = new StringBuffer("delete FROM account_sign_service WHERE id=? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{accountSignService.getId()});
        logger.info("deleted account_sign_service :" + sql.toString());
        return temp;
    }

    public int update(AccountSignService accountSignService) {
        StringBuffer sql = new StringBuffer("UPDATE   account_sign_service SET  update_time = NOW(),  sign_time = ?,  expire_time = ?,  remark = ?,  service_no= ?,  account_no=? WHERE id = ? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{accountSignService.getSignTime(), accountSignService.getExpireTime(), accountSignService.getRemark(), accountSignService.getServiceNo(), accountSignService.getAccountNo(), accountSignService.getId()});
        logger.info("update account_sign_service :" + sql.toString());
        return temp;
    }
}

