/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.dao;

import com.xunlei.channel.api.basechannel.entity.Account;
import com.xunlei.channel.api.basechannel.entity.AccountQueryRequest;
import com.xunlei.channel.api.basechannel.mapper.AccountMapper;
import com.xunlei.channel.api.dao.GatewayBaseDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class AccountDao
extends GatewayBaseDao<Account> {
    private static final Logger logger = LoggerFactory.getLogger(AccountDao.class);

    public List<Account> query(AccountQueryRequest object) {
        StringBuffer sql = new StringBuffer(" SELECT a.account_no,a.provider_no, a.account_name,a.cash_account, a.settlement_cycle ,a.remark ,  a.is_use,a.merchants_no as sign_body_no,b.provider_name,c.merchants_no,c.merchants_name as sign_body_name  FROM account  a  LEFT JOIN service_provider  b ON a.provider_no = b.provider_no   LEFT JOIN merchants c ON a.merchants_no = c.merchants_no where 1=1 ");
        if (!StringUtils.isEmpty((Object)object.getIsUse())) {
            sql.append(" and a.is_use='").append(object.getIsUse()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getAccountName())) {
            sql.append("and  a.account_name like'%").append(object.getAccountName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getProviderName())) {
            sql.append("and b.provider_name like '%").append(object.getProviderName()).append("%'");
        }
        if (!StringUtils.isEmpty((Object)object.getProviderNo())) {
            sql.append("and a.provider_no='").append(object.getProviderNo()).append("'");
        }
        sql.append(" ORDER BY b.provider_no");
        logger.info("query account:" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), new RowMapper(){

            public Account mapRow(ResultSet rs, int rowNum) throws SQLException {
                Account temp = new Account();
                temp.setAccountName(rs.getString("account_name"));
                temp.setProviderName(rs.getString("provider_name") == null ? "" : rs.getString("provider_name"));
                temp.setProviderNo(rs.getString("provider_no"));
                temp.setCashAccount(rs.getString("cash_account"));
                temp.setSettlementCycle(rs.getString("settlement_cycle"));
                temp.setRemark(rs.getString("remark") == null ? "" : rs.getString("remark"));
                temp.setSignBodyName(rs.getString("sign_body_name") == null ? "" : rs.getString("sign_body_name"));
                temp.setAccountNo(rs.getString("account_no"));
                temp.setSignBodyNo(rs.getString("sign_body_no"));
                temp.setIsUse(rs.getString("is_use"));
                temp.setMerchantNo(rs.getString("merchants_no"));
                return temp;
            }
        });
        return list;
    }

    public List<Account> findAccount(AccountQueryRequest object) {
        StringBuffer sql = new StringBuffer(" SELECT * FROM account   where 1=1 ");
        if (!StringUtils.isEmpty((Object)object.getProviderNo())) {
            sql.append(" and provider_no='").append(object.getProviderNo()).append("'");
        }
        if (!StringUtils.isEmpty((Object)object.getAccountName())) {
            sql.append(" and account_name='").append(object.getAccountName()).append("'");
        }
        logger.info("query account:" + sql.toString());
        List list = this.jdbcTemplate.query(sql.toString(), (RowMapper)new AccountMapper());
        return list;
    }

    public int insert(AccountQueryRequest object) {
        StringBuffer sql = new StringBuffer(" INSERT INTO account            (             account_no,             provider_no,             account_name,             cash_account,             settlement_cycle,             remark,             is_use,             deleted,             create_time,             update_time,             merchants_no)VALUES (        ?,        ?,        ?,        ?,        ?,       ?,       ?,'N',       NOW(),        NOW(),        ?)");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getAccountNo(), object.getProviderNo(), object.getAccountName(), object.getCashAccount(), object.getSettlementCycle(), object.getRemark(), object.getIsUse(), object.getSignBodyNo()});
        return temp;
    }

    public int update(AccountQueryRequest object) {
        StringBuffer sql = new StringBuffer("update account set provider_no=?, account_name = ?,is_use = ?,cash_account= ?,settlement_cycle=?,remark=?,deleted=?, update_time = now(),merchants_no=? where account_no = ? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getProviderNo(), object.getAccountName(), object.getIsUse(), object.getCashAccount(), object.getSettlementCycle(), object.getRemark(), object.getDeleted(), object.getSignBodyNo(), object.getAccountNo()});
        logger.info(sql.toString());
        return temp;
    }

    public int updateStatus(AccountQueryRequest object) {
        StringBuffer sql = new StringBuffer("update account set is_use = ? ,  update_time = now() where account_no = ? ");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getIsUse(), object.getAccountNo()});
        logger.info("\u505c\u7528\u542f\u7528\u8d26\u6237\uff1a" + sql.toString());
        return temp;
    }

    public int delete(AccountQueryRequest object) {
        StringBuffer sql = new StringBuffer("DELETE FROM account WHERE account_no = ?");
        int temp = this.jdbcTemplate.update(sql.toString(), new Object[]{object.getAccountNo()});
        logger.info("\u5220\u9664\u8d26\u6237\uff1a" + sql.toString());
        return temp;
    }
}

