/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.entity.AccountSignService;
import com.xunlei.channel.api.basechannel.entity.ChannelBusiness;
import com.xunlei.channel.api.basechannel.entity.SignService;
import com.xunlei.channel.api.basechannel.entity.SignServiceQueryRequest;
import com.xunlei.channel.api.basechannel.service.AccountService;
import com.xunlei.channel.api.basechannel.service.AccountSignServiceService;
import com.xunlei.channel.api.basechannel.service.ChannelBusinessService;
import com.xunlei.channel.api.basechannel.service.CommonService;
import com.xunlei.channel.api.basechannel.service.SignServiceService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/sign_service"}, produces={"text/html;charset=UTF-8"})
public class SignServiceController {
    private static final Logger logger = LoggerFactory.getLogger(SignServiceController.class);
    @Autowired
    private SignServiceService signServiceService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private AccountSignServiceService accountSignServiceService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ChannelBusinessService channelBusinessService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        SignServiceQueryRequest data = (SignServiceQueryRequest)JSON.parseObject((String)json, SignServiceQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        List<SignService> result = null;
        try {
            result = this.signServiceService.query(data);
            return JsonResult.getResult(result);
        }
        catch (Exception e) {
            logger.info("SignServiceController.query error!:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insert(@RequestBody String jsonStr) {
        int insert;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        SignServiceQueryRequest data = (SignServiceQueryRequest)JSON.parseObject((String)json, SignServiceQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        List<SignService> signServiceList = this.signServiceService.findSignService(data);
        if (signServiceList.size() != 0) {
            return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u670d\u52a1\u540d\u79f0\uff1a" + data.getServiceName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
        }
        String signServiceNo = this.commonService.getCommonNo(Constants.COLUMN_SERVICE_NO, Constants.TABLE_NAME_SIGN_SERVICE);
        data.setServiceNo(signServiceNo);
        try {
            insert = this.signServiceService.insert(data);
        }
        catch (Exception e) {
            logger.info("SignServiceController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", null);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/insert_sign_account"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String insertSignAccount(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        AccountSignService data = (AccountSignService)JSON.parseObject((String)json, AccountSignService.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        int insert = 0;
        try {
            List<AccountSignService> accountSignServiceList = this.accountSignServiceService.query(data);
            if (accountSignServiceList.size() > 0) {
                return JsonResult.getResult((int)1, (String)"", (String)("\u670d\u52a1:" + accountSignServiceList.get(0).getServiceName() + ",\u5df2\u7b7e\u7ea6\u8d26\u6237:" + accountSignServiceList.get(0).getAccountName()), null);
            }
            insert = this.accountSignServiceService.insert(data);
        }
        catch (Exception e) {
            logger.info("SignServiceController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", null);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String delete(@RequestBody String jsonStr) {
        int delete = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, SignServiceQueryRequest.class);
        logger.info("\u670d\u52a1\u7ba1\u7406\u5220\u9664\u63a5\u53d7\u7684\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (SignServiceQueryRequest result : list) {
                delete = this.signServiceService.delete(result);
            }
        }
        catch (Exception e) {
            logger.info("SignServiceController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (delete > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        int update = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        SignServiceQueryRequest data = (SignServiceQueryRequest)JSON.parseObject((String)json, SignServiceQueryRequest.class);
        logger.info("\u670d\u52a1\u7ba1\u7406\u66f4\u65b0\u63a5\u53d7\u7684\u5b57\u7b26\u4e32\uff1a" + json);
        try {
            boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
            if (!match) {
                return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
            }
            List<SignService> signServiceList = this.signServiceService.findSignService(data);
            if (signServiceList.size() != 0) {
                if (signServiceList.get(0).getProviderNo().equals(data.getProviderNo())) {
                    update = 1;
                } else {
                    if (!signServiceList.get(0).getServiceNo().equals(data.getServiceNo())) {
                        return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u670d\u52a1\u540d\u79f0\uff1a" + data.getServiceName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
                    }
                    update = this.signServiceService.update(data);
                }
            } else {
                update = this.signServiceService.update(data);
            }
        }
        catch (Exception e) {
            logger.info("ServiceProviderController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (update > 0) {
            return JsonResult.getResult((Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/delete_sign_account"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String delete_sign_account(@RequestBody String jsonStr) {
        int delete = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        AccountSignService signServiceQueryRequest = (AccountSignService)JSON.parseObject((String)json, AccountSignService.class);
        logger.info("\u5220\u9664\u7b7e\u7ea6\u8d26\u6237\u63a5\u53d7\u7684\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            delete = this.accountSignServiceService.delete(signServiceQueryRequest);
        }
        catch (Exception e) {
            logger.info("SignServiceController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (delete > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/update_sign_account"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update_sign_account(@RequestBody String jsonStr) {
        int update = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        AccountSignService data = (AccountSignService)JSON.parseObject((String)json, AccountSignService.class);
        logger.info("\u670d\u52a1\u7b7e\u7ea6\u8d26\u6237\u66f4\u65b0\u63a5\u53d7\u7684\u5b57\u7b26\u4e32\uff1a" + json);
        try {
            boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
            if (!match) {
                return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
            }
            List<AccountSignService> accountSignServiceList = this.accountSignServiceService.query(data);
            if (accountSignServiceList.size() != 0) {
                if (accountSignServiceList.get(0).getSignTime().equals(data.getSignTime()) && accountSignServiceList.get(0).getExpireTime().equals(data.getExpireTime()) && accountSignServiceList.get(0).getRemark().equals(data.getRemark()) && accountSignServiceList.get(0).getRate() == data.getRate()) {
                    if (accountSignServiceList.get(0).getId() != data.getId()) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u670d\u52a1:" + accountSignServiceList.get(0).getServiceName() + ",\u5df2\u7b7e\u7ea6\u8d26\u6237:" + accountSignServiceList.get(0).getAccountName()), null);
                    }
                    update = 1;
                } else {
                    if (accountSignServiceList.get(0).getId() != data.getId()) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u670d\u52a1:" + accountSignServiceList.get(0).getServiceName() + ",\u5df2\u7b7e\u7ea6\u8d26\u6237:" + accountSignServiceList.get(0).getAccountName()), null);
                    }
                    update = this.accountSignServiceService.update(data);
                }
            } else {
                AccountSignService accountSignServiceQuery = new AccountSignService();
                accountSignServiceQuery.setId(data.getId());
                List<AccountSignService> accountSignServiceList1 = this.accountSignServiceService.queryAccountAndService(accountSignServiceQuery);
                ChannelBusiness channelBusiness = new ChannelBusiness();
                channelBusiness.setAccountNo(accountSignServiceList1.get(0).getAccountNo());
                channelBusiness.setServiceNo(accountSignServiceList1.get(0).getServiceNo());
                this.channelBusinessService.deleteByNo(channelBusiness);
                update = this.accountSignServiceService.update(data);
            }
        }
        catch (Exception e) {
            logger.info("ServiceProviderController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (update > 0) {
            return JsonResult.getResult((Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((Object)ReturnResult.SYSTEM_ERROR);
    }
}

