/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.entity.ServiceProvider;
import com.xunlei.channel.api.basechannel.entity.ServiceProviderQueryRequest;
import com.xunlei.channel.api.basechannel.service.ServiceProviderService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/service_provider"}, produces={"text/html;charset=UTF-8"})
public class ServiceProviderController {
    private static final Logger logger = LoggerFactory.getLogger(ServiceProviderController.class);
    @Autowired
    ServiceProviderService serviceProviderService;
    @Autowired
    private SignUtilsService signUtilsService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ResponseBody
    private String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        ServiceProviderQueryRequest data = (ServiceProviderQueryRequest)JSON.parseObject((String)json, ServiceProviderQueryRequest.class);
        try {
            boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
            if (!match) {
                return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
            }
            List<ServiceProvider> resultList = this.serviceProviderService.query(data);
            return JsonResult.getResult(resultList);
        }
        catch (Exception e) {
            logger.info("ServiceProviderController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ResponseBody
    private String insert(@RequestBody String jsonStr) {
        int insert;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        logger.info("\u670d\u52a1\u5546\u65b0\u589e\u63a5\u53d7\u7684\u8bf7\u6c42\u53c2\u6570\uff1a" + json);
        ServiceProviderQueryRequest data = (ServiceProviderQueryRequest)JSON.parseObject((String)json, ServiceProviderQueryRequest.class);
        try {
            boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
            if (!match) {
                return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
            }
            ServiceProviderQueryRequest serviceProviderQueryByName = new ServiceProviderQueryRequest();
            serviceProviderQueryByName.setProviderName(data.getProviderName());
            List<ServiceProvider> serviceProviderListByName = this.serviceProviderService.findServiceProvider(serviceProviderQueryByName);
            if (serviceProviderListByName.size() > 0) {
                return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u670d\u52a1\u5546\u540d\u79f0\u7b80\u79f0\uff1a" + data.getProviderName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
            }
            ServiceProviderQueryRequest serviceProviderQueryByFullName = new ServiceProviderQueryRequest();
            serviceProviderQueryByFullName.setProviderFullName(data.getProviderFullName());
            List<ServiceProvider> serviceProviderListByFullName = this.serviceProviderService.findServiceProvider(serviceProviderQueryByFullName);
            if (serviceProviderListByFullName.size() > 0) {
                return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u670d\u52a1\u5546\u540d\u79f0\u5168\u79f0\uff1a" + data.getProviderFullName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
            }
            List<ServiceProvider> serviceProviders = this.serviceProviderService.findServiceProvider(data);
            if (serviceProviders.size() != 0) {
                if (serviceProviders.get(0).getProviderName().equals(data.getProviderName())) {
                    return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u670d\u52a1\u5546\u540d\u79f0\u7b80\u79f0\uff1a" + data.getProviderName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
                }
                if (serviceProviders.get(0).getProviderFullName().equals(data.getProviderFullName())) {
                    return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u670d\u52a1\u5546\u540d\u79f0\u5168\u79f0\uff1a" + data.getProviderFullName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
                }
            }
            insert = this.serviceProviderService.insert(data);
        }
        catch (Exception e) {
            logger.info("ServiceProviderController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"}, consumes={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        int update = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        logger.info("\u670d\u52a1\u5546\u4fee\u6539\u63a5\u53d7\u7684\u8bf7\u6c42\u53c2\u6570\uff1a" + json);
        ServiceProviderQueryRequest data = (ServiceProviderQueryRequest)JSON.parseObject((String)json, ServiceProviderQueryRequest.class);
        try {
            boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
            if (!match) {
                return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
            }
            if (data.getProviderName().length() > 30 && data.getRemark().length() > 512) {
                return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.MORE_THEN_SET_LENGTH.getMessage(), (String)ReturnResult.MORE_THEN_SET_LENGTH.getDescribe(), null);
            }
            List<ServiceProvider> serviceProviders = this.serviceProviderService.findServiceProvider(data);
            if (serviceProviders.size() != 0) {
                if (serviceProviders.get(0).getRemark().equals(data.getRemark())) {
                    if (!serviceProviders.get(0).getProviderNo().equals(data.getProviderNo())) {
                        return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u670d\u52a1\u5546\u540d\u79f0\u7b80\u79f0\uff1a" + data.getProviderName() + "\u670d\u52a1\u5546\u5168\u79f0\uff1a" + data.getProviderFullName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
                    }
                    update = 1;
                } else {
                    if (!serviceProviders.get(0).getProviderNo().equals(data.getProviderNo())) {
                        return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u670d\u52a1\u5546\u540d\u79f0\u7b80\u79f0\uff1a" + data.getProviderName() + "\u670d\u52a1\u5546\u5168\u79f0\uff1a" + data.getProviderFullName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
                    }
                    update = this.serviceProviderService.update(data);
                }
            } else {
                ServiceProviderQueryRequest queryByName = new ServiceProviderQueryRequest();
                queryByName.setProviderName(data.getProviderName());
                List<ServiceProvider> listByName = this.serviceProviderService.findServiceProvider(queryByName);
                ServiceProviderQueryRequest queryByFullName = new ServiceProviderQueryRequest();
                queryByFullName.setProviderFullName(data.getProviderFullName());
                List<ServiceProvider> listByFullName = this.serviceProviderService.findServiceProvider(queryByFullName);
                if (listByName.size() > 0 && listByFullName.size() > 0) {
                    if (listByName.get(0).getProviderNo().equals(data.getProviderNo()) && !listByFullName.get(0).getProviderNo().equals(data.getProviderNo())) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u670d\u52a1\u5546\u5168\u79f0\uff1a " + data.getProviderFullName() + "\u5df2\u5b58\u5728"), (Object)"");
                    }
                    if (listByFullName.get(0).getProviderNo().equals(data.getProviderNo()) && !listByName.get(0).getProviderNo().equals(data.getProviderNo())) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u670d\u52a1\u5546\u7b80\u79f0\uff1a " + data.getProviderName() + "\u5df2\u5b58\u5728"), (Object)"");
                    }
                    return JsonResult.getResult((int)1, (String)"", (String)("\u670d\u52a1\u5546\u5168\u79f0\uff1a " + data.getProviderFullName() + ",\u670d\u52a1\u5546\u7b80\u79f0\uff1a " + data.getProviderName() + "\u5df2\u5b58\u5728"), (Object)"");
                }
                if (listByFullName.size() > 0 && !listByFullName.get(0).getProviderNo().equals(data.getProviderNo()) && listByName.size() == 0) {
                    return JsonResult.getResult((int)1, (String)"", (String)("\u670d\u52a1\u5546\u5168\u79f0\uff1a " + data.getProviderFullName() + "\u5df2\u5b58\u5728"), (Object)"");
                }
                if (listByName.size() > 0 && !listByName.get(0).getProviderNo().equals(data.getProviderNo()) && listByFullName.size() == 0) {
                    return JsonResult.getResult((int)1, (String)"", (String)("\u670d\u52a1\u5546\u7b80\u79f0\uff1a " + data.getProviderName() + "\u5df2\u5b58\u5728"), (Object)"");
                }
                update = this.serviceProviderService.update(data);
            }
            update = this.serviceProviderService.update(data);
            if (update > 0) {
                return JsonResult.getResult((Object)ReturnResult.SUCCESS);
            }
            return JsonResult.getResult((Object)ReturnResult.SYSTEM_ERROR);
        }
        catch (Exception e) {
            logger.info("ServiceProviderController.update  error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String delete(@RequestBody String jsonStr) {
        int delete = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, ServiceProviderQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (ServiceProviderQueryRequest result : list) {
                delete = this.serviceProviderService.delete(result);
            }
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (delete > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }
}

