/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.entity.RefundOrderRecordQueryRequest;
import com.xunlei.channel.api.basechannel.jdbc.PageParam;
import com.xunlei.channel.api.basechannel.service.RefundOrderRecordService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/refund_record"}, produces={"text/html;charset=UTF-8"})
public class RefundOrderRecordController {
    private static final Logger logger = LoggerFactory.getLogger(RefundOrderRecordController.class);
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private RefundOrderRecordService refundOrderRecordService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        String pageJson = jsonObject.getString("page");
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        RefundOrderRecordQueryRequest data = (RefundOrderRecordQueryRequest)JSON.parseObject((String)json, RefundOrderRecordQueryRequest.class);
        PageParam pageParam = (PageParam)JSON.parseObject((String)pageJson, PageParam.class);
        try {
            Map<String, Object> resultMap = this.refundOrderRecordService.query(data, pageParam);
            return JsonResult.getResult(resultMap);
        }
        catch (Exception e) {
            logger.info("PayOrderController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String insert(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        logger.info("\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55\u63a5\u53e3\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        RefundOrderRecordQueryRequest refundOrderRecordQueryRequest = (RefundOrderRecordQueryRequest)JSON.parseObject((String)json, RefundOrderRecordQueryRequest.class);
        int insert = 0;
        try {
            insert = this.refundOrderRecordService.insert(refundOrderRecordQueryRequest);
        }
        catch (Exception e) {
            logger.info("RefundOrderRecordController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)"\u65b0\u589e\u6210\u529f");
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        logger.info("\u65b0\u589e\u9000\u6b3e\u8bb0\u5f55\u66f4\u65b0\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        RefundOrderRecordQueryRequest refundOrderRecordQueryRequest = (RefundOrderRecordQueryRequest)JSON.parseObject((String)json, RefundOrderRecordQueryRequest.class);
        int update = 0;
        try {
            update = this.refundOrderRecordService.update(refundOrderRecordQueryRequest);
        }
        catch (Exception e) {
            logger.info("RefundOrderRecordController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (update > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)"\u65b0\u589e\u6210\u529f");
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }
}

