/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.entity.ChannelLabel;
import com.xunlei.channel.api.basechannel.entity.ChannelLabelQueryRequery;
import com.xunlei.channel.api.basechannel.entity.PayLabQueryRequest;
import com.xunlei.channel.api.basechannel.entity.PayLabel;
import com.xunlei.channel.api.basechannel.service.ChannelLabelService;
import com.xunlei.channel.api.basechannel.service.CommonService;
import com.xunlei.channel.api.basechannel.service.PayLabService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/pay_label"}, produces={"text/html;charset=UTF-8"})
public class PaylabController {
    private static final Logger logger = LoggerFactory.getLogger(PaylabController.class);
    @Autowired
    private PayLabService payLabService;
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private ChannelLabelService channelLabelService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        PayLabQueryRequest payLabQueryRequest = (PayLabQueryRequest)JSON.parseObject((String)json, PayLabQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<PayLabel> result = this.payLabService.query(payLabQueryRequest);
            return JsonResult.getResult(result);
        }
        catch (Exception e) {
            logger.info("PaylabController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String insert(@RequestBody String jsonStr) {
        int insert = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        PayLabQueryRequest payLabQueryRequest = (PayLabQueryRequest)JSON.parseObject((String)json, PayLabQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            PayLabQueryRequest payLabQuery = new PayLabQueryRequest();
            payLabQuery.setLabelName(payLabQueryRequest.getLabelName());
            List<PayLabel> payLabelList = this.payLabService.queryLabel(payLabQuery);
            if (payLabelList.size() > 0) {
                return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u652f\u4ed8\u5206\u7c7b\u6807\u7b7e\uff1a" + payLabQueryRequest.getLabelName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
            }
            String labelNO = this.commonService.getCommonNo(Constants.COLUMN_PAY_LABEL_NO, Constants.TABLE_NAME_PAY_LABEL);
            payLabQueryRequest.setLabelNo(labelNO);
            insert = this.payLabService.insert(payLabQueryRequest);
        }
        catch (Exception e) {
            logger.info("PaylabController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", null);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/connect_channel"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String connect_channel(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        logger.info("\u6807\u7b7e\u63a5\u5165\u6e20\u9053\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a{}", (Object)json);
        ChannelLabelQueryRequery payLabQueryRequest = (ChannelLabelQueryRequery)JSON.parseObject((String)json, ChannelLabelQueryRequery.class);
        String labelNo = payLabQueryRequest.getLabelNo();
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            ChannelLabel channelLabeldel = new ChannelLabel();
            channelLabeldel.setLabelNo(labelNo);
            this.channelLabelService.delete(channelLabeldel);
            if (!StringUtils.isEmpty((Object)payLabQueryRequest.getChannelNo())) {
                String[] channelArr;
                for (String channelNo : channelArr = payLabQueryRequest.getChannelNo().split(",")) {
                    ChannelLabelQueryRequery channelLabel = new ChannelLabelQueryRequery();
                    channelLabel.setLabelNo(labelNo);
                    channelLabel.setChannelNo(channelNo);
                    channelLabel.setIsUse("Y");
                    this.channelLabelService.insert(channelLabel);
                }
            }
            return JsonResult.getResult((int)0, (String)"", (String)"", null);
        }
        catch (Exception e) {
            logger.info("PaylabController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        int update = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        PayLabQueryRequest payLabQueryRequest = (PayLabQueryRequest)JSON.parseObject((String)json, PayLabQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<PayLabel> payLabelList = this.payLabService.queryLabel(payLabQueryRequest);
            if (payLabelList.size() != 0) {
                if (payLabelList.get(0).getLabelShowNo().equals(payLabQueryRequest.getLabelShowNo())) {
                    if (!payLabelList.get(0).getLabelNo().equals(payLabQueryRequest.getLabelNo())) {
                        return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u652f\u4ed8\u5206\u7c7b\u6807\u7b7e\uff1a" + payLabQueryRequest.getLabelName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
                    }
                    update = 1;
                } else {
                    if (!payLabelList.get(0).getLabelNo().equals(payLabQueryRequest.getLabelNo())) {
                        return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u652f\u4ed8\u5206\u7c7b\u6807\u7b7e\uff1a" + payLabQueryRequest.getLabelName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
                    }
                    update = this.payLabService.update(payLabQueryRequest);
                }
            } else {
                update = this.payLabService.update(payLabQueryRequest);
            }
        }
        catch (Exception e) {
            logger.info("PaylabController.update error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (update > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", null);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/not_connect_channel"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String delete(@RequestBody String jsonStr) {
        int delete = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, PayLabQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (PayLabQueryRequest result : list) {
                delete = this.payLabService.delete(result);
            }
        }
        catch (Exception e) {
            logger.info("PaylabelController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (delete > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }
}

