/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.entity.PayOrderQueryRequest;
import com.xunlei.channel.api.basechannel.jdbc.PageParam;
import com.xunlei.channel.api.basechannel.service.PayOrderService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/payorder"}, produces={"text/html;charset=UTF-8"})
public class PayOrderController {
    private static final Logger logger = LoggerFactory.getLogger(PayOrderController.class);
    @Autowired
    private PayOrderService payOrderService;
    @Autowired
    private SignUtilsService signUtilsService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        String pageJson = jsonObject.getString("page");
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        PayOrderQueryRequest data = (PayOrderQueryRequest)JSON.parseObject((String)json, PayOrderQueryRequest.class);
        PageParam pageParam = (PageParam)JSON.parseObject((String)pageJson, PageParam.class);
        try {
            Map<String, Object> resultMap = this.payOrderService.query(data, pageParam);
            return JsonResult.getResult(resultMap);
        }
        catch (Exception e) {
            logger.info("PayOrderController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }
}

