/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.google.common.collect.Sets;
import com.xunlei.channel.api.base.sign.dao.BizInfoDao;
import com.xunlei.channel.api.basechannel.entity.OneThingCoinTransferRetryRequest;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpayBiz;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpayOrderPocketRequest;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpayOrderQueryRequest;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpaySelectBizItem;
import com.xunlei.channel.api.basechannel.entity.OnethingcoinpayTransferOrderQueryRequest;
import com.xunlei.channel.api.basechannel.jdbc.Pagination;
import com.xunlei.channel.api.basechannel.service.OnethingcoinpayService;
import com.xunlei.channel.api.basechannel.utils.CommonUtils;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.util.DateUtils;
import com.xunlei.channel.api.util.http.HttpUtils;
import com.xunlei.channel.api.util.sign.SignUtils;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@EnableWebMvc
@RestController
@RequestMapping(value={"/onethingcoinpay"})
public class OnethingcoinpayController {
    private static final Logger logger = LoggerFactory.getLogger(OnethingcoinpayController.class);
    @Autowired
    private OnethingcoinpayService onethingcoinpayService;
    @Autowired
    private BizInfoDao bizInfoDao;
    private static final String retryUrl = "http://proxy.pay.xunlei.com/oneThingCoinTransferRetry";
    private static final String VERSION = "v1.0";
    SimplePropertyPreFilter filter = new SimplePropertyPreFilter(Pagination.class, new String[]{"totalRows", "totalPages", "result"});

    @ApiOperation(value="\u67e5\u8be2\u94fe\u514b\u652f\u4ed8\u8ba2\u5355")
    @GetMapping(value={"/queryOnethingCoinPayOrder"}, produces={"application/json;charset=UTF-8"})
    public JsonResult queryOnethingCoinPayOrder(OnethingcoinpayOrderQueryRequest onethingcoinpayOrderQueryRequest) {
        logger.info("\u94fe\u514b\u8ba2\u5355\u67e5\u8be2\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + onethingcoinpayOrderQueryRequest.toString());
        String beginTime = onethingcoinpayOrderQueryRequest.getBeginTime();
        String endTime = onethingcoinpayOrderQueryRequest.getEndTime();
        Date beginTimeDate = DateUtils.formatDateStringToDate((String)beginTime, (String)"yyyy-MM-dd");
        Date endTimeDate = DateUtils.formatDateStringToDate((String)endTime, (String)"yyyy-MM-dd");
        if (StringUtils.isEmpty((Object)beginTime.trim()) || StringUtils.isEmpty((Object)endTime.trim())) {
            return JsonResult.paramError();
        }
        if (beginTimeDate.getTime() > endTimeDate.getTime()) {
            return JsonResult.beginTimeOverEndTime();
        }
        String beginTimeStr = DateUtils.getDateFormat((Date)beginTimeDate, (String)"yyyy-MM-dd");
        logger.info("beginTimeStr:" + beginTimeStr);
        String endTimeStr = DateUtils.getDateFormat((Date)endTimeDate, (String)"yyyy-MM-dd");
        logger.info("endTimeStr:" + endTimeStr);
        onethingcoinpayOrderQueryRequest.setBeginTime(beginTimeStr);
        onethingcoinpayOrderQueryRequest.setEndTime(endTimeStr);
        try {
            Pagination extOneThingCoinPayOks = this.onethingcoinpayService.queryOnethingcoinpayOrder(onethingcoinpayOrderQueryRequest);
            String result = JSONObject.toJSONString((Object)((Object)extOneThingCoinPayOks), (SerializeFilter)this.filter, (SerializerFeature[])new SerializerFeature[0]);
            Object object = JSON.parse((String)result);
            return JsonResult.success((Object)object);
        }
        catch (Exception e) {
            logger.info("queryOnethingCoinPayOrder error :{}", (Object)e.getMessage());
            return JsonResult.fail();
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u94fe\u514b\u8f6c\u8d26\u8ba2\u5355")
    @GetMapping(value={"/queryOnethingCoinPayTransferOrder"}, produces={"application/json;charset=UTF-8"})
    public JsonResult queryOnethingCoinPayTransferOrder(OnethingcoinpayTransferOrderQueryRequest onethingcoinpayTransferOrderQueryRequest) {
        logger.info("\u94fe\u514b\u8f6c\u8d26\u8ba2\u5355\u67e5\u8be2\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + onethingcoinpayTransferOrderQueryRequest.toString() + "");
        String beginTime = onethingcoinpayTransferOrderQueryRequest.getBeginTime();
        String endTime = onethingcoinpayTransferOrderQueryRequest.getEndTime();
        Date beginTimeDate = DateUtils.formatDateStringToDate((String)beginTime, (String)"yyyy-MM-dd");
        Date endTimeDate = DateUtils.formatDateStringToDate((String)endTime, (String)"yyyy-MM-dd");
        if (StringUtils.isEmpty((Object)beginTime.trim()) || StringUtils.isEmpty((Object)endTime.trim())) {
            return JsonResult.paramError();
        }
        if (beginTimeDate.getTime() > endTimeDate.getTime()) {
            return JsonResult.beginTimeOverEndTime();
        }
        String beginTimeStr = DateUtils.getDateFormat((Date)beginTimeDate, (String)"yyyy-MM-dd");
        logger.info("beginTimeStr:" + beginTimeStr);
        String endTimeStr = DateUtils.getDateFormat((Date)endTimeDate, (String)"yyyy-MM-dd");
        logger.info("endTimeStr:" + endTimeStr);
        onethingcoinpayTransferOrderQueryRequest.setBeginTime(beginTimeStr);
        onethingcoinpayTransferOrderQueryRequest.setEndTime(endTimeStr);
        try {
            Pagination extOneThingCoinPayOks = this.onethingcoinpayService.queryOnethingcoinpayTransferOrder(onethingcoinpayTransferOrderQueryRequest);
            String result = JSONObject.toJSONString((Object)((Object)extOneThingCoinPayOks), (SerializeFilter)this.filter, (SerializerFeature[])new SerializerFeature[0]);
            Object object = JSON.parse((String)result);
            return JsonResult.success((Object)object);
        }
        catch (Exception e) {
            logger.info("queryOnethingCoinPayOrder error :{}", (Object)e.getMessage());
            return JsonResult.fail();
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u94fe\u514b\u4e1a\u52a1\u8d26\u53f7")
    @GetMapping(value={"/queryOnethingCoinPayBiz"}, produces={"application/json;charset=UTF-8"})
    public JsonResult queryOnethingCoinPayBiz() {
        try {
            List<OnethingcoinpayBiz> onethingcoinpayBizList = this.onethingcoinpayService.query();
            if (onethingcoinpayBizList == null) {
                return JsonResult.noOrderFound();
            }
            return JsonResult.success(onethingcoinpayBizList);
        }
        catch (Exception e) {
            logger.info("queryOnethingCoinPayBiz error :{}", (Object)e.getMessage());
            return JsonResult.fail();
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u94fe\u514b\u4e1a\u52a1")
    @GetMapping(value={"/queryOnethingCoinPaySelectBizItem"}, produces={"application/json;charset=UTF-8"})
    public JsonResult queryOnethingCoinPaySelectBizItem() {
        try {
            List<OnethingcoinpaySelectBizItem> onethingcoinpayBizList = this.onethingcoinpayService.querySelectItem();
            if (onethingcoinpayBizList == null) {
                return JsonResult.noOrderFound();
            }
            return JsonResult.success(onethingcoinpayBizList);
        }
        catch (Exception e) {
            logger.info("queryOnethingCoinPaySelectBizItem error :{}", (Object)e.getMessage());
            return JsonResult.fail();
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u94fe\u514b\u53e3\u888b\u660e\u7ec6")
    @GetMapping(value={"/queryOnethingCoinPayOrderPocket"}, produces={"application/json;charset=UTF-8"})
    public JsonResult queryOnethingCoinPayOrderPocket(OnethingcoinpayOrderPocketRequest onethingcoinpayOrderPocketRequest) {
        logger.info("\u94fe\u514b\u8f6c\u8d26\u8ba2\u5355\u67e5\u8be2\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + onethingcoinpayOrderPocketRequest.toString());
        String beginTime = onethingcoinpayOrderPocketRequest.getBeginTime();
        String endTime = onethingcoinpayOrderPocketRequest.getEndTime();
        Date beginTimeDate = DateUtils.formatDateStringToDate((String)beginTime, (String)"yyyy-MM-dd");
        Date endTimeDate = DateUtils.formatDateStringToDate((String)endTime, (String)"yyyy-MM-dd");
        if (StringUtils.isEmpty((Object)beginTime.trim()) || StringUtils.isEmpty((Object)endTime.trim()) || StringUtils.isEmpty((Object)onethingcoinpayOrderPocketRequest.getAccount())) {
            return JsonResult.paramError();
        }
        if (beginTimeDate.getTime() > endTimeDate.getTime()) {
            return JsonResult.beginTimeOverEndTime();
        }
        String beginTimeStr = DateUtils.getDateFormat((Date)beginTimeDate, (String)"yyyy-MM-dd");
        logger.info("beginTimeStr:" + beginTimeStr);
        String endTimeStr = DateUtils.getDateFormat((Date)endTimeDate, (String)"yyyy-MM-dd");
        logger.info("endTimeStr:" + endTimeStr);
        onethingcoinpayOrderPocketRequest.setBeginTime(beginTimeStr);
        onethingcoinpayOrderPocketRequest.setEndTime(endTimeStr);
        try {
            Pagination extOneThingCoinPayPockets = this.onethingcoinpayService.queryOnethingcoinpayOrderPocket(onethingcoinpayOrderPocketRequest);
            String result = JSONObject.toJSONString((Object)((Object)extOneThingCoinPayPockets), (SerializeFilter)this.filter, (SerializerFeature[])new SerializerFeature[0]);
            Object object = JSON.parse((String)result);
            return JsonResult.success((Object)object);
        }
        catch (Exception e) {
            logger.info("queryOnethingCoinPayOrder error :{}", (Object)e.getMessage());
            return JsonResult.fail();
        }
    }

    @ApiModelProperty(value="\u94fe\u514b\u8f6c\u8d26\u91cd\u8bd5")
    @GetMapping(value={"/oneThingCoinTransferRetry"}, produces={"application/json;charset=UTF-8"})
    public JsonResult oneThingCoinTransferRetry(OneThingCoinTransferRetryRequest oneThingCoinTransferRetryRequest) {
        Map<Object, Object> map = new HashMap();
        map = CommonUtils.convertObjectToMap(oneThingCoinTransferRetryRequest);
        try {
            String bizKey = this.bizInfoDao.findBizKey(oneThingCoinTransferRetryRequest.getBizNo());
            String signed = SignUtils.sign(map, (Set)Sets.newHashSet((Object[])new String[]{"signMsg"}), (String)bizKey, (String)"UTF-8", (boolean)true);
            logger.info("oneThingCoinTransferRetry sign{}", (Object)signed);
            oneThingCoinTransferRetryRequest.setSignMsg(signed);
            oneThingCoinTransferRetryRequest.setVersion(VERSION);
            String parms = CommonUtils.createParam(oneThingCoinTransferRetryRequest);
            logger.info("oneThingCoinTransferRetry parms:{}", (Object)parms);
            String response = HttpUtils.post((String)retryUrl, (String)parms, (String)"UTF-8", (int)6000);
            logger.info(" oneThingCoinTransferRetry reponse:{}", (Object)response);
            return JsonResult.success((Object)response);
        }
        catch (Exception e) {
            logger.info("queryOnethingCoinPayOrder error :{}", (Object)e.getMessage());
            return JsonResult.fail();
        }
    }
}

