/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.entity.NoticeManager;
import com.xunlei.channel.api.basechannel.entity.NoticeManagerQueryRequest;
import com.xunlei.channel.api.basechannel.service.CommonService;
import com.xunlei.channel.api.basechannel.service.NoticeManagerService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/notice_manager"}, produces={"text/html;charset=UTF-8"})
public class NoticeManagerController {
    private static final Logger logger = LoggerFactory.getLogger(NoticeManagerController.class);
    @Autowired
    private CommonService commonService;
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private NoticeManagerService noticeManagerService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        NoticeManagerQueryRequest data = (NoticeManagerQueryRequest)JSON.parseObject((String)json, NoticeManagerQueryRequest.class);
        logger.info("\u901a\u77e5\u67e5\u8be2\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<NoticeManager> result = this.noticeManagerService.query(data);
            return JsonResult.getResult(result);
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String insert(@RequestBody String jsonStr) {
        int insert;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        NoticeManagerQueryRequest data = (NoticeManagerQueryRequest)JSON.parseObject((String)json, NoticeManagerQueryRequest.class);
        logger.info("\u901a\u77e5\u65b0\u589e\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            String noticeNo = this.commonService.getCommonNo(Constants.COLUMN_ACCOUINT_NO, Constants.TABLE_NAME_ACCOUNT);
            data.setNoticeNo(noticeNo);
            insert = this.noticeManagerService.insert(data);
        }
        catch (Exception e) {
            logger.info("AccountController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)"\u65b0\u589e\u6210\u529f");
        }
        return JsonResult.getResult((int)1, (String)"", (String)ReturnResult.SYSTEM_ERROR.getMessage(), (Object)ReturnResult.SYSTEM_ERROR);
    }
}

