/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.entity.ContactResultQueryRequest;
import com.xunlei.channel.api.basechannel.jdbc.PageParam;
import com.xunlei.channel.api.basechannel.service.ContactResultService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/contact_result"}, produces={"text/html;charset=UTF-8"})
public class ContactResultController {
    private static final Logger logger = LoggerFactory.getLogger(ContactResultController.class);
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private ContactResultService contractResultService;

    @RequestMapping(value={"/query_contact_order"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String query_contact_order(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        String pageJson = jsonObject.getString("page");
        logger.info("\u7b7e\u7ea6\u7ba1\u7406\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        ContactResultQueryRequest data = (ContactResultQueryRequest)JSON.parseObject((String)json, ContactResultQueryRequest.class);
        PageParam pageParam = (PageParam)JSON.parseObject((String)pageJson, PageParam.class);
        try {
            Map<String, Object> resultMap = this.contractResultService.query_contact_order_result(data, pageParam);
            return JsonResult.getResult(resultMap);
        }
        catch (Exception e) {
            logger.info("ContractResultController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/query_quit_contact_order"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String query_quit_contact_order(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        String pageJson = jsonObject.getString("page");
        logger.info("\u89e3\u7ea6\u5173\u7cfb\u7ba1\u7406\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        ContactResultQueryRequest data = (ContactResultQueryRequest)JSON.parseObject((String)json, ContactResultQueryRequest.class);
        PageParam pageParam = (PageParam)JSON.parseObject((String)pageJson, PageParam.class);
        try {
            Map<String, Object> resultMap = this.contractResultService.query_quit_contact_order_result(data, pageParam);
            return JsonResult.getResult(resultMap);
        }
        catch (Exception e) {
            logger.info("ContractResultController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }
}

