/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.entity.ChannelLabelQueryRequery;
import com.xunlei.channel.api.basechannel.service.ChannelLabelService;
import com.xunlei.channel.api.basechannel.service.CommonService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/channel_label"}, produces={"text/html;charset=UTF-8"})
public class ChannelLabelController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelLabelController.class);
    @Autowired
    private ChannelLabelService channelLabelService;
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private CommonService commonService;

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String insert(@RequestBody String jsonStr) {
        int insert;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        ChannelLabelQueryRequery data = (ChannelLabelQueryRequery)JSON.parseObject((String)json, ChannelLabelQueryRequery.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            insert = this.channelLabelService.insert(data);
        }
        catch (Exception e) {
            logger.info("AccountController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)"\u65b0\u589e\u6210\u529f");
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }
}

