/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.entity.Channel;
import com.xunlei.channel.api.basechannel.entity.ChannelBusiness;
import com.xunlei.channel.api.basechannel.entity.ChannelLabel;
import com.xunlei.channel.api.basechannel.entity.ChannelLabelQueryRequery;
import com.xunlei.channel.api.basechannel.entity.ChannelQueryRequest;
import com.xunlei.channel.api.basechannel.service.AccountCacheService;
import com.xunlei.channel.api.basechannel.service.ChannelBusinessService;
import com.xunlei.channel.api.basechannel.service.ChannelLabelService;
import com.xunlei.channel.api.basechannel.service.ChannelService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.basechannel.utils.ChannelBusinessMapperUtil;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/channel"}, produces={"text/html;charset=UTF-8"})
public class ChannelController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelController.class);
    @Autowired
    private ChannelService channelService;
    @Autowired
    private ChannelLabelService channelLabelService;
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private ChannelBusinessService channelBusinessService;
    @Autowired
    private AccountCacheService accountCacheService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        ChannelQueryRequest data = (ChannelQueryRequest)JSON.parseObject((String)json, ChannelQueryRequest.class);
        logger.info("\u6e20\u9053\u67e5\u8be2\u5b57\u7b26\u4e32:" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<Channel> result = this.channelService.query(data);
            return JsonResult.getResult(result);
        }
        catch (Exception e) {
            logger.info("AccountController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String insert(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        ChannelQueryRequest data = (ChannelQueryRequest)JSON.parseObject((String)json, ChannelQueryRequest.class);
        String channelNo = data.getChannelNo();
        String serviceNo = data.getServiceNo();
        logger.info("\u6e20\u9053\u67e5\u8be2\u65b0\u589e\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        int insert = 0;
        int insertLabel = 0;
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<Channel> channelList = this.channelService.queryChannel(data);
            if (channelList.size() > 0) {
                return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u6e20\u9053\u540d\u79f0\uff1a" + data.getChannelName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
            }
            List<Channel> listByName = this.channelService.queryChannelByName(data);
            List<Channel> listByChannelNo = this.channelService.queryChannelByNo(data);
            if (listByName.size() > 0 && listByChannelNo.size() > 0) {
                return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u540d\u79f0\uff1a " + data.getChannelName() + ",\u6e20\u9053\u7f16\u7801\uff1a " + data.getChannelNo() + "\u5df2\u5b58\u5728"), (Object)"");
            }
            if (listByName.size() > 0 && listByChannelNo.size() == 0) {
                return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u540d\u79f0\uff1a " + data.getChannelName() + "\u5df2\u5b58\u5728"), (Object)"");
            }
            if (listByChannelNo.size() > 0 && listByName.size() == 0) {
                return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u7f16\u7801\uff1a " + data.getChannelNo() + "\u5df2\u5b58\u5728"), (Object)"");
            }
            insert = this.channelService.insert(data);
            if (null != data.getLabelNo()) {
                for (String labelNo : data.getLabelNo().split(",")) {
                    ChannelLabelQueryRequery channelLabel = new ChannelLabelQueryRequery();
                    channelLabel.setChannelNo(channelNo);
                    channelLabel.setLabelNo(labelNo);
                    channelLabel.setIsUse("Y");
                    insertLabel = this.channelLabelService.insert(channelLabel);
                }
            }
        }
        catch (Exception e) {
            logger.info("ChannelController.insert error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0 && insertLabel > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)"\u65b0\u589e\u6210\u529f");
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String delete(@RequestBody String jsonStr) {
        int delete = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, ChannelQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (ChannelQueryRequest result : list) {
                delete = this.channelService.delete(result);
                if (null == result.getLabelNo()) continue;
                ChannelLabel channelLabelDel = new ChannelLabel();
                channelLabelDel.setLabelNo(result.getLabelNo());
                this.channelLabelService.delete(channelLabelDel);
            }
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (delete > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        int update;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        logger.info("\u6e20\u9053\u4fee\u6539\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        ChannelQueryRequest data = (ChannelQueryRequest)JSON.parseObject((String)json, ChannelQueryRequest.class);
        String channelNo = data.getChannelNo();
        String serviceNo = data.getServiceNo();
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<Channel> channelList = this.channelService.queryChannel(data);
            if (channelList.size() != 0) {
                if (channelList.get(0).getRemark().equals(data.getRemark()) && channelList.get(0).getInUse().equals(data.getInUse()) && channelList.get(0).getServiceNo().equals(data.getServiceNo()) && channelList.get(0).getLabelNo().equals(data.getLabelNo()) && channelList.get(0).getType().equals(data.getType())) {
                    if (channelList.get(0).getId() != data.getId()) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u540d\u79f0\uff1a " + data.getChannelName() + ",\u6e20\u9053\u7f16\u7801\uff1a " + data.getChannelNo() + "\u5df2\u5b58\u5728"), (Object)"");
                    }
                    update = 1;
                } else {
                    if (channelList.get(0).getId() != data.getId()) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u540d\u79f0\uff1a " + data.getChannelName() + ",\u6e20\u9053\u7f16\u7801\uff1a " + data.getChannelNo() + "\u5df2\u5b58\u5728"), (Object)"");
                    }
                    update = this.channelService.update(data);
                }
            } else {
                List<Channel> listByName = this.channelService.queryChannelByName(data);
                List<Channel> listByChannelNo = this.channelService.queryChannelByNo(data);
                if (listByName.size() > 0 && listByChannelNo.size() > 0) {
                    if (listByName.get(0).getId() == data.getId() && listByChannelNo.get(0).getId() != data.getId()) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u7f16\u7801\uff1a " + data.getChannelNo() + "\u5df2\u5b58\u5728"), (Object)"");
                    }
                    if (listByChannelNo.get(0).getId() == data.getId() && listByName.get(0).getId() != listByChannelNo.get(0).getId()) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u540d\u79f0\uff1a " + data.getChannelName() + "\u5df2\u5b58\u5728"), (Object)"");
                    }
                    return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u540d\u79f0\uff1a " + data.getChannelName() + ",\u6e20\u9053\u7f16\u7801\uff1a " + data.getChannelNo() + "\u5df2\u5b58\u5728"), (Object)"");
                }
                if (listByName.size() > 0 && listByName.get(0).getChannelNo().equals(data.getChannelNo()) && listByChannelNo.size() == 0) {
                    return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u540d\u79f0\uff1a " + data.getChannelName() + "\u5df2\u5b58\u5728"), (Object)"");
                }
                if (listByChannelNo.size() > 0 && listByChannelNo.get(0).getChannelName().equals(data.getChannelName()) && listByName.size() == 0) {
                    return JsonResult.getResult((int)1, (String)"", (String)("\u6e20\u9053\u7f16\u7801\uff1a " + data.getChannelNo() + "\u5df2\u5b58\u5728"), (Object)"");
                }
                update = this.channelService.update(data);
            }
        }
        catch (Exception e) {
            logger.info("ChannelController.update error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (update > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/is_use"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String isuse(@RequestBody String jsonStr) {
        int update = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List data = JSON.parseArray((String)json, ChannelQueryRequest.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (ChannelQueryRequest channelQueryRequest : data) {
                List<ChannelBusiness> channelBusinessList;
                ChannelBusiness bizQuery = new ChannelBusiness();
                bizQuery.setChannelNo(channelQueryRequest.getChannelNo());
                if (channelQueryRequest.getInUse().equals("N")) {
                    channelBusinessList = this.channelBusinessService.queryByNo(bizQuery);
                    if (channelBusinessList.size() > 0) {
                        bizQuery.setChannelStatus("N");
                        this.channelBusinessService.updateStatus(bizQuery);
                    }
                } else {
                    bizQuery.setChannelStatus("N");
                    channelBusinessList = this.channelBusinessService.queryByNo(bizQuery);
                    if (channelBusinessList.size() > 0) {
                        for (ChannelBusiness channelBusiness : channelBusinessList) {
                            channelBusiness.setChannelStatus("Y");
                            this.channelBusinessService.updateStatus(channelBusiness);
                        }
                    }
                }
                update = this.channelService.isInUse(channelQueryRequest);
            }
            List<String> channelNos = data.stream().map(ChannelQueryRequest::getChannelNo).filter(Objects::nonNull).collect(Collectors.toList());
            List<ChannelBusiness> channelBusinesses = this.channelBusinessService.queryByChannelNo(channelNos);
            this.accountCacheService.updateAccountList(ChannelBusinessMapperUtil.map(channelBusinesses));
        }
        catch (Exception e) {
            logger.info("ChannelController.update error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
    }
}

