/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.entity.ChannelBusiness;
import com.xunlei.channel.api.basechannel.service.AccountCacheService;
import com.xunlei.channel.api.basechannel.service.ChannelBusinessService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.basechannel.utils.ChannelBusinessMapperUtil;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/channel_business"}, produces={"text/html;charset=UTF-8"})
public class ChannelBusinessController {
    private static final Logger logger = LoggerFactory.getLogger(ChannelBusinessController.class);
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private ChannelBusinessService channelBusinessService;
    @Autowired
    private AccountCacheService accountCacheService;

    @RequestMapping(value={"/query_biz"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    private String query_biz(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        logger.info("\u4e1a\u52a1\u63a5\u5165\u6e20\u9053\u67e5\u8be2\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        ChannelBusiness data = (ChannelBusiness)JSON.parseObject((String)json, ChannelBusiness.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<ChannelBusiness> result = this.channelBusinessService.queryChannelByBiz(data);
            for (ChannelBusiness channelBusiness : result) {
                String selected = "";
                String[] accountArray = channelBusiness.getAccountNo().split(",");
                ChannelBusiness channelBizQuery = new ChannelBusiness();
                channelBizQuery.setBizNo(channelBusiness.getBizNo());
                channelBizQuery.setChannelNo(channelBusiness.getChannelNo());
                channelBizQuery.setServiceNo(channelBusiness.getServiceNo());
                channelBizQuery.setProviderNo(channelBusiness.getProviderNo());
                channelBizQuery.setBizStatus("Y");
                channelBizQuery.setChannelStatus("Y");
                channelBizQuery.setAccountStatus("Y");
                channelBizQuery.setSelected("Y");
                for (String account : accountArray) {
                    channelBizQuery.setAccountNo(account);
                    List<ChannelBusiness> channelBusinessList = this.channelBusinessService.queryByNo(channelBizQuery);
                    selected = channelBusinessList.size() > 0 ? selected + "Y," : selected + "N,";
                }
                channelBusiness.setSelected(selected.substring(0, selected.length() - 1));
            }
            return JsonResult.getResult(result);
        }
        catch (Exception e) {
            logger.info("AccountController.query error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/biz_update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        int insert = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        logger.info("\u4e1a\u52a1\u63a5\u5165\u6e20\u9053\u4fee\u6539\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        List data = JSON.parseArray((String)json, ChannelBusiness.class);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<ChannelBusiness> channelBizList;
            ChannelBusiness channelBusinessQuery;
            if (data.size() > 0) {
                channelBusinessQuery = new ChannelBusiness();
                channelBusinessQuery.setBizNo(((ChannelBusiness)data.get(0)).getBizNo());
                channelBusinessQuery.setSelected("Y");
                channelBusinessQuery.setBizStatus("Y");
                channelBusinessQuery.setAccountStatus("Y");
                channelBusinessQuery.setChannelStatus("Y");
                channelBizList = this.channelBusinessService.queryByNo(channelBusinessQuery);
                for (ChannelBusiness channelBusiness : channelBizList) {
                    channelBusiness.setSelected("N");
                    this.channelBusinessService.updateStatus(channelBusiness);
                }
                for (ChannelBusiness channelBiz : data) {
                    if (StringUtils.isEmpty((Object)channelBiz.getServiceNo()) || StringUtils.isEmpty((Object)channelBiz.getChannelNo()) || StringUtils.isEmpty((Object)channelBiz.getAccountNo())) continue;
                    ChannelBusiness channelBizQuery = new ChannelBusiness();
                    channelBizQuery.setBizNo(channelBiz.getBizNo());
                    channelBizQuery.setAccountNo(channelBiz.getAccountNo());
                    channelBizQuery.setChannelNo(channelBiz.getChannelNo());
                    channelBizQuery.setProviderNo(channelBiz.getProviderNo());
                    channelBizQuery.setServiceNo(channelBiz.getServiceNo());
                    channelBizQuery.setBizStatus("Y");
                    channelBizQuery.setChannelStatus("Y");
                    channelBizQuery.setAccountStatus("Y");
                    List<ChannelBusiness> channelBusinessList = this.channelBusinessService.queryByNo(channelBizQuery);
                    if (channelBusinessList.size() == 0) {
                        channelBiz.setSelected("Y");
                        channelBiz.setBizStatus("Y");
                        channelBiz.setChannelStatus("Y");
                        channelBiz.setAccountStatus("Y");
                        insert = this.channelBusinessService.insert(channelBiz);
                        continue;
                    }
                    channelBizQuery.setSelected("Y");
                    this.channelBusinessService.updateStatus(channelBiz);
                }
            }
            channelBusinessQuery = new ChannelBusiness();
            channelBusinessQuery.setBizNo(((ChannelBusiness)data.get(0)).getBizNo());
            channelBizList = this.channelBusinessService.queryByNo(channelBusinessQuery);
            this.accountCacheService.updateAccountList(ChannelBusinessMapperUtil.map(channelBizList));
        }
        catch (Exception e) {
            logger.info("ChannelBusinessController.update error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
    }
}

