/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.channel.api.basechannel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xunlei.channel.api.basechannel.constants.Constants;
import com.xunlei.channel.api.basechannel.controller.BizController;
import com.xunlei.channel.api.basechannel.entity.BizLine;
import com.xunlei.channel.api.basechannel.entity.BizLineQueryRequest;
import com.xunlei.channel.api.basechannel.service.BizLineService;
import com.xunlei.channel.api.basechannel.service.CommonService;
import com.xunlei.channel.api.basechannel.service.SignUtilsService;
import com.xunlei.channel.api.entity.JsonResult;
import com.xunlei.channel.api.entity.ReturnResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/basechannel/biz_line"}, produces={"text/html;charset=UTF-8"})
public class BizLineController {
    private static final Logger logger = LoggerFactory.getLogger(BizController.class);
    @Autowired
    private BizLineService bizLineService;
    @Autowired
    private SignUtilsService signUtilsService;
    @Autowired
    private CommonService commonService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String query(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        BizLineQueryRequest data = (BizLineQueryRequest)JSON.parseObject((String)json, BizLineQueryRequest.class);
        logger.info("\u4e1a\u52a1\u7ebf\u67e5\u8be2\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<BizLine> result = this.bizLineService.query(data);
            return JsonResult.getResult(result);
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
    }

    @RequestMapping(value={"/insert"}, method={RequestMethod.POST}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String insert(@RequestBody String jsonStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        BizLineQueryRequest data = (BizLineQueryRequest)JSON.parseObject((String)json, BizLineQueryRequest.class);
        logger.info("\u4e1a\u52a1\u7ebf\u65b0\u589e\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        int insert = 0;
        try {
            List<BizLine> bizLinesList = this.bizLineService.findBusinessLine(data);
            if (bizLinesList.size() > 0) {
                return JsonResult.getResult((int)ReturnResult.DATA_ALREADY_EXISTS.getCode(), (String)ReturnResult.DATA_ALREADY_EXISTS.getMessage(), (String)("\u4e1a\u52a1\u7ebf\u540d\u79f0\uff1a" + data.getBizLineName() + ReturnResult.DATA_ALREADY_EXISTS.getDescribe()), null);
            }
            String businessLineNo = this.commonService.getCommonNo(Constants.COLUMN_BUSINESS_LINE_NO, Constants.TABLE_NAME_BUSINESS_LINE);
            data.setBizLineNo(businessLineNo);
            insert = this.bizLineService.insert(data);
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (insert > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)"\u65b0\u589e\u6210\u529f");
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String delete(@RequestBody String jsonStr) {
        int delete = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        List list = JSON.parseArray((String)json, BizLineQueryRequest.class);
        logger.info("\u4e1a\u52a1\u7ebf\u5220\u9664\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            for (BizLineQueryRequest result : list) {
                delete = this.bizLineService.delete(result);
            }
        }
        catch (Exception e) {
            logger.info("AccountController.delete error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (delete > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    private String update(@RequestBody String jsonStr) {
        int update = 0;
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String timestamp = jsonObject.getString("timestamp");
        String appId = jsonObject.getString("appId");
        String sign = jsonObject.getString("sign");
        String json = jsonObject.getString("result");
        BizLineQueryRequest data = (BizLineQueryRequest)JSON.parseObject((String)json, BizLineQueryRequest.class);
        logger.info("\u4e1a\u52a1\u7ebf\u4fee\u6539\u63a5\u53d7\u7684\u8bf7\u6c42\u5b57\u7b26\u4e32\uff1a" + json);
        boolean match = this.signUtilsService.checkSign(timestamp, appId, sign);
        if (!match) {
            return JsonResult.getResult((int)ReturnResult.CHECK_SIGN_ERROR.getCode(), (String)ReturnResult.CHECK_SIGN_ERROR.getDescribe(), (String)ReturnResult.CHECK_SIGN_ERROR.getMessage(), null);
        }
        try {
            List<BizLine> bizLineList = this.bizLineService.findBusinessLine(data);
            if (bizLineList.size() != 0) {
                if (bizLineList.get(0).getBizLineName().equals(data.getBizLineName()) && bizLineList.get(0).getMerchantsNo().equals(data.getMerchantsNo()) && bizLineList.get(0).getContract().equals(data.getContract()) && bizLineList.get(0).getPhone().equals(data.getPhone()) && bizLineList.get(0).getContractInfo().equals(data.getContractInfo()) && bizLineList.get(0).getRemark().equals(data.getRemark())) {
                    if (!bizLineList.get(0).getBizLineNo().equals(data.getBizLineNo())) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u4e1a\u52a1\u7ebf\u540d\u79f0\uff1a " + data.getBizLineName() + "\u5df2\u5b58\u5728"), null);
                    }
                    update = 1;
                } else {
                    if (!bizLineList.get(0).getBizLineNo().equals(data.getBizLineNo())) {
                        return JsonResult.getResult((int)1, (String)"", (String)("\u4e1a\u52a1\u7ebf\u540d\u79f0\uff1a " + data.getBizLineName() + "\u5df2\u5b58\u5728"), null);
                    }
                    update = this.bizLineService.update(data);
                }
            } else {
                update = this.bizLineService.update(data);
            }
        }
        catch (Exception e) {
            logger.info("AccountController.update error:{}", (Object)e.toString());
            return JsonResult.getResult((int)ReturnResult.SYSTEM_ERROR.getCode(), (String)ReturnResult.SYSTEM_ERROR.getMessage(), (String)ReturnResult.SYSTEM_ERROR.getDescribe(), null);
        }
        if (update > 0) {
            return JsonResult.getResult((int)0, (String)"", (String)"", (Object)ReturnResult.SUCCESS);
        }
        return JsonResult.getResult((int)1, (String)"", (String)"", (Object)ReturnResult.SYSTEM_ERROR);
    }
}

